/*
 * Decompiled with CFR 0.152.
 */
package neural;

import java.util.ArrayList;
import java.util.List;
import neural.DataSet;
import neural.Sigmoid;

public class Net2 {
    private double _learnRate;
    private double _momentum;
    private static final int VALUE = 0;
    private static final int BIAS = 1;
    private static final int BIASDELTA = 2;
    private static final int GRADIENT = 3;
    private static final int WEIGHT = 0;
    private static final int DELTA = 1;
    private int _inputSize;
    private double[][] _input;
    private double[][][] _input_hidden;
    private int _hiddenSize;
    private double[][] _hidden;
    private double[][][] _hidden_output;
    private int _outputSize;
    private double[][] _output;

    public Net2(int inputSize, int hiddenSize, int outputSize, Double learnRate, Double momentum) {
        this._learnRate = learnRate == null ? 0.4 : learnRate;
        this._momentum = momentum == null ? 0.9 : momentum;
        this._inputSize = inputSize;
        this._input = new double[4][inputSize];
        this._input_hidden = new double[2][inputSize][hiddenSize];
        this._hiddenSize = hiddenSize;
        this._hidden = new double[4][hiddenSize];
        this._hidden_output = new double[2][hiddenSize][outputSize];
        this._outputSize = outputSize;
        this._output = new double[4][outputSize];
        for (int i = 0; i < this._inputSize; ++i) {
            this._input[1][i] = Math.random();
        }
        for (int j = 0; j < this._hiddenSize; ++j) {
            this._hidden[1][j] = Math.random();
            for (int i = 0; i < this._inputSize; ++i) {
                this._input_hidden[0][i][j] = Math.random();
            }
            for (int k = 0; k < this._outputSize; ++k) {
                this._hidden_output[0][j][k] = Math.random();
            }
        }
        for (int k = 0; k < this._outputSize; ++k) {
            this._output[1][k] = Math.random();
        }
    }

    public void Train(List<DataSet> dataSets, int numEpochs) {
        for (int i = 0; i < numEpochs; ++i) {
            for (DataSet dataSet : dataSets) {
                this.ForwardPropagate(dataSet.Values);
                this.BackPropagate(dataSet.Targets);
            }
        }
    }

    public void Train(List<DataSet> dataSets, double minimumError) {
        double error = 1.0;
        for (double numEpochs = 0.0; error > minimumError && numEpochs < 2.147483647E9; numEpochs += 1.0) {
            ArrayList<Double> errors = new ArrayList<Double>();
            for (DataSet dataSet : dataSets) {
                this.ForwardPropagate(dataSet.Values);
                this.BackPropagate(dataSet.Targets);
                errors.add(this.CalculateError(dataSet.Targets));
            }
            double sum = 0.0;
            int errorsSize = errors.size();
            for (int i = 0; i < errorsSize; ++i) {
                Double eachError = (Double)errors.get(i);
                sum += eachError.doubleValue();
            }
            error = sum / (double)errors.size();
        }
    }

    private void ForwardPropagate(double[] inputs) {
        double sum;
        for (int i = 0; i < this._inputSize; ++i) {
            this._input[0][i] = inputs[i];
        }
        for (int j = 0; j < this._hiddenSize; ++j) {
            sum = 0.0;
            for (int i = 0; i < this._inputSize; ++i) {
                sum += this._input_hidden[0][i][j] * this._input[0][i];
            }
            this._hidden[0][j] = Sigmoid.Output(sum + this._hidden[1][j]);
        }
        for (int k = 0; k < this._outputSize; ++k) {
            sum = 0.0;
            for (int j = 0; j < this._hiddenSize; ++j) {
                sum += this._hidden_output[0][j][k] * this._hidden[0][j];
            }
            this._output[0][k] = Sigmoid.Output(sum + this._output[1][k]);
        }
    }

    private void BackPropagate(double[] targets) {
        double newDelta;
        double lastDelta;
        int j;
        int k;
        for (k = 0; k < this._outputSize; ++k) {
            double value = this._output[0][k];
            this._output[3][k] = (targets[k] - value) * Sigmoid.Derivative(value);
        }
        for (j = 0; j < this._hiddenSize; ++j) {
            double sum = 0.0;
            for (int k2 = 0; k2 < this._outputSize; ++k2) {
                sum += this._output[3][k2] * this._hidden_output[0][j][k2];
            }
            this._hidden[3][j] = sum * Sigmoid.Derivative(this._hidden[0][j]);
        }
        for (j = 0; j < this._hiddenSize; ++j) {
            lastDelta = this._hidden[2][j];
            double gradient = this._hidden[3][j];
            this._hidden[2][j] = newDelta = this._learnRate * gradient;
            double[] dArray = this._hidden[1];
            int n = j;
            dArray[n] = dArray[n] + (newDelta + this._momentum * lastDelta);
            for (int i = 0; i < this._inputSize; ++i) {
                this._input_hidden[1][i][j] = this._learnRate * this._input[3][i] * this._input[0][i];
                this._input_hidden[0][i][j] = this._input_hidden[0][i][j] + this._input_hidden[1][i][j] + this._momentum * this._input_hidden[1][i][j];
            }
        }
        for (k = 0; k < this._outputSize; ++k) {
            lastDelta = this._output[2][k];
            double gradient = this._output[3][k];
            this._output[2][k] = newDelta = this._learnRate * gradient;
            double[] dArray = this._output[1];
            int n = k;
            dArray[n] = dArray[n] + (newDelta + this._momentum * lastDelta);
            for (int j2 = 0; j2 < this._hiddenSize; ++j2) {
                this._hidden_output[1][j2][k] = this._learnRate * this._hidden[3][j2] * this._hidden[0][j2];
                this._hidden_output[0][j2][k] = this._hidden_output[0][j2][k] + this._hidden_output[1][j2][k] + this._momentum * this._hidden_output[1][j2][k];
            }
        }
    }

    public double[] Compute(double[] inputs) {
        this.ForwardPropagate(inputs);
        double[] output = new double[this._outputSize];
        for (int k = 0; k < this._outputSize; ++k) {
            output[k] = this._output[0][k];
        }
        return output;
    }

    private double CalculateError(double[] targets) {
        double error = 0.0;
        for (int k = 0; k < this._outputSize; ++k) {
            error += Math.abs(targets[k] - this._output[0][k]);
        }
        return error;
    }
}

