/*
 * Decompiled with CFR 0.152.
 */
package labg.movement;

import java.util.Random;
import labg.movement.MovementStrategy;
import labg.util.Enemy;
import labg.util.EvolutionManager;
import labg.util.Geometry;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

public class DodgerMovementStrategy
extends MovementStrategy {
    AdvancedRobot myBot;
    Enemy target;
    int step = 1;
    private Random numGen;
    EvolutionManager evoMan;
    boolean countDownMode = false;
    boolean firstTime = true;
    boolean newIntMove = true;
    private double currBulletPower = 0.0;
    private long bulletArriveTime = 0L;
    private double gotoX;
    private double gotoY;
    private double moveX;
    private double moveY;

    public DodgerMovementStrategy(AdvancedRobot myBot, Enemy target, EvolutionManager evoMan) {
        super(myBot);
        this.myBot = myBot;
        this.target = target;
        this.numGen = new Random();
        this.evoMan = evoMan;
        this.gotoX = myBot.getX();
        this.gotoY = myBot.getY();
    }

    public void move() {
        if (this.countDownMode) {
            if (this.bulletArriveTime - this.myBot.getTime() <= 15L) {
                this.dodge();
                this.countDownMode = false;
            } else if (this.target.prevEnergy - this.target.currEnergy < -0.5) {
                this.dodge();
                this.countDownMode = false;
            }
        } else if (this.target.prevEnergy - this.target.currEnergy >= 0.09) {
            this.currBulletPower = this.target.prevEnergy - this.target.currEnergy;
            this.bulletArriveTime = (long)((double)this.myBot.getTime() + this.target.distance / (20.0 - 3.0 * this.currBulletPower));
            if (this.myBot.getDistanceRemaining() == 0.0) {
                this.countDownMode = true;
            }
        }
    }

    private void dodge() {
        if (this.firstTime) {
            this.firstTime = false;
            this.gotoX = this.myBot.getX();
            this.gotoY = this.myBot.getY();
        }
        if (Math.abs(this.myBot.getX() - this.gotoX) < 36.0 && Math.abs(this.myBot.getY() - this.gotoY) < 36.0) {
            double rand = this.numGen.nextDouble();
            double offsetAng = 0.0;
            offsetAng = this.target.distance > 300.0 ? (rand > 0.5 ? 0.39269908169872414 : -0.39269908169872414) : (rand > 0.5 ? -0.39269908169872414 : 0.39269908169872414);
            int dist = this.numGen.nextInt(170);
            double gravAngle = (this.myBot.getHeadingRadians() + this.target.currBearing + 1.5707963267948966 + offsetAng) % (Math.PI * 2);
            if (Geometry.getRange(this.myBot.getX(), this.myBot.getY(), this.myBot.getBattleFieldWidth() / 2.0, this.myBot.getBattleFieldHeight() / 2.0) > this.myBot.getBattleFieldWidth() / 3.0) {
                double distTwo;
                double gotoX1 = this.myBot.getX() - Math.sin(gravAngle) * (double)(60 + dist);
                double gotoY1 = this.myBot.getY() - Math.cos(gravAngle) * (double)(60 + dist);
                double gotoX2 = this.myBot.getX() - Math.sin(gravAngle) * (double)(-60 - dist);
                double gotoY2 = this.myBot.getY() - Math.cos(gravAngle) * (double)(-60 - dist);
                double distOne = Geometry.getRange(gotoX1, gotoY1, this.myBot.getBattleFieldWidth() / 2.0, this.myBot.getBattleFieldHeight() / 2.0);
                if (distOne < (distTwo = Geometry.getRange(gotoX2, gotoY2, this.myBot.getBattleFieldWidth() / 2.0, this.myBot.getBattleFieldHeight() / 2.0))) {
                    this.gotoX = gotoX1;
                    this.gotoY = gotoY1;
                } else {
                    this.gotoX = gotoX2;
                    this.gotoY = gotoY2;
                }
            } else if (rand < 0.5) {
                this.gotoX = this.myBot.getX() - Math.sin(gravAngle) * (double)(100 + dist);
                this.gotoY = this.myBot.getY() - Math.cos(gravAngle) * (double)(100 + dist);
            } else {
                this.gotoX = this.myBot.getX() - Math.sin(gravAngle) * (double)(-100 - dist);
                this.gotoY = this.myBot.getY() - Math.cos(gravAngle) * (double)(-100 - dist);
            }
            if (this.gotoX <= 50.0) {
                this.gotoX = 60.0;
            }
            if (this.gotoX >= this.myBot.getBattleFieldWidth() - 50.0) {
                this.gotoX = this.myBot.getBattleFieldWidth() - 60.0;
            }
            if (this.gotoY <= 50.0) {
                this.gotoY = 60.0;
            }
            if (this.gotoY >= this.myBot.getBattleFieldHeight() - 50.0) {
                this.gotoY = this.myBot.getBattleFieldHeight() - 60.0;
            }
            Geometry.goToPoint(this.myBot, this.gotoX, this.gotoY);
        } else {
            Geometry.goToPoint(this.myBot, this.gotoX, this.gotoY);
        }
    }

    public void setEnemy(Enemy foe) {
        this.target = foe;
    }

    public Enemy getEnemy() {
        return this.target;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
    }

    public void onHitByBullet(HitByBulletEvent e) {
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
    }

    public void onBulletHit(BulletHitEvent e) {
    }

    public void onBulletMissed(BulletMissedEvent e) {
    }

    public void onDeath(DeathEvent e) {
    }

    public void onHitRobot(HitRobotEvent e) {
    }

    public void onHitWall(HitWallEvent e) {
    }

    public void onRobotDeath(RobotDeathEvent e) {
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
    }

    public void onWin(WinEvent e) {
    }
}

