/*
 * Decompiled with CFR 0.152.
 */
package labg.util;

import java.awt.geom.Point2D;
import java.util.Random;
import labg.Cataclysm;
import labg.movement.GravPoint;
import labg.util.EvolutionManager;
import labg.util.Geometry;

public class EnemyBullet {
    public double xPos = 0.0;
    public double yPos = 0.0;
    public double heading;
    public double velocity;
    public double newX;
    public double newY;
    public double myX;
    public double myY;
    public double myHeading;
    Cataclysm myBot;
    long initTime;
    Random numGen;
    Point2D.Double currPoint;
    Point2D.Double prevPoint;
    Point2D.Double predPoint;
    Point2D.Double newPredPoint;
    public double predHeading;
    EvolutionManager evoMan;
    double bullPower;

    public EnemyBullet(Cataclysm myBot, EvolutionManager evoMan, double heading, double myHeading, double velocity, double initialX, double initialY, double myX, double myY, long initTime) {
        this.xPos = initialX;
        this.yPos = initialY;
        this.heading = heading;
        this.velocity = velocity;
        this.myBot = myBot;
        this.initTime = initTime;
        this.numGen = new Random();
        this.myX = myX;
        this.myY = myY;
        this.myHeading = myHeading;
        this.predPoint = new Point2D.Double(0.0, 0.0);
        this.newPredPoint = new Point2D.Double(0.0, 0.0);
        this.evoMan = evoMan;
        this.bullPower = (20.0 - velocity) / 3.0;
        this.predPos();
    }

    public int updatePosition() {
        this.newX = this.xPos - Math.sin(this.heading) * (this.velocity * (double)(this.myBot.getTime() - this.initTime));
        this.newY = this.yPos - Math.cos(this.heading) * (this.velocity * (double)(this.myBot.getTime() - this.initTime));
        this.newPredPoint.x = this.xPos + Math.sin(this.predHeading) * (this.velocity * (double)(this.myBot.getTime() - this.initTime));
        this.newPredPoint.y = this.yPos + Math.cos(this.predHeading) * (this.velocity * (double)(this.myBot.getTime() - this.initTime));
        if (this.newX < 0.0 || this.newX > this.myBot.getBattleFieldWidth()) {
            return -1;
        }
        if (this.newY < 0.0 || this.newY > this.myBot.getBattleFieldHeight()) {
            return -1;
        }
        return 1;
    }

    public double getTicksToImpact() {
        double t = this.myBot.getTime() - this.initTime;
        double arrive = Geometry.getRange(this.xPos, this.yPos, this.myX, this.myY) / this.velocity;
        return arrive - t;
    }

    private void predPos() {
        long currTime = this.myBot.getTime() + (long)((int)Math.round(Geometry.getRange(this.myBot.getX(), this.myBot.getY(), this.xPos, this.yPos) / this.velocity));
        this.currPoint = this.myBot.currHeading - this.myBot.prevHeading < 1.0E-4 ? this.myBot.guessPosition(currTime) : this.myBot.guessCircularPosition(currTime);
        int i = 0;
        while (i < 10) {
            long prevTime = currTime;
            this.prevPoint = this.currPoint;
            currTime = this.myBot.getTime() + (long)((int)Math.round(Geometry.getRange(this.xPos, this.yPos, this.prevPoint.x, this.prevPoint.y) / this.velocity));
            this.currPoint = this.myBot.currHeading - this.myBot.prevHeading < 1.0E-4 ? this.myBot.guessPosition(currTime) : this.myBot.guessCircularPosition(currTime);
            ++i;
        }
        if (this.currPoint.x < 0.0) {
            this.currPoint.x = 0.0;
        } else if (this.currPoint.x > this.myBot.getBattleFieldWidth()) {
            this.currPoint.x = this.myBot.getBattleFieldWidth();
        }
        if (this.currPoint.y < 0.0) {
            this.currPoint.y = 0.0;
        } else if (this.currPoint.y > this.myBot.getBattleFieldHeight()) {
            this.currPoint.y = this.myBot.getBattleFieldHeight();
        }
        this.predHeading = Geometry.absbearing(this.xPos, this.yPos, this.currPoint.x, this.currPoint.y);
        this.predPoint.x = this.currPoint.x;
        this.predPoint.y = this.currPoint.y;
        this.newPredPoint.x = this.predPoint.x;
        this.newPredPoint.y = this.predPoint.y;
    }

    public GravPoint[] getGravPoints() {
        double yFactor = this.myBot.getBattleFieldHeight() / 10.0;
        double xFactor = this.myBot.getBattleFieldWidth() / 10.0;
        double leftX = this.newX - Math.sin(this.heading + 1.5707963267948966) * this.evoMan.getVariable("xDist1");
        double leftY = this.newY - Math.cos(this.heading + 1.5707963267948966) * this.evoMan.getVariable("yDist1");
        double leftPredX = this.predPoint.x - Math.sin(this.predHeading + 1.5707963267948966) * this.evoMan.getVariable("xDist1");
        double leftPredY = this.predPoint.y - Math.cos(this.predHeading + 1.5707963267948966) * this.evoMan.getVariable("yDist1");
        double rightX = this.newX - Math.sin(this.heading + 1.5707963267948966) * this.evoMan.getVariable("xDist2");
        double rightY = this.newY - Math.cos(this.heading + 1.5707963267948966) * this.evoMan.getVariable("yDist2");
        double rightPredX = this.predPoint.x - Math.sin(this.predHeading + 1.5707963267948966) * this.evoMan.getVariable("xDist2");
        double rightPredY = this.predPoint.y - Math.cos(this.predHeading + 1.5707963267948966) * this.evoMan.getVariable("yDist2");
        GravPoint centGravPoint = null;
        GravPoint centPredGravPoint = null;
        GravPoint leftGravPoint = null;
        GravPoint rightGravPoint = null;
        Object leftPredGravPoint = null;
        Object rightPredGravPoint = null;
        if (this.myBot.getOthers() != 1) {
            centGravPoint = new GravPoint(this.newX, this.newY, -1000.0 * this.bullPower * (double)this.myBot.getOthers(), 1L, 2.0);
            leftGravPoint = new GravPoint(leftX, leftY, 1500.0 * this.bullPower * (double)this.myBot.getOthers(), 1L, 2.0);
            rightGravPoint = new GravPoint(rightX, rightY, 1500.0 * this.bullPower * (double)this.myBot.getOthers(), 1L, 2.0);
        } else {
            centGravPoint = new GravPoint(this.newX, this.newY, -1000.0, 1L, 2.0);
            centPredGravPoint = new GravPoint(this.newPredPoint.x, this.newPredPoint.y, -2000.0, 1L, 2.0);
            leftGravPoint = new GravPoint(leftX, leftY, 1500.0, 1L, 2.0);
            rightGravPoint = new GravPoint(rightX, rightY, 1500.0, 1L, 2.0);
        }
        GravPoint[] gravs = new GravPoint[6];
        gravs[0] = centGravPoint;
        if (centPredGravPoint != null) {
            gravs[3] = centPredGravPoint;
        }
        double leftDist = 0.0;
        double rightDist = 0.0;
        boolean trig = false;
        if (leftX > xFactor && leftX < this.myBot.getBattleFieldWidth() - xFactor) {
            if (leftY > yFactor && leftY < this.myBot.getBattleFieldHeight() - yFactor) {
                gravs[1] = leftGravPoint;
            } else {
                trig = true;
                leftDist = Geometry.getRange(leftX, leftY, this.myBot.getBattleFieldWidth() / 2.0, this.myBot.getBattleFieldHeight() / 2.0);
            }
        } else {
            trig = true;
            leftDist = Geometry.getRange(leftX, leftY, this.myBot.getBattleFieldWidth() / 2.0, this.myBot.getBattleFieldHeight() / 2.0);
        }
        if (rightX > xFactor && rightX < this.myBot.getBattleFieldWidth() - xFactor) {
            if (rightY > yFactor && rightY < this.myBot.getBattleFieldHeight() - yFactor) {
                gravs[2] = rightGravPoint;
            } else {
                trig = true;
                rightDist = Geometry.getRange(rightX, rightY, this.myBot.getBattleFieldWidth() / 2.0, this.myBot.getBattleFieldHeight() / 2.0);
            }
        } else {
            trig = true;
            rightDist = Geometry.getRange(rightX, rightY, this.myBot.getBattleFieldWidth() / 2.0, this.myBot.getBattleFieldHeight() / 2.0);
        }
        if (trig) {
            trig = false;
            if (leftDist > rightDist) {
                gravs[2] = rightGravPoint;
            } else {
                gravs[1] = leftGravPoint;
            }
        }
        return gravs;
    }
}

