/*
 * Decompiled with CFR 0.152.
 */
package labg.util;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import labg.util.Candidate;

public class EvolvableValue
implements Serializable {
    String name;
    double startVal;
    double evolvedVal;
    double statEvolvedVal;
    double lower;
    double upper;
    double origLower;
    double origUpper;
    boolean isOptim = false;
    double bestResult;
    Vector results;
    double increment;
    double howManyValues = 1.0;
    boolean currentlyEvolving = false;

    public EvolvableValue(String name, double startVal, double lower, double upper) {
        this.name = name;
        this.startVal = startVal;
        this.lower = lower;
        this.upper = upper;
        this.origLower = lower;
        this.origUpper = upper;
        this.bestResult = 0.0;
        this.results = new Vector();
        this.evolvedVal = lower;
        this.statEvolvedVal = startVal;
    }

    public double getEvolvedValue() {
        if (this.currentlyEvolving) {
            return this.evolvedVal;
        }
        return this.statEvolvedVal;
    }

    public double getStartValue() {
        return this.startVal;
    }

    public void doEvolution() {
        this.increment = (this.upper - this.lower) / this.howManyValues;
        if (!(this.evolvedVal + this.increment > this.upper)) {
            this.evolvedVal += this.increment;
            System.out.println("Evolved value " + this.name + " to " + this.evolvedVal);
        } else {
            this.isOptim = true;
            this.statEvolvedVal = this.evolvedVal = ((Candidate)this.results.get((int)(this.results.size() - 1))).varVal;
            System.out.println("Setting " + this.name + " to best value " + this.evolvedVal);
        }
    }

    public void addResult(double score1) {
        Candidate score = new Candidate(this.evolvedVal, score1);
        this.results.add(score);
        Collections.sort(this.results);
        if ((double)this.results.size() > this.howManyValues / 2.0 || this.results.size() > 20) {
            this.results.removeElementAt(0);
        }
        Enumeration e = this.results.elements();
        while (e.hasMoreElements()) {
            System.out.println(e.nextElement());
        }
    }

    public void enableEvolution(boolean enable) {
    }

    public boolean isOptimized() {
        return this.isOptim;
    }

    public void setOptimized(boolean o) {
        this.isOptim = o;
    }

    public void useStartValue(boolean sv) {
    }

    public void setHowManyValues(double d) {
        this.howManyValues = d;
    }

    public void reset() {
        this.isOptim = false;
        double currLow = 9.99999999E8;
        double currHigh = -9.99999999E8;
        int i = 0;
        while (i < this.results.size()) {
            double tmpVal = ((Candidate)this.results.get((int)i)).varVal;
            if (tmpVal <= currLow) {
                currLow = tmpVal;
            }
            if (tmpVal >= currHigh) {
                currHigh = tmpVal;
            }
            ++i;
        }
        this.lower = currLow;
        this.upper = currHigh;
        this.evolvedVal = this.lower;
        this.results.removeAllElements();
    }

    public void print(PrintStream ps) {
        ps.println("Variable: " + this.name + "; " + "Start Value = " + this.startVal + " Evolved Value = " + this.evolvedVal);
    }
}

