/*
 * Decompiled with CFR 0.152.
 */
package tvv.nano;

import java.awt.Color;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public final class Polaris
extends AdvancedRobot {
    private static final int POLARIS_RGB = 16774122;
    private static final double MAX_FIRE_DISTANCE = 400.0;
    private static final double MOVE_DISTANCE = 160.0;
    private static final double PI_DIV_2 = 1.5707963267948966;
    private static final double PI_DIV_4 = 0.7853981633974483;
    private static final double PI_DIV_12 = 0.2617993877991494;
    private static final double PI_DIV_1920 = 0.0016362461737446838;
    private double direction;

    public void run() {
        this.direction = 160.0;
        this.setAllColors(new Color(16774122));
        this.setAdjustGunForRobotTurn(true);
        this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
        this.setTurnRadarLeftRadians(this.getRadarTurnRemainingRadians());
        double d = this.getHeadingRadians() + scannedRobotEvent.getBearingRadians();
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(d - this.getGunHeadingRadians() + StrictMath.signum(scannedRobotEvent.getEnergy()) * (StrictMath.random() - 0.5) * 0.7853981633974483 + StrictMath.sin(scannedRobotEvent.getHeadingRadians() - d) * scannedRobotEvent.getVelocity() / 16.0)));
        if (scannedRobotEvent.getDistance() < 400.0 && Utils.isNear((double)this.getGunHeat(), (double)0.0) && this.getEnergy() > 0.1 && Math.abs(this.getGunTurnRemainingRadians()) < 0.2617993877991494) {
            this.setFire(StrictMath.max(StrictMath.min(StrictMath.min(400.0 / scannedRobotEvent.getDistance(), 3.0), StrictMath.min(this.getEnergy(), scannedRobotEvent.getEnergy())), 0.1));
        }
        this.setTurnRightRadians(Utils.normalRelativeAngle((double)(scannedRobotEvent.getBearingRadians() + 1.5707963267948966 - this.direction * 0.0016362461737446838)));
        if (Utils.isNear((double)this.getVelocity(), (double)0.0)) {
            this.direction = -this.direction;
            this.setAhead(this.direction);
        }
        this.clearAllEvents();
    }
}

