/*
 * Decompiled with CFR 0.152.
 */
package eem.core;

import eem.botVersion;
import eem.gameInfo.gameInfo;
import eem.misc.logger;
import eem.misc.math;
import eem.misc.physics;
import eem.misc.profiler;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.io.IOException;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.RobocodeFileWriter;
import robocode.RobotDeathEvent;
import robocode.RoundEndedEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

public class CoreBot
extends AdvancedRobot {
    public Rules game_rules;
    double BodyTurnRate = 10.0;
    private botVersion botVer;
    public static gameInfo _gameinfo;
    public int numEnemyBotsAlive = 1;
    public long initTicStartTime = 0L;
    public Point2D.Double myCoord;
    double absurdly_huge = 1000000.0;
    double desiredBodyRotationDirection = 0.0;
    public long ticTime;
    public int roundCnt = 0;
    int nonexisting_coord = -10000;
    public int totalNumOfEnemiesAtStart = 0;
    public static int roundsWon;
    public static int roundsLost;
    public static int[] finishingPlacesStats;
    public static int[] skippedTurnStats;
    public static int bulletFiredCnt;
    public static int bulletHitCnt;
    public static int bulletHitByPredictedCnt;
    private static int numTicsWhenGunInColdState;
    private String logFileName = "CoreBot.log";
    public int verbosity_level = 5;
    private static RobocodeFileWriter fileWriter;
    private boolean appendToLogFlag = false;
    public logger _log = null;

    public void initBattle() {
        this.roundCnt = this.getRoundNum() + 1;
        if (fileWriter == null) {
            try {
                fileWriter = new RobocodeFileWriter(this.getDataFile(this.logFileName));
                this._log = new logger(this.verbosity_level, fileWriter);
            }
            catch (IOException iOException) {
                System.out.println("Trouble opening the logging file: " + iOException.getMessage());
                this._log = new logger(this.verbosity_level);
            }
        }
        physics.init(this);
        math.init(this);
        this.setColors(Color.red, Color.blue, Color.green);
        this.botVer = new botVersion();
        this.totalNumOfEnemiesAtStart = this.getOthers();
        if (finishingPlacesStats == null) {
            finishingPlacesStats = new int[this.totalNumOfEnemiesAtStart + 1];
        }
        if (skippedTurnStats == null) {
            skippedTurnStats = new int[this.getNumRounds()];
        }
        logger.routine("=========== Round #" + this.roundCnt + "=============");
        this.myCoord = new Point2D.Double(this.getX(), this.getY());
        if (_gameinfo == null) {
            _gameinfo = new gameInfo(this);
        }
        _gameinfo.initBattle(this);
        this.setEventPriority("ScannedRobotEvent", 98);
        this.initTicStartTime = System.nanoTime();
    }

    public void initTic() {
        this.numEnemyBotsAlive = this.getOthers();
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setTicTime();
        logger.noise("----------- Bot version: " + this.botVer.getVersion() + "------- Tic # " + this.ticTime + " -------------");
        logger.noise("Game time: " + this.ticTime);
        logger.noise("Number of other bots = " + this.numEnemyBotsAlive);
        if (this.numEnemyBotsAlive == 0) {
            return;
        }
        this.myCoord.x = this.getX();
        this.myCoord.y = this.getY();
        profiler.start("_motion.initTic");
        profiler.stop("_motion.initTic");
        profiler.start("_gun.initTic");
        profiler.stop("_gun.initTic");
        _gameinfo.initTic();
    }

    private void setTicTime() {
        this.ticTime = this.getTime();
    }

    public long getTime() {
        return physics.ticTimeFromTurnAndRound(super.getTime(), this.getRoundNum());
    }

    public String fightType() {
        double d = 1.0 * (double)this.numEnemyBotsAlive / (double)this.totalNumOfEnemiesAtStart;
        if (this.numEnemyBotsAlive == 1 && this.totalNumOfEnemiesAtStart == 1) {
            return "1on1";
        }
        if (this.numEnemyBotsAlive == 1 && this.totalNumOfEnemiesAtStart != 1) {
            return "melee1on1";
        }
        if (d > 0.6666666666666666) {
            return "melee";
        }
        return "meleeMidle";
    }

    public double distTo(double d, double d2) {
        double d3 = d - this.myCoord.x;
        double d4 = d2 - this.myCoord.y;
        return Math.sqrt(d3 * d3 + d4 * d4);
    }

    public void run() {
        this.initBattle();
        while (true) {
            this.initTic();
            if (this.getOthers() == 0) {
                this.setAhead(0.0);
                this.setStop();
                this.execute();
                continue;
            }
            _gameinfo.run();
        }
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
        this.setTicTime();
        this.myCoord.x = this.getX();
        this.myCoord.y = this.getY();
        _gameinfo.onScannedRobot(scannedRobotEvent);
    }

    public void onHitByBullet(HitByBulletEvent hitByBulletEvent) {
    }

    public void onBulletHit(BulletHitEvent bulletHitEvent) {
    }

    public void onBulletMissed(BulletMissedEvent bulletMissedEvent) {
    }

    public void onRobotDeath(RobotDeathEvent robotDeathEvent) {
        _gameinfo.onRobotDeath(robotDeathEvent);
    }

    public void onHitWall(HitWallEvent hitWallEvent) {
        this.setTicTime();
        logger.dbg("tic " + this.getTime() + ": shame I hit wall");
    }

    public void onSkippedTurn(SkippedTurnEvent skippedTurnEvent) {
    }

    public void onPaint(Graphics2D graphics2D) {
        _gameinfo.onPaint(graphics2D);
    }

    public void onWin(WinEvent winEvent) {
        this.setTicTime();
        ++roundsWon;
        this.updateFinishingPlacesStats();
        this.winOrLoseRoundEnd();
    }

    public void onDeath(DeathEvent deathEvent) {
        this.setTicTime();
        ++roundsLost;
        this.updateFinishingPlacesStats();
        this.winOrLoseRoundEnd();
    }

    public void onRoundEnded(RoundEndedEvent roundEndedEvent) {
        this.setTicTime();
    }

    public void updateFinishingPlacesStats() {
        int n;
        int n2 = n = this.getOthers();
        finishingPlacesStats[n2] = finishingPlacesStats[n2] + 1;
    }

    public void winOrLoseRoundEnd() {
    }

    static {
        roundsWon = 0;
        roundsLost = 0;
        finishingPlacesStats = null;
        skippedTurnStats = null;
        bulletFiredCnt = 0;
        bulletHitCnt = 0;
        bulletHitByPredictedCnt = 0;
        numTicsWhenGunInColdState = 0;
        fileWriter = null;
    }
}

