/*
 * Decompiled with CFR 0.152.
 */
package amk.motion;

import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class RandomGoTo {
    static final double MAX_VELOCITY = 8.0;
    static final double WALL_MARGIN = 25.0;
    static Point2D robotLocation = new Point2D.Double(100.0, 100.0);
    static Point2D enemyLocation = new Point2D.Double(400.0, 400.0);
    static double enemyDistance = 400.0;
    static double enemyAbsoluteBearing = 180.0;
    static double movementLateralAngle = 0.2;
    static AdvancedRobot master;

    public RandomGoTo(AdvancedRobot bot) {
        master = bot;
    }

    public void move() {
        this.considerChangingDirection();
        Point2D robotDestination = null;
        double tries = 0.0;
        do {
            robotDestination = RandomGoTo.vectorToLocation(amk.util.Utils.absoluteBearing(enemyLocation, robotLocation) + movementLateralAngle, enemyDistance * (1.1 - tries / 100.0), enemyLocation);
        } while ((tries += 1.0) < 100.0 && !RandomGoTo.fieldRectangle(25.0).contains(robotDestination));
        RandomGoTo.goTo(robotDestination);
    }

    void considerChangingDirection() {
        double flattenerFactor = 0.05;
        if (Math.random() < flattenerFactor) {
            movementLateralAngle *= -1.0;
        }
    }

    private static RoundRectangle2D fieldRectangle(double margin) {
        return new RoundRectangle2D.Double(margin, margin, master.getBattleFieldWidth() - margin * 2.0, master.getBattleFieldHeight() - margin * 2.0, 75.0, 75.0);
    }

    public static void goTo(Point2D destination) {
        double angle = Utils.normalRelativeAngle((double)(amk.util.Utils.absoluteBearing(robotLocation, destination) - master.getHeadingRadians()));
        double turnAngle = Math.atan(Math.tan(angle));
        master.setTurnRightRadians(turnAngle);
        master.setAhead(robotLocation.distance(destination) * (double)(angle == turnAngle ? 1 : -1));
        master.setMaxVelocity(Math.abs(master.getTurnRemaining()) > 33.0 ? 0.0 : 8.0);
    }

    private static Point2D vectorToLocation(double angle, double length, Point2D sourceLocation) {
        return RandomGoTo.vectorToLocation(angle, length, sourceLocation, new Point2D.Double());
    }

    private static Point2D vectorToLocation(double angle, double length, Point2D sourceLocation, Point2D targetLocation) {
        targetLocation.setLocation(sourceLocation.getX() + Math.sin(angle) * length, sourceLocation.getY() + Math.cos(angle) * length);
        return targetLocation;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        robotLocation = new Point2D.Double(master.getX(), master.getY());
        enemyAbsoluteBearing = master.getHeadingRadians() + e.getBearingRadians();
        enemyDistance = e.getDistance();
        enemyLocation = RandomGoTo.vectorToLocation(enemyAbsoluteBearing, enemyDistance, robotLocation);
        this.move();
        master.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(enemyAbsoluteBearing - master.getRadarHeadingRadians())) * 2.0);
    }
}

