/*
 * Decompiled with CFR 0.152.
 */
package divineomega;

import divineomega.DivineBot;
import divineomega.guns.AdaptiveGun;
import divineomega.guns.CircularGun;
import divineomega.guns.CircularSpreadGun;
import divineomega.guns.GuessFactorGun;
import divineomega.guns.Gun;
import divineomega.guns.HeadonGun;
import divineomega.guns.HeadonSpreadGun;
import divineomega.guns.LinearGun;
import divineomega.guns.LinearSpreadGun;
import divineomega.guns.PatternMatchingCompoundPredictionGun;
import divineomega.guns.PatternMatchingGun;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class GunManager {
    private static HashMap<String, ArrayList<Gun>> enemyNameToGunList = new HashMap();

    static void initialise(String enemyName, DivineBot robot) {
        ArrayList<Object> gunList = new ArrayList<Gun>();
        gunList.add(new GuessFactorGun(robot));
        gunList.add(new PatternMatchingGun());
        gunList.add(new PatternMatchingCompoundPredictionGun());
        gunList.add(new AdaptiveGun());
        gunList.add(new CircularGun());
        gunList.add(new CircularSpreadGun());
        gunList.add(new LinearGun());
        gunList.add(new LinearSpreadGun());
        gunList.add(new HeadonGun());
        gunList.add(new HeadonSpreadGun());
        ((Gun)gunList.get(0)).setActive(true);
        if (enemyNameToGunList.get(enemyName) == null || enemyNameToGunList.get(enemyName).size() != gunList.size()) {
            enemyNameToGunList.put(enemyName, gunList);
        }
        gunList = enemyNameToGunList.get(enemyName);
        for (Gun gun : gunList) {
            if (!gun.name.equals("GuessFactor")) continue;
            ((GuessFactorGun)gun).setRobot(robot);
        }
        gunList = enemyNameToGunList.put(enemyName, gunList);
    }

    static void setEnemyNameToGunList(HashMap<String, ArrayList<Gun>> enemyNameToGunList) {
        GunManager.enemyNameToGunList = enemyNameToGunList;
    }

    static HashMap<String, ArrayList<Gun>> getEnemyNameToGunList() {
        return enemyNameToGunList;
    }

    static void evaluate(String enemyName, DivineBot robot) {
        Gun activeGun = GunManager.getActiveGun(enemyName, robot);
        double highestRatio = 0.0;
        Gun bestGun = null;
        double ratio = 0.0;
        ArrayList<Gun> gunList = enemyNameToGunList.get(enemyName);
        for (Gun gun : gunList) {
            if (gun.shots > 1000.0) {
                gun.hits = (int)gun.hits / 100;
                gun.shots = (int)gun.shots / 100;
            }
            if (!((ratio = gun.hits / gun.shots) >= highestRatio)) continue;
            highestRatio = ratio;
            bestGun = gun;
        }
        if (bestGun != null && !bestGun.name.equals(activeGun.name)) {
            GunManager.setActiveGun(enemyName, bestGun.name, "best gun");
        }
    }

    public static Gun getActiveGun(String enemyName, DivineBot robot) {
        GunManager.initialise(enemyName, robot);
        ArrayList<Gun> gunList = enemyNameToGunList.get(enemyName);
        for (Gun gun : gunList) {
            if (!gun.isActive()) continue;
            return gun;
        }
        return null;
    }

    public static void setActiveGun(String enemyName, String gunName, String changeReason) {
        DivineBot.output(String.valueOf(enemyName) + " - Gun set to " + gunName + " (" + changeReason + ")");
        ArrayList<Gun> gunList = enemyNameToGunList.get(enemyName);
        for (Gun gun : gunList) {
            if (gun.name.equals(gunName)) {
                gun.setActive(true);
                continue;
            }
            gun.setActive(false);
        }
    }
}

