/*
 * Decompiled with CFR 0.152.
 */
package pedersen.systems;

import pedersen.core.Constraints;
import pedersen.opponent.Target;
import pedersen.physics.StaticPosition;
import pedersen.systems.FireControl;
import pedersen.tactics.targeting.FiringSolution;

public abstract class FireControlBase
implements FireControl {
    public boolean isFiringAdvisable(Target target, double firepower) {
        return true;
    }

    public boolean readyToFire(StaticPosition firingPosition, double turretAbsoluteHeading, Target target, FiringSolution firingSolution) {
        boolean fire = false;
        if (target != null) {
            FireControl fireControl = target.getFireControl();
            if (fireControl == null) {
                fireControl = this;
            }
            if (Constraints.areEqual(turretAbsoluteHeading, firingSolution.getFiringAngle()) && fireControl.isFiringAdvisable(target, firingSolution.getFirepower())) {
                fire = true;
            }
        }
        return fire;
    }
}

