/*
 * Decompiled with CFR 0.152.
 */
package pedersen.tactics.movement;

import pedersen.core.Snapshot;
import pedersen.physics.StaticPosition;
import pedersen.tactics.movement.MovementMethodBase;

public abstract class MovementMethodWaypointBase
extends MovementMethodBase {
    private StaticPosition[] waypoints;
    private int index = 0;
    private boolean clockwise = true;

    protected MovementMethodWaypointBase(int movementMethod) {
        super(movementMethod);
        this.exclusive = true;
    }

    protected void setWaypoints(StaticPosition[] newWaypoints) {
        this.waypoints = newWaypoints;
    }

    protected StaticPosition getWaypoint() {
        return this.waypoints[this.index];
    }

    public void activate(Snapshot chassis) {
        super.activate(chassis);
        this.reverseDirection();
        this.advanceIndex();
        this.reverseDirection();
        int blackoutIndex = this.index;
        double shortestDistance = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < this.waypoints.length) {
            double distance;
            if (i != blackoutIndex && (distance = chassis.getDistance(this.waypoints[i])) < shortestDistance) {
                shortestDistance = distance;
                this.index = i;
            }
            ++i;
        }
    }

    protected void advanceIndex() {
        if (this.clockwise) {
            --this.index;
            if (this.index < 0) {
                this.index = this.waypoints.length - 1;
            }
        } else {
            ++this.index;
            if (this.index > this.waypoints.length - 1) {
                this.index = 0;
            }
        }
    }

    protected void reverseDirection() {
        this.clockwise = !this.clockwise;
    }
}

