/*
 * Decompiled with CFR 0.152.
 */
package florent.XSeries.utils;

import java.awt.geom.Point2D;
import robocode.util.Utils;

public class Force {
    public Point2D.Double origin;
    public Point2D.Double end;

    public Force(Point2D.Double origin, Point2D.Double end) {
        this.origin = new Point2D.Double(origin.x, origin.y);
        this.end = new Point2D.Double(end.x, end.y);
    }

    public void add(Force force) {
        this.end.x += force.end.x - force.origin.x;
        this.end.y += force.end.y - force.origin.y;
    }

    public void multiplyMagnitude(double factor) {
        this.end.x = this.origin.x + (this.end.x - this.origin.x) * factor;
        this.end.y = this.origin.y + (this.end.y - this.origin.y) * factor;
    }

    public void translateTo(Point2D.Double location) {
        Point2D.Double newEnd = new Point2D.Double();
        newEnd.x = location.x + this.end.x - this.origin.x;
        newEnd.y = location.y + this.end.y - this.origin.y;
        this.origin.x = location.x;
        this.origin.y = location.y;
        this.end = newEnd;
    }

    public double getMagnitude() {
        return this.origin.distance(this.end);
    }

    public void rotate(double angle) {
        double angle1 = Utils.normalRelativeAngle((double)(1.5707963267948966 - Math.atan2(this.end.y - this.origin.y, this.end.x - this.origin.x)));
        double magnitude = this.end.distance(this.origin);
        this.end.x = this.origin.x + magnitude * Math.sin(angle + angle1);
        this.end.y = this.origin.y + magnitude * Math.cos(angle + angle1);
    }

    public double scalarProduct(Force force) {
        return (this.end.x - this.origin.x) * (force.end.x - force.origin.x) + (this.end.y - this.origin.y) * (force.end.y - force.origin.y);
    }
}

