/*
 * Decompiled with CFR 0.152.
 */
package lazarecki.mega.index;

import java.awt.geom.RoundRectangle2D;
import lazarecki.mega.index.Index;
import lazarecki.robot.RobotInfo;

public class WallIndex
implements Index {
    private boolean invert;
    private double battleFieldWidth;
    private double battleFieldHeight;

    public WallIndex(double battleFieldWidth, double battleFieldHeight, boolean invert) {
        this.invert = invert;
        this.battleFieldWidth = battleFieldWidth;
        this.battleFieldHeight = battleFieldHeight;
    }

    public double getBattleFieldWidth() {
        return this.battleFieldWidth;
    }

    public double getBattleFieldHeight() {
        return this.battleFieldHeight;
    }

    @Override
    public String getName() {
        return "Wall";
    }

    @Override
    public int getSegmentIndex(RobotInfo me, RobotInfo enemy) {
        if (!this.invert) {
            if (!this.createFieldRectangle(18.0).contains(enemy.getPosition())) {
                return 2;
            }
            if (!this.createFieldRectangle(36.0).contains(enemy.getPosition())) {
                return 1;
            }
            return 0;
        }
        if (!this.createFieldRectangle(18.0).contains(me.getPosition())) {
            return 2;
        }
        if (!this.createFieldRectangle(36.0).contains(me.getPosition())) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getSegments() {
        return 3;
    }

    RoundRectangle2D createFieldRectangle(double margin) {
        return new RoundRectangle2D.Double(margin, margin, this.getBattleFieldWidth() - margin * 2.0, this.getBattleFieldHeight() - margin * 2.0, 75.0, 75.0);
    }
}

