/*
 * Decompiled with CFR 0.152.
 */
package lazarecki.robot.strategy;

import java.awt.geom.Point2D;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import lazarecki.data.DataSegmentWave;
import lazarecki.data.DataSegmentation;
import lazarecki.robot.RobotInfo;
import lazarecki.robot.strategy.AbstractDataModule;
import lazarecki.robot.strategy.HistoryTrackingModule;
import lazarecki.robot.strategy.StrategicModule;
import lazarecki.util.RoboUtils;
import lazarecki.wave.Wave;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.StatusEvent;
import robocode.util.Utils;

public class WaveSurfingModule
extends StrategicModule {
    private AbstractDataModule dataModule;
    private HistoryTrackingModule historyModule;
    private double lastTargetHitPower;
    private List<DataSegmentWave> waves;

    public WaveSurfingModule(AbstractDataModule dataModule, HistoryTrackingModule historyModule) {
        this.dataModule = dataModule;
        this.historyModule = historyModule;
        this.waves = new LinkedList<DataSegmentWave>();
    }

    public AbstractDataModule getDataModule() {
        return this.dataModule;
    }

    public HistoryTrackingModule getHistoryModule() {
        return this.historyModule;
    }

    public List<DataSegmentWave> getWaves() {
        return this.waves;
    }

    @Override
    public void onBulletHit(BulletHitEvent event) {
        this.lastTargetHitPower = event.getBullet().getPower();
    }

    @Override
    public void onHitByBullet(HitByBulletEvent event) {
        RobotInfo surfer = new RobotInfo(this.getRobot());
        Bullet bullet = event.getBullet();
        this.logHit(surfer, bullet);
    }

    @Override
    public void onBulletHitBullet(BulletHitBulletEvent event) {
        RobotInfo surfer = new RobotInfo(this.getRobot());
        Bullet bullet = event.getHitBullet();
        this.logHit(surfer, bullet);
    }

    @Override
    public void onStatus(StatusEvent event) {
        RobotInfo myInfo = new RobotInfo(this.getRobot());
        this.processWaves(myInfo);
        DataSegmentWave wave = this.getBestSurfebleEnemyWave(myInfo);
        if (wave != null) {
            Point2D moveTo = this.chooseSafestPosition(myInfo, wave);
            this.getRobot().setDestination(moveTo);
        }
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent event) {
        this.fireEnemyWave();
    }

    protected void logHit(RobotInfo surfer, Bullet bullet) {
        RobotInfo target = new RobotInfo(new Point2D.Double(bullet.getX(), bullet.getY()), surfer.getHeadingRadians(), surfer.getVelocity(), surfer.getEnergy(), surfer.getTime(), surfer.getBattleFieldWidth(), surfer.getBattleFieldHeight());
        DataSegmentWave wave = this.getBestSurfebleEnemyWave(target);
        if (wave == null) {
            return;
        }
        wave.logTargetHit(target, 1.0);
        wave.setValid(false);
    }

    protected void processWaves(RobotInfo surfer) {
        ListIterator<DataSegmentWave> waveIt = this.waves.listIterator();
        while (waveIt.hasNext()) {
            Wave bullet = waveIt.next();
            if (!bullet.isValid()) {
                waveIt.remove();
                continue;
            }
            if (!bullet.isTargetHit(surfer)) continue;
            bullet.logTargetHit(surfer, 0.33);
            bullet.setValid(false);
        }
    }

    protected void fireEnemyWave() {
        if (this.getHistoryModule().getEntries() < 3) {
            return;
        }
        RobotInfo targetBefore = this.getHistoryModule().getTargetInfo(1);
        RobotInfo targetNow = this.getHistoryModule().getTargetInfo(0);
        RobotInfo surferBeforeBefore = this.getHistoryModule().getMyInfo(2);
        if (this.isShotFireDetected(targetNow, targetBefore)) {
            DataSegmentWave wave = new DataSegmentWave(new RobotInfo(targetBefore.getPosition(), targetBefore.getHeadingRadians(), targetBefore.getVelocity(), targetBefore.getEnergy(), targetNow.getTime(), targetNow.getBattleFieldWidth(), targetNow.getBattleFieldHeight()), surferBeforeBefore, targetBefore.getEnergy() - (targetNow.getEnergy() + Rules.getBulletDamage((double)this.lastTargetHitPower)), this.getDataModule().getDataSegment(), this.getDataModule().getExtrapolator());
            this.waves.add(wave);
        }
        if (this.lastTargetHitPower != 0.0) {
            this.lastTargetHitPower = 0.0;
        }
    }

    protected Point2D chooseSafestPosition(RobotInfo surfer, DataSegmentWave wave) {
        int middleIndex;
        Wave.ClockDirection targetDirection = wave.getDirection();
        RobotInfo forwardInfo = targetDirection == Wave.ClockDirection.Clockwise ? wave.getInterceptionInfo(surfer, Wave.ClockDirection.Clockwise) : wave.getInterceptionInfo(surfer, Wave.ClockDirection.Counterclockwise);
        RobotInfo backwardInfo = targetDirection == Wave.ClockDirection.Clockwise ? wave.getInterceptionInfo(surfer, Wave.ClockDirection.Counterclockwise) : wave.getInterceptionInfo(surfer, Wave.ClockDirection.Clockwise);
        double forwardAngle = targetDirection.getFactor() * Utils.normalRelativeAngle((double)(wave.absoluteShooterAngle(forwardInfo) - wave.getAbsoluteFireAngle()));
        double backwardAngle = targetDirection.getFactor() * Utils.normalRelativeAngle((double)(wave.absoluteShooterAngle(backwardInfo) - wave.getAbsoluteFireAngle()));
        double myAngle = targetDirection.getFactor() * Utils.normalRelativeAngle((double)(wave.absoluteShooterAngle(surfer) - wave.getAbsoluteFireAngle()));
        double maxEscapeAngle = wave.getMaxEscapeAngle();
        forwardAngle = RoboUtils.limit(-maxEscapeAngle, forwardAngle, maxEscapeAngle);
        backwardAngle = RoboUtils.limit(-maxEscapeAngle, backwardAngle, maxEscapeAngle);
        myAngle = RoboUtils.limit(-maxEscapeAngle, myAngle, maxEscapeAngle);
        int minIndex = wave.getDataSegment().getIndexFor(backwardAngle, -maxEscapeAngle, maxEscapeAngle);
        int maxIndex = wave.getDataSegment().getIndexFor(forwardAngle, -maxEscapeAngle, maxEscapeAngle);
        int myIndex = wave.getDataSegment().getIndexFor(myAngle, -maxEscapeAngle, maxEscapeAngle);
        DataSegmentation.DataQueryResult dataSegment = wave.getDataSegment();
        int bestIndex = this.findSafeIndex(dataSegment, minIndex = (int)RoboUtils.limit(0.0, minIndex - 1, dataSegment.getSegments() - 1), maxIndex = (int)RoboUtils.limit(0.0, maxIndex + 1, dataSegment.getSegments() - 1), myIndex = (int)RoboUtils.limit(0.0, myIndex, dataSegment.getSegments() - 1));
        if (bestIndex == (middleIndex = (dataSegment.getSegments() - 1) / 2)) {
            return wave.getTarget().getPosition();
        }
        if (bestIndex < middleIndex) {
            double guessFactor = Wave.calculateGuessFactor(wave.getDataSegment().getSegments(), bestIndex);
            double absAngle = wave.getTarget().absoluteAngle(backwardInfo);
            double surfRelativeAngle = Math.abs(Wave.calculateFireAngleOffset(wave.getDirection(), guessFactor, wave.getFirePower()));
            return RoboUtils.projectPoint(wave.getTarget().getPosition(), absAngle, Math.tan(surfRelativeAngle) * wave.getShooter().distance(wave.getTarget()));
        }
        double guessFactor = Wave.calculateGuessFactor(wave.getDataSegment().getSegments(), bestIndex);
        double absAngle = wave.getTarget().absoluteAngle(forwardInfo);
        double surfRelativeAngle = Math.abs(Wave.calculateFireAngleOffset(wave.getDirection(), guessFactor, wave.getFirePower()));
        return RoboUtils.projectPoint(wave.getTarget().getPosition(), absAngle, Math.tan(surfRelativeAngle) * wave.getShooter().distance(wave.getTarget()));
    }

    protected int findSafeIndex(DataSegmentation.DataQueryResult dataSegment, int minIndex, int maxIndex, int myIndex) {
        int leftMax = minIndex;
        int rightMax = maxIndex;
        double minValue = Double.MAX_VALUE;
        double maxValue = Double.MIN_VALUE;
        int i = leftMax;
        while (i <= rightMax) {
            minValue = Math.min(minValue, dataSegment.getValueAt(i));
            maxValue = Math.max(maxValue, dataSegment.getValueAt(i));
            ++i;
        }
        int leftSafeIndex = myIndex;
        int i2 = myIndex;
        while (i2 >= leftMax) {
            double safeValue = (dataSegment.getValueAt(leftSafeIndex) - minValue) / (maxValue - minValue);
            if (i2 >= leftMax) {
                double value = (dataSegment.getValueAt(i2) - minValue) / (maxValue - minValue);
                if (value > 0.9 && safeValue < 0.3) {
                    i2 = leftMax;
                } else if (value < safeValue) {
                    leftSafeIndex = i2;
                }
            }
            --i2;
        }
        int rightSafeIndex = myIndex;
        int i3 = myIndex;
        while (i3 <= rightMax) {
            double safeValue = (dataSegment.getValueAt(rightSafeIndex) - minValue) / (maxValue - minValue);
            if (i3 <= rightMax) {
                double value = (dataSegment.getValueAt(i3) - minValue) / (maxValue - minValue);
                if (value > 0.9 && safeValue < 0.3) {
                    i3 = rightMax;
                } else if (value < safeValue) {
                    rightSafeIndex = i3;
                }
            }
            ++i3;
        }
        return dataSegment.getValueAt(leftSafeIndex) < dataSegment.getValueAt(rightSafeIndex) ? leftSafeIndex : rightSafeIndex;
    }

    protected DataSegmentWave getBestSurfebleEnemyWave(RobotInfo surfer) {
        double distance = Double.MAX_VALUE;
        DataSegmentWave enemyWave = null;
        for (DataSegmentWave wave : this.waves) {
            double waveDistance = Math.abs(surfer.distance(wave.getShooter()) - wave.getDistanceTraveled(surfer.getTime()));
            if (!(waveDistance < distance)) continue;
            enemyWave = wave;
            distance = waveDistance;
        }
        return enemyWave;
    }

    protected boolean isShotFireDetected(RobotInfo now, RobotInfo before) {
        double bulletPower = before.getEnergy() - (now.getEnergy() + Rules.getBulletDamage((double)this.lastTargetHitPower));
        return bulletPower > 0.0;
    }
}

