/*
 * Decompiled with CFR 0.152.
 */
package drm.common3;

import drm.common3.BulletStore;
import drm.common3.CircularIntercept;
import drm.common3.Coordinate;
import drm.common3.Enemy;
import drm.common3.EnemyStore;
import drm.common3.ExpectEnemyLocation;
import drm.common3.Intercept;
import drm.common3.Utils;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.Event;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.Robot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Brain {
    public static Hashtable enemyListBak = null;
    public static Vector myStoreListBak = null;
    AdvancedRobot robot;
    Hashtable enemyList;
    public Vector myStoreList;
    Hashtable bulletHitEventList;
    Hashtable bulletHitBulletEventList;
    Hashtable bulletMissedEventList;
    Hashtable hitByBulletEventList;
    Hashtable hitRobotEventList;
    Hashtable robotDeathEventList;
    Hashtable scannedRobotEventList;
    Event deathEvent;
    Event hitWallEvent;
    Event winEvent;
    Enemy target;
    BulletStore nearestBullet;
    double teritoryX;
    double teritoryY;
    double beforeRobotX;
    double beforeRobotY;
    double beforeRobotHeading;
    double bbeforeRobotHeading;
    double beforeRobotVelocity;
    double deltaHeading;
    boolean shooted;
    Bullet lastBullet;
    int enemyID;
    Intercept intercept;
    Intercept eintercept;
    Coordinate coordinate;
    double width;
    double height;
    double taikaku;
    Vector dist100Vector;
    Vector dist200Vector;
    Vector dist400Vector;
    Vector distFarVector;
    Vector shootedVector;
    Random random;

    public void setAdvancedRobot(AdvancedRobot r) {
        this.robot = r;
    }

    public AdvancedRobot getAdvancedRobot() {
        return this.robot;
    }

    public void initialize() {
        this.width = this.robot.getBattleFieldWidth();
        this.height = this.robot.getBattleFieldHeight();
        this.taikaku = Math.sqrt(this.width * this.width + this.height * this.height);
    }

    public EnemyStore getNewMyInfo() {
        return (EnemyStore)this.myStoreList.lastElement();
    }

    public void think() {
        Enemy enemy;
        EnemyStore es;
        if (this.target != null && (es = this.target.getNewEnemyInfo()) != null) {
            es.heWasShooted = this.shooted;
        }
        this.target = null;
        this.nearestBullet = null;
        EnemyStore ms = new EnemyStore(this.robot.getX(), this.robot.getY(), this.robot.getHeading(), this.robot.getVelocity(), 0.0, this.robot.getEnergy(), this.robot.getTime());
        ms.deltaHeading = this.myStoreList.size() > 0 ? Utils.normalRelativeAngle(ms.heading - this.getNewMyInfo().heading) : 0.0;
        this.myStoreList.addElement(ms);
        Enumeration en = this.enemyList.elements();
        while (en.hasMoreElements()) {
            BulletHitBulletEvent bhbe;
            HitByBulletEvent hbbe;
            RobotDeathEvent rde;
            HitRobotEvent hre;
            BulletHitEvent bhe;
            enemy = (Enemy)en.nextElement();
            enemy.nearestEnemy = null;
            EnemyStore prevEnemyStore = enemy.getNewEnemyInfo();
            double expectEnergy = prevEnemyStore.energy;
            double nowEnergy = prevEnemyStore.energy;
            ScannedRobotEvent sre = (ScannedRobotEvent)this.scannedRobotEventList.get(enemy.name);
            if (sre != null) {
                if (enemy.getNewEnemyInfo().time != sre.getTime()) {
                    EnemyStore es2 = new EnemyStore(this.robot.getX() + sre.getDistance() * Math.sin(Math.toRadians(Utils.normalAbsoluteAngle(this.robot.getHeading() + sre.getBearing()))), this.robot.getY() + sre.getDistance() * Math.cos(Math.toRadians(Utils.normalAbsoluteAngle(this.robot.getHeading() + sre.getBearing()))), sre.getHeading(), sre.getVelocity(), sre.getDistance(), sre.getEnergy(), sre.getTime());
                    es2.deltaHeading = Utils.normalRelativeAngle(es2.heading - enemy.getNewEnemyInfo().heading);
                    enemy.enemyStoreList.addElement(es2);
                    nowEnergy = sre.getEnergy();
                }
                this.scannedRobotEventList.remove(enemy.name);
                if (enemy.expectWallHitDamage > 0.0) {
                    expectEnergy -= expectEnergy - nowEnergy;
                }
                enemy.expectWallHitDamage = Utils.chkOutOfBattleField(enemy.getNewEnemyInfo().x, enemy.getNewEnemyInfo().y, sre.getHeading(), sre.getVelocity(), (Robot)this.robot) ? Utils.getWallHitDamage(sre.getVelocity()) : 0.0;
            }
            if ((bhe = (BulletHitEvent)this.bulletHitEventList.get(enemy.name)) != null) {
                if (enemy.getNewEnemyInfo().time != bhe.getTime()) {
                    EnemyStore es3 = new EnemyStore(bhe.getBullet().getX(), bhe.getBullet().getY(), -99999.0, -99999.0, Utils.calcDistance(this.robot.getX(), this.robot.getY(), bhe.getBullet().getX(), bhe.getBullet().getY()), bhe.getEnergy(), bhe.getTime());
                    es3.deltaHeading = Utils.normalRelativeAngle(es3.heading - enemy.getNewEnemyInfo().heading);
                    enemy.enemyStoreList.addElement(es3);
                    nowEnergy = bhe.getEnergy();
                }
                this.bulletHitEventList.remove(enemy.name);
                expectEnergy -= Utils.getBulletDamage(bhe.getBullet().getPower());
            }
            if ((hre = (HitRobotEvent)this.hitRobotEventList.get(enemy.name)) != null) {
                if (enemy.getNewEnemyInfo().time != hre.getTime()) {
                    double deg = this.robot.getHeading() + hre.getBearing();
                    double robotR = Utils.getRobotR();
                    EnemyStore es4 = new EnemyStore(this.robot.getX() + robotR * Math.sin(Math.toRadians(deg)), this.robot.getY() + robotR * Math.cos(Math.toRadians(deg)), -99999.0, -99999.0, 0.1, hre.getEnergy(), hre.getTime());
                    es4.deltaHeading = Utils.normalRelativeAngle(es4.heading - enemy.getNewEnemyInfo().heading);
                    enemy.enemyStoreList.addElement(es4);
                    nowEnergy = hre.getEnergy();
                    ++enemy.hitCount;
                }
                this.hitRobotEventList.remove(enemy.name);
                expectEnergy -= Utils.getRobotHitDamage();
            }
            if ((rde = (RobotDeathEvent)this.robotDeathEventList.get(enemy.name)) != null) {
                if (enemy.getNewEnemyInfo().time != rde.getTime()) {
                    EnemyStore es5 = new EnemyStore(-99999.0, -99999.0, -99999.0, -99999.0, -99999.0, -99999.0, rde.getTime());
                    es5.deltaHeading = Utils.normalRelativeAngle(es5.heading - enemy.getNewEnemyInfo().heading);
                    enemy.enemyStoreList.addElement(es5);
                    nowEnergy = 0.0;
                }
                this.robotDeathEventList.remove(enemy.name);
                enemy.isAlive = false;
            }
            if ((hbbe = (HitByBulletEvent)this.hitByBulletEventList.get(enemy.name)) != null) {
                if (enemy.getNewEnemyInfo().time != hbbe.getTime()) {
                    EnemyStore es6 = new EnemyStore(-99999.0, -99999.0, -99999.0, -99999.0, -99999.0, -99999.0, hbbe.getTime());
                    es6.deltaHeading = Utils.normalRelativeAngle(es6.heading - enemy.getNewEnemyInfo().heading);
                    enemy.enemyStoreList.addElement(es6);
                    ++enemy.hitCount;
                }
                this.hitByBulletEventList.remove(enemy.name);
                expectEnergy += Utils.getBulletGain(hbbe.getBullet().getPower());
                this.eraseBullet(hbbe.getName(), hbbe.getBullet());
            }
            if ((bhbe = (BulletHitBulletEvent)this.bulletHitBulletEventList.get(enemy.name)) != null) {
                if (enemy.getNewEnemyInfo().time != bhbe.getTime()) {
                    EnemyStore es7 = new EnemyStore(prevEnemyStore.x, prevEnemyStore.y, -99999.0, -99999.0, Utils.calcDistance(this.robot.getX(), this.robot.getY(), prevEnemyStore.x, prevEnemyStore.y), -99999.0, hbbe.getTime());
                    es7.deltaHeading = Utils.normalRelativeAngle(es7.heading - enemy.getNewEnemyInfo().heading);
                    enemy.enemyStoreList.addElement(es7);
                }
                this.bulletHitBulletEventList.remove(enemy.name);
                this.eraseBullet(bhbe.getHitBullet().getName(), bhbe.getHitBullet());
            }
            this.setNearestEnemy(enemy);
            if (expectEnergy > nowEnergy) {
                enemy.isFired = true;
                enemy.latestBulletPower = expectEnergy - nowEnergy;
            } else {
                enemy.isFired = false;
            }
            enemy.dengerousRate = this.calcEnemyDengerousRate(enemy);
            if (this.target == null) {
                if (!enemy.isAlive) continue;
                this.target = enemy;
                continue;
            }
            if (!enemy.isAlive || !(this.target.dengerousRate < enemy.dengerousRate)) continue;
            this.target = enemy;
        }
        en = this.enemyList.elements();
        while (en.hasMoreElements()) {
            enemy = (Enemy)en.nextElement();
            if (enemy.isFired) {
                this.createBullet(enemy, enemy.latestBulletPower);
            }
            this.moveBullets(enemy);
        }
        this.deltaHeading = Utils.normalRelativeAngle(this.robot.getHeading() - this.beforeRobotHeading);
        this.beforeRobotX = this.robot.getX();
        this.beforeRobotY = this.robot.getY();
        this.bbeforeRobotHeading = this.beforeRobotHeading;
        this.beforeRobotHeading = this.robot.getHeading();
        this.beforeRobotVelocity = this.robot.getVelocity();
        if (this.target != null) {
            this.doVirtualBullet(this.target);
        }
    }

    public void setTeritory(double x, double y) {
        this.teritoryX = x;
        this.teritoryY = y;
    }

    void setNearestEnemy(Enemy enemy) {
        Enumeration en = this.enemyList.elements();
        double tmpDistance = this.taikaku;
        EnemyStore es = enemy.getNewEnemyInfo();
        if (es != null) {
            while (en.hasMoreElements()) {
                double tmpDistance2;
                EnemyStore tes;
                Enemy targetEnemy = (Enemy)en.nextElement();
                if (targetEnemy == enemy || (tes = targetEnemy.getNewEnemyInfo()) == null || !(es.distance > (tmpDistance2 = Utils.calcDistance(es.x, es.y, tes.x, tes.y))) || !(tmpDistance > tmpDistance2)) continue;
                enemy.nearestEnemy = targetEnemy;
                tmpDistance = tmpDistance2;
            }
        }
    }

    public double getDeltaHeading() {
        return this.deltaHeading;
    }

    public Enemy getTarget() {
        return this.target;
    }

    public BulletStore getNearestBullet() {
        return this.nearestBullet;
    }

    public Enemy getEnemy(String name) {
        return (Enemy)this.enemyList.get(name);
    }

    public Hashtable getEnemyList() {
        return this.enemyList;
    }

    void createEnemy(String name) {
        if (this.enemyList.get(name) == null) {
            this.enemyList.put(name, new Enemy(this.enemyID++, name));
        }
    }

    void createBullet(Enemy enemy, double power) {
        double targetX = this.beforeRobotX;
        double targetY = this.beforeRobotY;
        double targetHeading = this.beforeRobotHeading;
        double targetVelocity = this.beforeRobotVelocity;
        double targetBeforeHeading = this.bbeforeRobotHeading;
        if (enemy.nearestEnemy != null) {
            Enemy nEnemy = enemy.nearestEnemy;
            EnemyStore tes = nEnemy.getNewEnemyInfo();
            EnemyStore btes = (EnemyStore)nEnemy.enemyStoreList.elementAt(nEnemy.enemyStoreList.size() - 2);
            targetX = tes.x;
            targetY = tes.y;
            targetHeading = tes.heading;
            targetVelocity = tes.velocity;
            targetBeforeHeading = btes.heading;
            if (targetHeading == -99999.0 || targetHeading == -99999.0) {
                targetVelocity = 0.0;
            }
            if (targetBeforeHeading == -99999.0) {
                targetBeforeHeading = targetHeading;
            }
        }
        EnemyStore es = (EnemyStore)enemy.enemyStoreList.elementAt(enemy.enemyStoreList.size() - 2);
        power = Math.min(power, (double)3);
        double angularVelocity = Utils.normalRelativeAngle(targetHeading - targetBeforeHeading);
        this.eintercept.calculate(es.x, es.y, targetX, targetY, targetHeading, targetVelocity, power, angularVelocity, 1L);
        BulletStore bs = new BulletStore(es.x, es.y, Utils.calcAbsoluteBearing(es.x, es.y, this.eintercept.impactPoint.x, this.eintercept.impactPoint.y), Utils.getBulletVelocity(power), Utils.calcDistance(this.eintercept.impactPoint.x, this.eintercept.impactPoint.y, es.x, es.y), power);
        bs.inittime = this.robot.getTime() - 1L;
        bs.expectImpactPoint.x = this.eintercept.impactPoint.x;
        bs.expectImpactPoint.y = this.eintercept.impactPoint.y;
        bs.expectImpactTime = this.robot.getTime() + (long)(bs.distance / bs.velocity);
        enemy.bulletStoreList.addElement(bs);
    }

    void moveBullets(Enemy enemy) {
        Enumeration en = enemy.bulletStoreList.elements();
        while (en.hasMoreElements()) {
            BulletStore bs = (BulletStore)en.nextElement();
            double vel = bs.velocity * (double)(this.robot.getTime() - bs.inittime);
            bs.x = bs.initx + vel * Math.sin(Math.toRadians(bs.heading));
            bs.y = bs.inity + vel * Math.cos(Math.toRadians(bs.heading));
            bs.distance = Utils.calcDistance(this.robot.getX(), this.robot.getY(), bs.x, bs.y);
            if (Utils.chkOutOfBattleFieldXY(bs.x, bs.y, (Robot)this.robot)) {
                enemy.bulletStoreList.remove(bs);
                continue;
            }
            if (this.nearestBullet == null) {
                this.nearestBullet = bs;
                continue;
            }
            if (!(bs.distance < this.nearestBullet.distance)) continue;
            this.nearestBullet = bs;
        }
    }

    void eraseBullet(String name, Bullet bullet) {
        Enemy enemy = this.getEnemy(name);
        if (enemy == null) {
            return;
        }
        BulletStore ebs = null;
        Enumeration en = enemy.bulletStoreList.elements();
        while (en.hasMoreElements()) {
            BulletStore bs = (BulletStore)en.nextElement();
            if (bs.power != bullet.getPower()) continue;
            if (ebs == null) {
                ebs = bs;
                continue;
            }
            if (!(ebs.distance > bs.distance)) continue;
            ebs = bs;
        }
        if (ebs != null) {
            enemy.bulletStoreList.remove(ebs);
        }
    }

    void doVirtualBullet(Enemy target) {
        if (target.virtualBulletStore != null && target.virtualBulletStore.expectImpactTime + 10L < this.robot.getTime()) {
            target.virtualBulletStore = null;
        }
        if (target.virtualBulletStore != null) {
            this.moveVirtualBullet(target);
        } else {
            EnemyStore es = (EnemyStore)target.enemyStoreList.elementAt(target.enemyStoreList.size() - 2);
            if (es != null && es.heWasShooted && this.lastBullet != null) {
                this.createVirtualBullet(target, this.lastBullet.getPower());
            }
        }
    }

    void createVirtualBullet(Enemy enemy, double power) {
        power = Math.min(power, (double)3);
        Coordinate impactPoint = this.getCircuitEnemyImpactPoint(enemy, power);
        double x = this.robot.getX();
        double y = this.robot.getY();
        BulletStore bs = new BulletStore(x, y, Utils.calcAbsoluteBearing(x, y, impactPoint.x, impactPoint.y), Utils.getBulletVelocity(power), Utils.calcDistance(impactPoint.x, impactPoint.y, x, y), power);
        bs.inittime = this.robot.getTime();
        bs.expectImpactPoint.x = impactPoint.x;
        bs.expectImpactPoint.y = impactPoint.y;
        bs.expectImpactTime = this.robot.getTime() + (long)(bs.distance / bs.velocity);
        EnemyStore es = enemy.getNewEnemyInfo();
        enemy.deltaRevFlg = Utils.normalRelativeAngle(Utils.calcAbsoluteBearing(x, y, es.x, es.y) - bs.heading) < 0.0;
        enemy.virtualBulletStore = bs;
        enemy.deltaDistance = Utils.calcDistance(es.x, es.y, x, y);
    }

    void moveVirtualBullet(Enemy enemy) {
        BulletStore bs = enemy.virtualBulletStore;
        double vel = bs.velocity * (double)(this.robot.getTime() - bs.inittime);
        bs.x = bs.initx + vel * Math.sin(Math.toRadians(bs.heading));
        bs.y = bs.inity + vel * Math.cos(Math.toRadians(bs.heading));
        bs.distance = Utils.calcDistance(this.robot.getX(), this.robot.getY(), bs.x, bs.y);
        if (Utils.chkOutOfBattleFieldXY(bs.x, bs.y, (Robot)this.robot)) {
            enemy.virtualBulletStore = null;
        } else {
            EnemyStore es = enemy.getNewEnemyInfo();
            double distance = Utils.calcDistance(es.x, es.y, this.robot.getX(), this.robot.getY());
            if (distance < bs.distance) {
                double delta = Utils.normalRelativeAngle(bs.heading - Utils.calcAbsoluteBearing(this.robot.getX(), this.robot.getY(), es.x, es.y)) / enemy.deltaDistance * bs.velocity;
                if (enemy.deltaRevFlg) {
                    delta = -delta;
                }
                enemy.deltaShootSum += delta;
                ++enemy.deltaShootNum;
                enemy.deltaShoot = enemy.deltaShootSum / (double)enemy.deltaShootNum;
                enemy.virtualBulletStore = null;
            }
        }
    }

    double calcEnemyDengerousRate(Enemy enemy) {
        double ret = 0.0;
        if (enemy.isAlive) {
            EnemyStore es = null;
            int i = enemy.enemyStoreList.size();
            while (i > 0) {
                es = (EnemyStore)enemy.enemyStoreList.elementAt(i - 1);
                if (es.distance != -99999.0) break;
                --i;
            }
            if (es != null) {
                if (this.teritoryX == 0.0 && this.teritoryY == 0.0) {
                    if (es.distance != -99999.0 && es.distance != 0.0) {
                        ret = 1.0 / es.distance;
                    }
                } else {
                    double distance = Utils.calcDistance(this.teritoryX, this.teritoryY, es.x, es.y);
                    if (distance != 0.0) {
                        ret = 1.0 / distance;
                    }
                }
                if (es.energy != -99999.0 && es.energy <= 0.4) {
                    ret /= es.energy + 0.1;
                }
                ret *= (double)(enemy.hitCount + 1);
            }
        }
        return ret;
    }

    public double getDengerousRate(double x, double y) {
        double ret = 0.0;
        if (Utils.chkOutOfBattleFieldXY(x, y, (Robot)this.robot)) {
            ret = 1.0;
        }
        return ret;
    }

    public void setLastBullet(Bullet bullet) {
        this.lastBullet = bullet;
    }

    public void setShooted(boolean s) {
        this.shooted = s;
    }

    public Coordinate getEnemyImpactPoint(Enemy enemy, double bulletPower) {
        return this.getLogTraceEnemyImpactPoint(enemy, bulletPower, false, false);
    }

    public Coordinate getLogTraceEnemyImpactPoint(Enemy enemy, Enemy nowEnemy, Vector myStoreList, double bulletPower) {
        int chkLogLength = 5;
        int chkAncientLength = 1000;
        int chkFutureLength = 100;
        double th = 5;
        double thv = 1.0;
        boolean velRevFlg = false;
        boolean turnRevFlg = false;
        boolean wasShooted = false;
        int count = 0;
        this.dist100Vector.removeAllElements();
        this.dist200Vector.removeAllElements();
        this.dist400Vector.removeAllElements();
        this.distFarVector.removeAllElements();
        this.shootedVector.removeAllElements();
        double x = this.getAdvancedRobot().getX();
        double y = this.getAdvancedRobot().getY();
        boolean isFindImpactPoint = false;
        if (enemy == null || nowEnemy == null) {
            return null;
        }
        if (enemy.enemyStoreList == null || nowEnemy.enemyStoreList == null) {
            return null;
        }
        if (enemy.enemyStoreList.size() == 0 || nowEnemy.enemyStoreList.size() == 0) {
            return null;
        }
        int enemyStoreListSize = enemy.enemyStoreList.size();
        int nowEnemyStoreListSize = nowEnemy.enemyStoreList.size();
        EnemyStore nowEs = nowEnemy.getNewEnemyInfo();
        double nowDistance = Utils.calcDistance(x, y, nowEs.x, nowEs.y);
        int distSwitch = 0;
        distSwitch = nowDistance < 100.0 ? 0 : (nowDistance < 200.0 ? 1 : (nowDistance < 400.0 ? 2 : 3));
        if (enemyStoreListSize > chkLogLength) {
            int ancientLength = enemyStoreListSize - chkAncientLength + chkLogLength;
            if (ancientLength < chkLogLength) {
                ancientLength = chkLogLength;
            }
            int loop1 = 0;
            while (2 > loop1) {
                if (loop1 == 1) {
                    turnRevFlg = true;
                }
                int loop2 = 0;
                while (2 > loop2) {
                    if (loop2 == 1) {
                        velRevFlg = true;
                    }
                    wasShooted = false;
                    count = 0;
                    int i = enemyStoreListSize - 1;
                    while (ancientLength <= i) {
                        double vel;
                        if (count > 50) break;
                        int j = 0;
                        while (chkLogLength > j) {
                            if (i - j - 1 < 0) break;
                            EnemyStore nes = (EnemyStore)nowEnemy.enemyStoreList.elementAt(nowEnemyStoreListSize - j - 1);
                            EnemyStore pes = (EnemyStore)enemy.enemyStoreList.elementAt(i - j - 1);
                            vel = velRevFlg ? Math.abs(nes.velocity + pes.velocity) : Math.abs(nes.velocity - pes.velocity);
                            double turn = turnRevFlg ? Math.abs(nes.deltaHeading + pes.deltaHeading) : Math.abs(nes.deltaHeading - pes.deltaHeading);
                            if (turn > th || vel > thv) break;
                            ++j;
                        }
                        if (j == chkLogLength) {
                            double ex = nowEs.x;
                            double ey = nowEs.y;
                            double eHeading = nowEs.heading;
                            int futureLength = chkFutureLength;
                            if (futureLength > nowEnemyStoreListSize - i) {
                                futureLength = nowEnemyStoreListSize - i;
                            }
                            if (futureLength > enemyStoreListSize - i) {
                                futureLength = enemyStoreListSize - i;
                            }
                            boolean heWasShooted = false;
                            double bulletDist = 0.0;
                            j = 1;
                            while (futureLength > j) {
                                EnemyStore pes = (EnemyStore)enemy.enemyStoreList.elementAt(i + j - 1);
                                if (j <= 3) {
                                    heWasShooted |= pes.heWasShooted;
                                }
                                if ((ex += (vel = velRevFlg ? -pes.velocity : pes.velocity) * Math.sin(Math.toRadians(eHeading = turnRevFlg ? Utils.normalAbsoluteAngle(eHeading - pes.deltaHeading) : Utils.normalAbsoluteAngle(eHeading + pes.deltaHeading)))) < 0.0 || ex > this.width || (ey += vel * Math.cos(Math.toRadians(eHeading))) < 0.0 || ey > this.height || (bulletDist += Utils.getBulletVelocity(bulletPower)) > this.taikaku) break;
                                double dist = Utils.calcDistance(ex, ey, x, y);
                                if (Math.abs(dist - (double)j * Utils.getBulletVelocity(bulletPower)) <= Utils.getRobotR()) {
                                    ExpectEnemyLocation tmpeel;
                                    int k;
                                    EnemyStore myLoggedEs;
                                    EnemyStore loggedEs = (EnemyStore)enemy.enemyStoreList.elementAt(i - 1);
                                    if (myStoreList.size() > (int)loggedEs.time) {
                                        myLoggedEs = (EnemyStore)myStoreList.elementAt((int)loggedEs.time);
                                    } else {
                                        myLoggedEs = new EnemyStore();
                                        myLoggedEs.x = this.getAdvancedRobot().getX();
                                        myLoggedEs.y = this.getAdvancedRobot().getY();
                                    }
                                    ExpectEnemyLocation eel = new ExpectEnemyLocation();
                                    eel.x = ex;
                                    eel.y = ey;
                                    eel.heWasShooted = heWasShooted;
                                    eel.turnRev = turnRevFlg;
                                    eel.velRev = velRevFlg;
                                    eel.logDistance = Utils.calcDistance(myLoggedEs.x, myLoggedEs.y, loggedEs.x, loggedEs.y);
                                    eel.logBearingMe = Utils.calcRelativeBearing(loggedEs.heading, loggedEs.x, loggedEs.y, myLoggedEs.x, myLoggedEs.y);
                                    if (turnRevFlg) {
                                        eel.logBearingMe = -eel.logBearingMe;
                                    }
                                    if (velRevFlg) {
                                        eel.logBearingMe = -eel.logBearingMe;
                                    }
                                    eel.timePoint = i;
                                    if (eel.logDistance < 100.0) {
                                        k = 0;
                                        while (this.dist100Vector.size() > k) {
                                            tmpeel = (ExpectEnemyLocation)this.dist100Vector.elementAt(k);
                                            if (eel.timePoint > tmpeel.timePoint) break;
                                            ++k;
                                        }
                                        this.dist100Vector.insertElementAt(eel, k);
                                    } else if (eel.logDistance < 200.0) {
                                        k = 0;
                                        while (this.dist200Vector.size() > k) {
                                            tmpeel = (ExpectEnemyLocation)this.dist200Vector.elementAt(k);
                                            if (eel.timePoint > tmpeel.timePoint) break;
                                            ++k;
                                        }
                                        this.dist200Vector.insertElementAt(eel, k);
                                    } else if (eel.logDistance < 400.0) {
                                        k = 0;
                                        while (this.dist400Vector.size() > k) {
                                            tmpeel = (ExpectEnemyLocation)this.dist400Vector.elementAt(k);
                                            if (eel.timePoint > tmpeel.timePoint) break;
                                            ++k;
                                        }
                                        this.dist400Vector.insertElementAt(eel, k);
                                    } else {
                                        k = 0;
                                        while (this.distFarVector.size() > k) {
                                            tmpeel = (ExpectEnemyLocation)this.distFarVector.elementAt(k);
                                            if (eel.timePoint > tmpeel.timePoint) break;
                                            ++k;
                                        }
                                        this.distFarVector.insertElementAt(eel, k);
                                    }
                                    isFindImpactPoint = true;
                                    wasShooted = heWasShooted;
                                    ++count;
                                    break;
                                }
                                ++j;
                            }
                        }
                        --i;
                    }
                    ++loop2;
                }
                ++loop1;
            }
        }
        if (isFindImpactPoint) {
            switch (distSwitch) {
                case 0: {
                    if (this.chkExpectEnemyLocationList(nowEnemy, this.dist100Vector, this.coordinate) || this.chkExpectEnemyLocationList(nowEnemy, this.dist200Vector, this.coordinate) || this.chkExpectEnemyLocationList(nowEnemy, this.dist400Vector, this.coordinate)) break;
                    this.chkExpectEnemyLocationList(nowEnemy, this.distFarVector, this.coordinate);
                    break;
                }
                case 1: {
                    if (this.chkExpectEnemyLocationList(nowEnemy, this.dist200Vector, this.coordinate) || this.chkExpectEnemyLocationList(nowEnemy, this.dist100Vector, this.coordinate) || this.chkExpectEnemyLocationList(nowEnemy, this.dist400Vector, this.coordinate)) break;
                    this.chkExpectEnemyLocationList(nowEnemy, this.distFarVector, this.coordinate);
                    break;
                }
                case 2: {
                    if (this.chkExpectEnemyLocationList(nowEnemy, this.dist400Vector, this.coordinate) || this.chkExpectEnemyLocationList(nowEnemy, this.dist200Vector, this.coordinate) || this.chkExpectEnemyLocationList(nowEnemy, this.dist100Vector, this.coordinate)) break;
                    this.chkExpectEnemyLocationList(nowEnemy, this.distFarVector, this.coordinate);
                    break;
                }
                case 3: {
                    if (this.chkExpectEnemyLocationList(nowEnemy, this.distFarVector, this.coordinate) || this.chkExpectEnemyLocationList(nowEnemy, this.dist400Vector, this.coordinate) || this.chkExpectEnemyLocationList(nowEnemy, this.dist200Vector, this.coordinate)) break;
                    this.chkExpectEnemyLocationList(nowEnemy, this.dist100Vector, this.coordinate);
                }
            }
            return this.coordinate;
        }
        return null;
    }

    boolean chkExpectEnemyLocationList(Enemy enemy, Vector vect, Coordinate cd) {
        double d;
        boolean ret = false;
        double x = 0.0;
        double y = 0.0;
        EnemyStore es = enemy.getNewEnemyInfo();
        ExpectEnemyLocation eelTmp = null;
        Enumeration en = vect.elements();
        while (en.hasMoreElements()) {
            ExpectEnemyLocation eel = (ExpectEnemyLocation)en.nextElement();
            if (!eel.heWasShooted) continue;
            this.shootedVector.addElement(eel);
        }
        if (this.shootedVector.size() > 0) {
            int index = 0;
            d = this.random.nextDouble();
            while (!ret && index < this.shootedVector.size()) {
                if (d > 0.5) {
                    eelTmp = (ExpectEnemyLocation)this.shootedVector.get(index);
                    ret = true;
                }
                d *= (double)2;
                ++index;
            }
        }
        if (!ret && vect.size() > 0) {
            int index = 0;
            d = this.random.nextDouble();
            while (!ret && index < vect.size()) {
                if (d > 0.5) {
                    eelTmp = (ExpectEnemyLocation)vect.get(index);
                    ret = true;
                }
                d *= (double)2;
                ++index;
            }
        }
        if (ret) {
            cd.x = eelTmp.x;
            cd.y = eelTmp.y;
            return ret;
        }
        return ret;
    }

    public Coordinate getLogTraceEnemyImpactPoint(Enemy enemy, double bulletPower, boolean velRevFlg, boolean turnRevFlg) {
        int chkLogLength = 5;
        int chkAncientLength = 1000;
        int chkFutureLength = 100;
        double th = 5;
        double thv = 1.0;
        double x = this.getAdvancedRobot().getX();
        double y = this.getAdvancedRobot().getY();
        boolean isFindImpactPoint = false;
        int enemyStoreListSize = enemy.enemyStoreList.size();
        EnemyStore es = enemy.getNewEnemyInfo();
        if (enemyStoreListSize > chkLogLength) {
            int ancientLength = enemyStoreListSize - chkAncientLength + chkLogLength;
            if (ancientLength < chkLogLength) {
                ancientLength = chkLogLength;
            }
            int loop = 0;
            while (2 > loop) {
                int i = enemyStoreListSize - 1;
                while (ancientLength <= i) {
                    double vel;
                    int j = 0;
                    while (chkLogLength > j) {
                        EnemyStore nes = (EnemyStore)enemy.enemyStoreList.elementAt(enemyStoreListSize - j - 1);
                        EnemyStore pes = (EnemyStore)enemy.enemyStoreList.elementAt(i - j - 1);
                        vel = velRevFlg ? Math.abs(nes.velocity + pes.velocity) : Math.abs(nes.velocity - pes.velocity);
                        double turn = turnRevFlg ? Math.abs(nes.deltaHeading + pes.deltaHeading) : Math.abs(nes.deltaHeading - pes.deltaHeading);
                        if (turn > th || vel > thv) break;
                        ++j;
                    }
                    if (j == chkLogLength) {
                        double ex = es.x;
                        double ey = es.y;
                        double eHeading = es.heading;
                        int futureLength = chkFutureLength;
                        if (futureLength > enemyStoreListSize - i) {
                            futureLength = enemyStoreListSize - i;
                        }
                        boolean heWasShooted = false;
                        j = 1;
                        while (futureLength > j) {
                            EnemyStore pes = (EnemyStore)enemy.enemyStoreList.elementAt(i + j - 1);
                            if (loop == 0 && j > 3 && !(heWasShooted |= pes.heWasShooted)) break;
                            vel = velRevFlg ? -pes.velocity : pes.velocity;
                            double dist = Utils.calcDistance(ex += vel * Math.sin(Math.toRadians(eHeading = turnRevFlg ? Utils.normalAbsoluteAngle(eHeading - pes.deltaHeading) : Utils.normalAbsoluteAngle(eHeading + pes.deltaHeading))), ey += vel * Math.cos(Math.toRadians(eHeading)), x, y);
                            if (Math.abs(dist - (double)j * Utils.getBulletVelocity(bulletPower)) <= Utils.getRobotR()) {
                                this.coordinate.x = ex;
                                this.coordinate.y = ey;
                                isFindImpactPoint = true;
                                break;
                            }
                            ++j;
                        }
                        if (isFindImpactPoint) break;
                    }
                    --i;
                }
                if (isFindImpactPoint) break;
                ++loop;
            }
        }
        if (isFindImpactPoint) {
            return this.coordinate;
        }
        return null;
    }

    public Coordinate getCircuitEnemyImpactPoint(Enemy enemy, double bulletPower) {
        int chkPrevMargin = 1;
        double angularVelocity = 0.0;
        int enemyStoreListSize = enemy.enemyStoreList.size();
        EnemyStore es = enemy.getNewEnemyInfo();
        double velocity = es.velocity;
        if (enemyStoreListSize > chkPrevMargin * 2) {
            EnemyStore pes = (EnemyStore)enemy.enemyStoreList.elementAt(enemyStoreListSize - chkPrevMargin - 1);
            EnemyStore ppes = (EnemyStore)enemy.enemyStoreList.elementAt(enemyStoreListSize - chkPrevMargin * 2 - 1);
            velocity = (es.velocity + pes.velocity + ppes.velocity) / (double)3;
            double esHeading = Utils.calcAbsoluteBearing(es.x, es.y, pes.x, pes.y);
            if (es.velocity < 0.0) {
                esHeading += 180.0;
            }
            double pesHeading = Utils.calcAbsoluteBearing(pes.x, pes.y, ppes.x, ppes.y);
            if (pes.velocity < 0.0) {
                pesHeading += 180.0;
            }
            angularVelocity = Utils.normalRelativeAngle(es.heading - pes.heading) / (double)(es.time - pes.time);
        }
        this.intercept.calculate(this.robot.getX(), this.robot.getY(), es.x, es.y, es.heading, velocity, bulletPower, angularVelocity, this.robot.getTime() - es.time);
        return this.intercept.impactPoint;
    }

    public void onBulletHit(BulletHitEvent e) {
        this.createEnemy(e.getName());
        this.bulletHitEventList.put(e.getName(), e);
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        this.bulletHitBulletEventList.put(e.getBullet(), e);
    }

    public void onBulletMissed(BulletMissedEvent e) {
        this.bulletMissedEventList.put(e.getBullet(), e);
    }

    public void onDeath(DeathEvent e) {
        this.deathEvent = e;
        enemyListBak = this.enemyList;
        myStoreListBak = this.myStoreList;
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.createEnemy(e.getName());
        this.hitByBulletEventList.put(e.getName(), e);
    }

    public void onHitRobot(HitRobotEvent e) {
        this.createEnemy(e.getName());
        this.hitRobotEventList.put(e.getName(), e);
    }

    public void onHitWall(HitWallEvent e) {
        this.hitWallEvent = e;
    }

    public void onRobotDeath(RobotDeathEvent e) {
        this.createEnemy(e.getName());
        this.robotDeathEventList.put(e.getName(), e);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.createEnemy(e.getName());
        this.scannedRobotEventList.put(e.getName(), e);
    }

    public void onWin(WinEvent e) {
        this.winEvent = e;
        enemyListBak = this.enemyList;
        myStoreListBak = this.myStoreList;
    }

    private final /* synthetic */ void this() {
        this.robot = null;
        this.enemyList = new Hashtable();
        this.myStoreList = new Vector();
        this.bulletHitEventList = new Hashtable();
        this.bulletHitBulletEventList = new Hashtable();
        this.bulletMissedEventList = new Hashtable();
        this.hitByBulletEventList = new Hashtable();
        this.hitRobotEventList = new Hashtable();
        this.robotDeathEventList = new Hashtable();
        this.scannedRobotEventList = new Hashtable();
        this.deathEvent = null;
        this.hitWallEvent = null;
        this.winEvent = null;
        this.target = null;
        this.nearestBullet = null;
        this.teritoryX = 0.0;
        this.teritoryY = 0.0;
        this.beforeRobotX = 0.0;
        this.beforeRobotY = 0.0;
        this.beforeRobotHeading = 0.0;
        this.bbeforeRobotHeading = 0.0;
        this.beforeRobotVelocity = 0.0;
        this.deltaHeading = 0.0;
        this.shooted = false;
        this.lastBullet = null;
        this.enemyID = 0;
        this.intercept = new CircularIntercept();
        this.eintercept = new CircularIntercept();
        this.coordinate = new Coordinate();
        this.width = 0.0;
        this.height = 0.0;
        this.taikaku = 0.0;
        this.dist100Vector = new Vector();
        this.dist200Vector = new Vector();
        this.dist400Vector = new Vector();
        this.distFarVector = new Vector();
        this.shootedVector = new Vector();
        this.random = new Random();
    }

    public Brain() {
        this.this();
    }

    public Brain(AdvancedRobot r) {
        this();
        this.setAdvancedRobot(r);
    }
}

