/*
 * Decompiled with CFR 0.152.
 */
package drm.parts;

import drm.common3.Brain;
import drm.common3.BulletStore;
import drm.common3.Coordinate;
import drm.common3.DamageRateBox;
import drm.common3.Driver;
import drm.common3.Enemy;
import drm.common3.EnemyStore;
import drm.common3.GravVector;
import drm.common3.Gun;
import drm.common3.Mech;
import drm.common3.Motor;
import drm.common3.Radar;
import drm.common3.Utils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobocodeFileOutputStream;
import robocode.RobotDeathEvent;
import robocode.WinEvent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TricoloreDriver
extends Driver {
    public static final int MODE_TRICOLORE = 0;
    public static final int MODE_MAGAZINE = 1;
    public static int mode = 0;
    static final double ANTI_GRAVITY_WALL_POWER = 200.0;
    static final double ANTI_GRAVITY_WALLCORNER_POWER = 300.0;
    static final double ANTI_GRAVITY_RANDOMIZE_POWER = 100.0;
    static final double GRAVITY_OBJECTIVE_POINT_POWER = -50.0;
    static final double ANTI_GRAVITY_ENEMY_POWER_BASE = 100.0;
    static final double ANTI_GRAVITY_ENEMY_POWER_RATIO = 1.0;
    static final double ANTI_GRAVITY_BULLET_POWER_RATIO = 40.0;
    static final double GRAVITY_WINNING_POWER = -50.0;
    static final double ANTI_GRAVITY_POWER_RATIO = 1000.0;
    static final double ANTI_GRAVITY_SPEED_RATIO = 2.0;
    static final double ANTI_GRAVITY_TURN_RATIO = 1.0;
    static final int RATEID_ONOFFRATE_ANTIGRAVITYTRIM = 0;
    static final int RATEID_ONOFFRATE_RANDOMANTIGRAVITY = 1;
    static final int RATEID_ONOFFRATE_ESCAPECANTGUESSBULLET = 2;
    static final int RATEID_ONOFFRATE_CORNERANTIGRAVITY = 3;
    static final int RATEID_CHANGERATE_ANTIGRAVITYTRIM = 4;
    static final int RATEID_CHANGERATE_RANDOMANTIGRAVITY = 5;
    static final int RATEID_CHANGERATE_RANDOMANTIGRAVITYMOVE = 6;
    static final int RATEID_CHANGERATE_OBJECTIVEPOINTMOVE = 7;
    static final int RATEID_CHANGERATE_FEINTOBJECTIVEPOINTMOVE = 8;
    public static final int DAMAGERATEBOX_PARAMMAX = 9;
    public static final int DAMAGERATEBOX_RATEMAX = 11;
    static final int AIMCOUNT_MAX = 30;
    static final long NTICKS = 100L;
    static final double POWERRATE_BASE_DAMAGE = 10.0;
    double maxOwnArea;
    Radar radar;
    Motor motor;
    Gun gun;
    boolean survivalMode;
    int onoffRate_AntiGravityTrim_IndexStore;
    int onoffRate_RandomAntiGravity_IndexStore;
    int onoffRate_EscapeCantGuessBullet_IndexStore;
    int onoffRate_CornerAntiGravity_IndexStore;
    int changeRate_AntiGravityTrim_IndexStore;
    int changeRate_RandomAntiGravity_IndexStore;
    int changeRate_RandomAntiGravityMove_IndexStore;
    int changeRate_ObjectivePointMove_IndexStore;
    int changeRate_FeintObjectivePointMove_IndexStore;
    double onoffRate_AntiGravityTrim;
    double onoffRate_RandomAntiGravity;
    double onoffRate_EscapeCantGuessBullet;
    double onoffRate_CornerAntiGravity;
    double changeRate_AntiGravityTrim;
    double changeRate_RandomAntiGravity;
    double changeRate_RandomAntiGravityMove;
    double changeRate_ObjectivePointMove;
    double changeRate_FeintObjectivePointMove;
    double powerDiff_Randomize;
    double powerDiff_ObjectivePoint;
    double powerDiff_Wall;
    double powerDiff_WallCorner;
    double powerDiff_Enemy;
    double powerRatioDiff_Enemy;
    double powerRatioDiff_EnemyBullet;
    DamageRateBox[][] damageRateBox;
    boolean meleeFileReaded;
    boolean damageRateBoxReaded;
    Random random;
    Vector gravVectorVector;
    int gravVectorVectorIndex;
    GravVector antiGravitiyForce;
    boolean oneonone;
    int aimCount;
    boolean randomizeFlg;
    boolean isWin;
    boolean isNeedRam;
    GravVector[] objectivePoints;
    int selectedObjectPoints;
    int defaultObjectPoint;
    int objectPointState;
    double randomizeX;
    double randomizeY;
    double randomizePower;
    double winX;
    double winY;
    double winHeading;
    double dangerX;
    double dangerY;
    double width;
    double height;
    double taikaku;
    GravVector cantGuessBullet;
    GravVector feintObjectivePoint;
    boolean movementTrimFlg;
    boolean antiGravityCancel;
    String[] debugAreaMsg;
    double totalDamage;
    long damageChkCount;
    double powerRate;
    Enemy prevEnemy;
    int iFired;
    int myFireHitted;
    double myBulletPowerAVL;
    int youFired;
    int yourFireHitted;
    double yourBulletPowerAVL;
    double myBulletPower;

    double calcBulletPower(double myEnergy, double yourEnergy) {
        double c = 1.0;
        boolean check = false;
        System.out.println("yourEnergy           = " + yourEnergy);
        System.out.println("iFired               = " + this.iFired);
        System.out.println("myFireHitted         = " + this.myFireHitted);
        System.out.println("myBulletPowerAVL     = " + this.myBulletPowerAVL);
        System.out.println("youFired             = " + this.youFired);
        System.out.println("yourFireHitted       = " + this.yourFireHitted);
        System.out.println("yourBulletPowerAVL   = " + this.yourBulletPowerAVL);
        double myHitRate = (double)this.myFireHitted / (double)this.iFired / Math.pow(Utils.getBulletVelocity(this.myBulletPowerAVL), c);
        double yourHitRate = (double)this.yourFireHitted / (double)this.youFired;
        double myFightTime = 0.0;
        double yourFightTime = 100000.0;
        double myFightGain = 0.0;
        double yourFightGain = 100000.0;
        double coolingRate = this.getAdvancedRobot().getGunCoolingRate();
        double myDamagePT = yourHitRate * Utils.getBulletDamage(this.yourBulletPowerAVL) / (Utils.calcGunHeat(this.yourBulletPowerAVL) / coolingRate);
        this.myBulletPower = 2;
        int i = 1;
        while (i <= 30) {
            double d = (double)i / 10.0;
            double mft = 0.0;
            double yft = 0.0;
            double mfg = 0.0;
            double yfg = 0.0;
            double mhr = myHitRate * Math.pow(Utils.getBulletVelocity(d), c);
            double yourDmgPTUnit = (this.yourBulletPowerAVL - Utils.getBulletGain(this.yourBulletPowerAVL) * yourHitRate) / (Utils.calcGunHeat(this.yourBulletPowerAVL) / coolingRate);
            double yourDamagePT = mhr * Utils.getBulletDamage(d) / (Utils.calcGunHeat(d) / coolingRate);
            double myDmgPT = myDamagePT + (d - Utils.getBulletGain(d) * mhr) / (Utils.calcGunHeat(d) / coolingRate);
            double yourDmgPT = yourDamagePT + yourDmgPTUnit;
            mft = myDmgPT != 0.0 ? myEnergy / myDmgPT : 100000.0;
            yft = yourDmgPT != 0.0 ? yourEnergy / yourDmgPT : 100000.0;
            mfg = Utils.getBulletGain(d) * mhr / (Utils.calcGunHeat(d) / coolingRate) * mft;
            yfg = Utils.getBulletGain(this.yourBulletPowerAVL) * yourHitRate / (Utils.calcGunHeat(this.yourBulletPowerAVL) / coolingRate) * yft;
            if (this.oneonone) {
                double myWinRate = mft / (mft + yft);
                mfg += 60.0 * myWinRate;
                yfg += 60.0 * (1.0 - myWinRate);
            }
            if (this.survivalMode) {
                boolean bl = false;
                if (mft - yft > myFightTime - yourFightTime) {
                    bl = true;
                }
                check = bl;
            } else {
                boolean bl = false;
                if (mfg - yfg > myFightGain - yourFightGain) {
                    bl = check = true;
                }
            }
            if (mft >= 0.0 && yft >= 0.0 && mfg >= 0.0 && yfg >= 0.0 && check) {
                myFightTime = mft;
                yourFightTime = yft;
                myFightGain = mfg;
                yourFightGain = yfg;
                this.myBulletPower = d;
            }
            ++i;
        }
        System.out.println("expect my fight time      = " + myFightTime);
        System.out.println("expect enemy's fight time = " + yourFightTime);
        System.out.println("expect my fight gain      = " + myFightGain);
        System.out.println("expect enemy's fight gain = " + yourFightGain);
        System.out.println("selected my bullet power  = " + this.myBulletPower);
        double myWinRate = myFightTime / (myFightTime + yourFightTime);
        System.out.println("my winning rate  = " + myWinRate);
        if (myWinRate < 0.5) {
            System.out.println("CAUTION : enemy is strong!!");
        }
        return this.myBulletPower;
    }

    int selectDamageRateIndex(DamageRateBox[] dRB) {
        int ret = 0;
        double maxDamage = 0.0;
        int i = 0;
        while (11 > i) {
            maxDamage += Math.pow((double)dRB[i].num * dRB[i].damageRate, 2);
            ++i;
        }
        double[] selectRate = new double[11];
        double dmgRate = 0.0;
        double sumSelectRate = 0.0;
        int i2 = 0;
        while (11 > i2) {
            if (maxDamage > 0.0) {
                dmgRate = Math.pow((double)dRB[i2].num * dRB[i2].damageRate, 2) / maxDamage;
            }
            selectRate[i2] = 1.0 - dmgRate;
            sumSelectRate += selectRate[i2];
            ++i2;
        }
        double tmp = 0.0;
        int i3 = 0;
        while (11 > i3) {
            selectRate[i3] = selectRate[i3] / sumSelectRate + tmp;
            tmp = selectRate[i3];
            ++i3;
        }
        double rnd = this.random.nextDouble();
        int i4 = 0;
        while (11 > i4) {
            if (rnd < selectRate[i4]) {
                ret = i4;
                break;
            }
            ++i4;
        }
        return ret;
    }

    double selectDamageRate(int index) {
        double ret = 0.09090909090909091 * (double)index;
        return ret;
    }

    void storeDamageRate(DamageRateBox[] dRB, int index, double damage) {
        double oldDamageRate = dRB[index].damageRate;
        ++dRB[index].num;
        dRB[index].damageRate = oldDamageRate - oldDamageRate / (double)dRB[index].num + damage / (double)dRB[index].num;
    }

    void selectDamageRates() {
        this.onoffRate_AntiGravityTrim_IndexStore = this.selectDamageRateIndex(this.damageRateBox[0]);
        this.onoffRate_AntiGravityTrim = this.selectDamageRate(this.onoffRate_AntiGravityTrim_IndexStore);
        this.onoffRate_RandomAntiGravity_IndexStore = this.selectDamageRateIndex(this.damageRateBox[1]);
        this.onoffRate_RandomAntiGravity = this.selectDamageRate(this.onoffRate_RandomAntiGravity_IndexStore);
        this.onoffRate_EscapeCantGuessBullet_IndexStore = this.selectDamageRateIndex(this.damageRateBox[2]);
        this.onoffRate_EscapeCantGuessBullet = this.selectDamageRate(this.onoffRate_EscapeCantGuessBullet_IndexStore);
        this.onoffRate_CornerAntiGravity_IndexStore = this.selectDamageRateIndex(this.damageRateBox[3]);
        this.onoffRate_CornerAntiGravity = this.selectDamageRate(this.onoffRate_CornerAntiGravity_IndexStore);
        this.changeRate_AntiGravityTrim_IndexStore = this.selectDamageRateIndex(this.damageRateBox[4]);
        this.changeRate_AntiGravityTrim = this.selectDamageRate(this.changeRate_AntiGravityTrim_IndexStore);
        this.changeRate_RandomAntiGravity_IndexStore = this.selectDamageRateIndex(this.damageRateBox[5]);
        this.changeRate_RandomAntiGravity = this.selectDamageRate(this.changeRate_RandomAntiGravity_IndexStore);
        this.changeRate_RandomAntiGravityMove_IndexStore = this.selectDamageRateIndex(this.damageRateBox[6]);
        this.changeRate_RandomAntiGravityMove = this.selectDamageRate(this.changeRate_RandomAntiGravityMove_IndexStore);
        this.changeRate_ObjectivePointMove_IndexStore = this.selectDamageRateIndex(this.damageRateBox[7]);
        this.changeRate_ObjectivePointMove = this.selectDamageRate(this.changeRate_ObjectivePointMove_IndexStore);
        this.changeRate_FeintObjectivePointMove_IndexStore = this.selectDamageRateIndex(this.damageRateBox[8]);
        this.changeRate_FeintObjectivePointMove = this.selectDamageRate(this.changeRate_FeintObjectivePointMove_IndexStore);
        this.damageChkCount = this.getAdvancedRobot().getTime() + 100L;
    }

    void storeDamageRates() {
        this.storeDamageRate(this.damageRateBox[0], this.onoffRate_AntiGravityTrim_IndexStore, this.totalDamage);
        this.storeDamageRate(this.damageRateBox[1], this.onoffRate_RandomAntiGravity_IndexStore, this.totalDamage);
        this.storeDamageRate(this.damageRateBox[2], this.onoffRate_EscapeCantGuessBullet_IndexStore, this.totalDamage);
        this.storeDamageRate(this.damageRateBox[3], this.onoffRate_CornerAntiGravity_IndexStore, this.totalDamage);
        this.storeDamageRate(this.damageRateBox[4], this.changeRate_AntiGravityTrim_IndexStore, this.totalDamage);
        this.storeDamageRate(this.damageRateBox[5], this.changeRate_RandomAntiGravity_IndexStore, this.totalDamage);
        this.storeDamageRate(this.damageRateBox[6], this.changeRate_RandomAntiGravityMove_IndexStore, this.totalDamage);
        this.storeDamageRate(this.damageRateBox[7], this.changeRate_ObjectivePointMove_IndexStore, this.totalDamage);
        this.storeDamageRate(this.damageRateBox[8], this.changeRate_FeintObjectivePointMove_IndexStore, this.totalDamage);
        this.damageChkCount = -1;
        this.totalDamage = 0.0;
    }

    void changeGravity() {
        double diff = -0.005 + 0.01 * this.random.nextDouble();
        this.powerDiff_Randomize += diff;
        this.powerDiff_ObjectivePoint += diff;
        this.powerDiff_Wall += diff;
        this.powerDiff_WallCorner += diff;
        this.powerDiff_Enemy += diff;
        this.powerRatioDiff_Enemy += diff;
        this.powerRatioDiff_EnemyBullet += diff;
    }

    public void init() {
        if (this.getMechas() != null) {
            this.radar = (Radar)this.getMech(0);
            this.motor = (Motor)this.getMech(1);
            this.gun = (Gun)this.getMech(2);
        }
    }

    void calcPowerRate() {
        double damageRate = 0.0;
        int i = 0;
        while (9 > i) {
            int j = 0;
            while (11 > j) {
                damageRate += this.damageRateBox[i][j].damageRate;
                ++j;
            }
            ++i;
        }
        damageRate = damageRate / 9.0 / 11.0;
        this.powerRate = damageRate / 10.0;
    }

    void dispose() {
        System.out.println("Gravity rate = " + this.powerDiff_Randomize);
        double damageRate = 0.0;
        int i = 0;
        while (9 > i) {
            int j = 0;
            while (11 > j) {
                damageRate += this.damageRateBox[i][j].damageRate;
                ++j;
            }
            ++i;
        }
        damageRate = damageRate / 9.0 / 11.0;
        System.out.println("Damage rate = " + damageRate + "pts. per 100Ticks.");
    }

    public void initialize() {
        super.initialize();
        this.motor.setSpeed(0.0);
        this.gun.setBulletPower(1.0);
        int i = 0;
        while (this.objectivePoints.length > i) {
            this.objectivePoints[i] = new GravVector();
            this.objectivePoints[i].power = -50.0 * this.powerDiff_ObjectivePoint;
            this.objectivePoints[i].using = false;
            ++i;
        }
        this.width = this.getAdvancedRobot().getBattleFieldWidth();
        this.height = this.getAdvancedRobot().getBattleFieldHeight();
        this.taikaku = Math.sqrt(this.width * this.width + this.height * this.height);
        double delta = 50.0;
        double mDelta = 150.0;
        this.objectivePoints[0].x = delta;
        this.objectivePoints[0].y = delta;
        this.debugAreaMsg[0] = "Left under coner.";
        this.objectivePoints[1].x = this.width - delta;
        this.objectivePoints[1].y = delta;
        this.debugAreaMsg[1] = "Right under coner.";
        this.objectivePoints[2].x = this.width - delta;
        this.objectivePoints[2].y = this.height - delta;
        this.debugAreaMsg[2] = "Right upper coner.";
        this.objectivePoints[3].x = delta;
        this.objectivePoints[3].y = this.height - delta;
        this.debugAreaMsg[3] = "Left upper coner.";
        this.objectivePoints[4].x = this.width / (double)4;
        this.objectivePoints[4].y = this.height / (double)4;
        this.debugAreaMsg[4] = "Left under.";
        this.objectivePoints[5].x = this.width * (double)3 / (double)4;
        this.objectivePoints[5].y = this.height / (double)4;
        this.debugAreaMsg[5] = "Right under.";
        this.objectivePoints[6].x = this.width * (double)3 / (double)4;
        this.objectivePoints[6].y = this.height * (double)3 / (double)4;
        this.debugAreaMsg[6] = "Right upper.";
        this.objectivePoints[7].x = this.width / (double)4;
        this.objectivePoints[7].y = this.height * (double)3 / (double)4;
        this.debugAreaMsg[7] = "Left upper.";
        this.objectivePoints[8].x = this.width / (double)2;
        this.objectivePoints[8].y = this.height / (double)2;
        this.debugAreaMsg[8] = "Center.";
        this.objectivePoints[10].x = this.objectivePoints[0].x + mDelta;
        this.objectivePoints[10].y = this.objectivePoints[0].y;
        this.objectivePoints[11].x = this.objectivePoints[0].x;
        this.objectivePoints[11].y = this.objectivePoints[0].y + mDelta;
        this.objectivePoints[12].x = this.objectivePoints[1].x - mDelta;
        this.objectivePoints[12].y = this.objectivePoints[1].y;
        this.objectivePoints[13].x = this.objectivePoints[1].x;
        this.objectivePoints[13].y = this.objectivePoints[1].y + mDelta;
        this.objectivePoints[14].x = this.objectivePoints[2].x - mDelta;
        this.objectivePoints[14].y = this.objectivePoints[2].y;
        this.objectivePoints[15].x = this.objectivePoints[2].x;
        this.objectivePoints[15].y = this.objectivePoints[2].y - mDelta;
        this.objectivePoints[16].x = this.objectivePoints[3].x + mDelta;
        this.objectivePoints[16].y = this.objectivePoints[3].y;
        this.objectivePoints[17].x = this.objectivePoints[3].x;
        this.objectivePoints[17].y = this.objectivePoints[3].y - mDelta;
        this.movementTrimFlg = this.random.nextBoolean();
        double robotX = this.getAdvancedRobot().getX();
        double robotY = this.getAdvancedRobot().getY();
        this.selectedObjectPoints = robotX < this.width / (double)2 && robotY < this.height / (double)2 ? (!this.chkOneOnOne() ? 0 : 4) : (robotX >= this.width / (double)2 && robotY < this.height / (double)2 ? (!this.chkOneOnOne() ? 1 : 5) : (robotX >= this.width / (double)2 && robotY >= this.height / (double)2 ? (!this.chkOneOnOne() ? 2 : 6) : (!this.chkOneOnOne() ? 3 : 7)));
        this.defaultObjectPoint = this.selectedObjectPoints;
        System.out.println("Selected area:  " + this.debugAreaMsg[this.selectedObjectPoints]);
        this.setObjectPoint(this.objectivePoints[this.selectedObjectPoints], 100.0);
        int i2 = 0;
        while (9 > i2) {
            int j = 0;
            while (11 > j) {
                this.damageRateBox[i2][j] = new DamageRateBox();
                ++j;
            }
            ++i2;
        }
        this.initBackupData();
        if (!this.oneonone) {
            if (this.getAdvancedRobot().getRoundNum() > 1) {
                this.restoreDamageRateBox("melee");
            }
            this.selectDamageRates();
            this.calcPowerRate();
            int num = this.getAdvancedRobot().getOthers() + 1;
            double ene = 100.0;
            while (num > 1) {
                num /= 2;
                ene += 100.0;
            }
            this.myBulletPower = this.calcBulletPower(this.getAdvancedRobot().getEnergy(), ene);
            this.meleeFileReaded = true;
        }
    }

    void initBackupData() {
        int i = 0;
        while (9 > i) {
            int j = 0;
            while (11 > j) {
                this.damageRateBox[i][j].num = 10;
                this.damageRateBox[i][j].damageRate = 10.0;
                ++j;
            }
            ++i;
        }
        this.damageRateBox[0][5].damageRate = 0.0;
        this.damageRateBox[1][5].damageRate = 0.0;
        this.damageRateBox[2][5].damageRate = 0.0;
        this.damageRateBox[3][5].damageRate = 0.0;
        this.damageRateBox[4][1].damageRate = 0.0;
        this.damageRateBox[5][5].damageRate = 0.0;
        this.damageRateBox[6][2].damageRate = 0.0;
        this.damageRateBox[7][1].damageRate = 0.0;
        this.damageRateBox[8][5].damageRate = 0.0;
        this.iFired = 10;
        this.myFireHitted = 1;
        this.myBulletPowerAVL = 2;
        this.youFired = 10;
        this.yourFireHitted = 5;
        this.yourBulletPowerAVL = 2;
    }

    boolean chkOneOnOne() {
        if (this.getAdvancedRobot().getOthers() == 1) {
            this.oneonone = true;
        }
        return this.oneonone;
    }

    public void move() {
        super.move();
        this.chkOneOnOne();
        Enemy enemy = this.getBrain().getTarget();
        if (enemy != null) {
            if (this.oneonone && !this.damageRateBoxReaded) {
                if (this.meleeFileReaded) {
                    this.storeDamageRates();
                    this.backupDamageRateBox("melee");
                }
                this.initBackupData();
                this.restoreDamageRateBox(enemy.name);
                this.selectDamageRates();
                this.calcPowerRate();
                double energy = enemy.getNewEnemyInfo().energy;
                if (energy == -99999.0) {
                    energy = 100.0;
                }
                this.myBulletPower = this.calcBulletPower(this.getAdvancedRobot().getEnergy(), energy);
                this.damageRateBoxReaded = true;
            }
            EnemyStore es = enemy.getNewEnemyInfo();
            if (es.x != -99999.0 && es.y != -99999.0 && es.heading != -99999.0 && es.velocity != -99999.0 && es.distance != -99999.0 && es.time == this.getAdvancedRobot().getTime()) {
                Bullet b;
                if (es.energy != -99999.0) {
                    if (es.energy < 0.1 && this.getAdvancedRobot().getEnergy() > Utils.getRobotHitDamage() && this.oneonone) {
                        this.winX = es.x;
                        this.winY = es.y;
                        this.isNeedRam = true;
                    } else {
                        this.isNeedRam = false;
                    }
                }
                this.aim(enemy);
                if (this.getAdvancedRobot().getOthers() <= 2 && enemy.isFired && !this.feintObjectivePoint.using && this.random.nextDouble() < this.changeRate_FeintObjectivePointMove) {
                    this.feintObjectivePoint = this.selectFeintObjectivePoint(this.feintObjectivePoint, enemy);
                }
                if (enemy.isFired && enemy.bulletStoreList.size() > 0) {
                    BulletStore bs = (BulletStore)enemy.bulletStoreList.lastElement();
                    ++this.youFired;
                    this.yourBulletPowerAVL = (this.yourBulletPowerAVL * (double)(this.youFired - 1) + bs.power) / (double)this.youFired;
                }
                if (this.gun.isShooted() && (b = this.gun.getLastBullet()) != null) {
                    double power = b.getPower();
                    ++this.iFired;
                    this.myBulletPowerAVL = (this.myBulletPowerAVL * (double)(this.iFired - 1) + power) / (double)this.iFired;
                }
                this.prevEnemy = enemy;
            }
        } else {
            this.aimCancel();
        }
        if (!this.antiGravityCancel) {
            this.antiGravityMove();
        }
        this.changeDriver();
        if (!this.isWin) {
            if (this.getAdvancedRobot().getTime() > this.damageChkCount) {
                this.storeDamageRates();
                this.selectDamageRates();
                this.calcPowerRate();
            }
            this.changeGravity();
        }
    }

    void changeDriver() {
    }

    void antiGravityMove() {
        double robotX = this.getAdvancedRobot().getX();
        double robotY = this.getAdvancedRobot().getY();
        long time = this.getAdvancedRobot().getTime();
        double wallpow = 200.0 * this.powerDiff_Wall;
        this.addGravityVector(0.0, 0.0, 90.0, this.width, wallpow);
        this.addGravityVector(0.0, this.height, 90.0, this.width, wallpow);
        this.addGravityVector(0.0, 0.0, 0.0, this.height, wallpow);
        this.addGravityVector(this.width, 0.0, 0.0, this.height, wallpow);
        double wallcornerpow = 300.0 * this.powerDiff_WallCorner;
        if (this.random.nextDouble() < this.onoffRate_CornerAntiGravity) {
            this.addGravityPoint(0.0, 0.0, wallcornerpow);
            this.addGravityPoint(0.0, this.height, wallcornerpow);
            this.addGravityPoint(this.width, 0.0, wallcornerpow);
            this.addGravityPoint(this.width, this.height, wallcornerpow);
        }
        if (this.random.nextDouble() < this.changeRate_RandomAntiGravityMove) {
            this.randomizeX = 1.0;
            if (this.random.nextBoolean()) {
                this.randomizeX = -1.0;
            }
            this.randomizeX *= 10.0 + this.random.nextDouble() * 40.0;
            this.randomizeX += robotX;
            this.randomizeY = 1.0;
            if (this.random.nextBoolean()) {
                this.randomizeY = -1.0;
            }
            this.randomizeY *= 10.0 + this.random.nextDouble() * 40.0;
            this.randomizeY += robotY;
            double randpow = 100.0 * this.powerDiff_Randomize;
            this.randomizePower = randpow / (double)2 + randpow / (double)2 * this.random.nextDouble();
        }
        if (this.randomizeFlg) {
            this.addGravityPoint(this.randomizeX, this.randomizeY, this.randomizePower);
        }
        this.dangerX = 0.0;
        this.dangerY = 0.0;
        int dangerNum = 0;
        Hashtable enemyList = this.getBrain().getEnemyList();
        Enumeration en1 = enemyList.elements();
        while (en1.hasMoreElements()) {
            Enemy enemy = (Enemy)en1.nextElement();
            EnemyStore es = enemy.getNewEnemyInfo();
            if (enemy.isAlive && es.x != -99999.0 && es.y != -99999.0) {
                this.dangerX += es.x;
                this.dangerY += es.y;
                ++dangerNum;
                double energy = 50.0;
                if (es.energy != -99999.0) {
                    energy = es.energy;
                }
                this.addGravityPoint(es.x, es.y, 100.0 * this.powerDiff_Enemy + (energy - this.getAdvancedRobot().getEnergy()) * this.powerRatioDiff_Enemy);
            }
            if (this.feintObjectivePoint.using) continue;
            Enumeration en2 = enemy.bulletStoreList.elements();
            while (en2.hasMoreElements()) {
                BulletStore bs = (BulletStore)en2.nextElement();
                double bdDistance = bs.velocity * (double)(time - bs.inittime);
                double mdDistance = Utils.calcDistance(bs.initx, bs.inity, robotX, robotY);
                if (!(bdDistance < mdDistance)) continue;
                this.addGravityVector(bs.x, bs.y, bs.heading, bs.velocity * 30.0, Math.pow(bs.power, 0.5) * (40.0 * this.powerRatioDiff_EnemyBullet));
            }
        }
        this.dangerX /= (double)dangerNum;
        this.dangerY /= (double)dangerNum;
        if (!this.oneonone) {
            this.addGravityPoint(this.dangerX, this.dangerY, wallcornerpow * (double)5 * (double)(this.getAdvancedRobot().getOthers() + 1));
        }
        if (this.isWin || this.isNeedRam) {
            double x = this.winX - 10.0 * Math.sin(Math.toRadians(this.winHeading));
            double y = this.winY - 10.0 * Math.cos(Math.toRadians(this.winHeading));
            this.addGravityPoint(x, y, -50.0);
            this.winHeading = Utils.normalAbsoluteAngle(this.winHeading + (double)5);
            if (this.getAdvancedRobot().getEnergy() > 1.0 && !this.isNeedRam) {
                this.gun.setBulletPower(0.0);
                this.gun.setTargetPoint(x, y);
            }
        } else {
            int enemynum = this.getAdvancedRobot().getOthers();
            if (!this.feintObjectivePoint.using) {
                double cancelLength = 100.0;
                if (!this.oneonone) {
                    cancelLength = Math.max(50, 100 - enemynum * 5);
                }
                if (this.objectivePoints[this.selectedObjectPoints].using) {
                    this.getBrain().setTeritory(this.objectivePoints[this.defaultObjectPoint].x, this.objectivePoints[this.defaultObjectPoint].y);
                    this.setObjectPoint(this.objectivePoints[this.selectedObjectPoints], cancelLength);
                } else if (this.random.nextDouble() < this.changeRate_ObjectivePointMove) {
                    this.selectedObjectPoints = this.selectObjectPoint();
                    this.getBrain().setTeritory(this.objectivePoints[this.defaultObjectPoint].x, this.objectivePoints[this.defaultObjectPoint].y);
                    this.setObjectPoint(this.objectivePoints[this.selectedObjectPoints], cancelLength);
                }
            } else {
                double cancelLength = 20 + enemynum * 10;
                this.setObjectPoint(this.feintObjectivePoint, cancelLength);
            }
        }
        if (!this.feintObjectivePoint.using && this.cantGuessBullet.using) {
            this.addGravityVector(this.cantGuessBullet.x, this.cantGuessBullet.y, this.cantGuessBullet.heading, this.cantGuessBullet.length, this.cantGuessBullet.power);
            if (this.random.nextDouble() < 0.1) {
                this.cantGuessBullet.using = false;
            }
        }
        this.antiGravitiyForce = this.calcAntiGravityForce(robotX, robotY, this.antiGravitiyForce);
        this.doAntiGravityMovement(this.antiGravitiyForce);
        this.resetGravityPoint();
    }

    int selectObjectPoint() {
        int ret = 0;
        int min = 4;
        int max = 9;
        double minforce = 10000.0;
        if (!this.oneonone) {
            min = 0;
            max = 4;
            ret = this.objectPointState % 2 == 0 ? this.defaultObjectPoint : 10 + this.defaultObjectPoint * 2 + this.objectPointState / 2;
            this.objectPointState = (this.objectPointState + 1) % 4;
            return ret;
        }
        int i = min;
        while (max > i) {
            block7: {
                block6: {
                    if (this.oneonone) break block6;
                    int d = this.selectedObjectPoints % 2;
                    if (i != this.selectedObjectPoints && i % 2 == d) break block7;
                }
                this.antiGravitiyForce = this.calcAntiGravityForce(this.objectivePoints[i].x, this.objectivePoints[i].y, this.antiGravitiyForce);
                if (minforce > this.antiGravitiyForce.length) {
                    minforce = this.antiGravitiyForce.length;
                    ret = i;
                }
            }
            ++i;
        }
        System.out.println("Selected area:  " + this.debugAreaMsg[ret]);
        this.defaultObjectPoint = ret;
        return ret;
    }

    void setObjectPoint(GravVector vect, double cancelLength) {
        double robotY;
        double robotX = this.getAdvancedRobot().getX();
        if (Utils.calcDistance(robotX, robotY = this.getAdvancedRobot().getY(), vect.x, vect.y) < cancelLength) {
            vect.using = false;
        } else {
            double x = vect.x - 10.0 * Math.sin(Math.toRadians(this.winHeading));
            double y = vect.y - 10.0 * Math.cos(Math.toRadians(this.winHeading));
            this.winHeading = Utils.normalAbsoluteAngle(this.winHeading + (double)5);
            this.addGravityPoint(x, y, vect.power);
            vect.using = true;
        }
    }

    GravVector selectFeintObjectivePoint(GravVector vect, Enemy enemy) {
        double delta = 50.0;
        double robotX = this.getAdvancedRobot().getX();
        double robotY = this.getAdvancedRobot().getY();
        EnemyStore es = enemy.getNewEnemyInfo();
        double enemyHeading = Math.toDegrees(Math.atan2(es.x - robotX, es.y - robotY));
        double sign = 1.0;
        if (this.random.nextBoolean()) {
            sign = -1.0;
        }
        BulletStore bs = (BulletStore)enemy.bulletStoreList.lastElement();
        double len = 8.0 * bs.distance / bs.velocity;
        vect.x = robotX + len * Math.sin(Math.toRadians(enemyHeading += 90.0 * sign));
        vect.y = robotY + len * Math.cos(Math.toRadians(enemyHeading));
        vect.x = Math.max(vect.x, delta);
        vect.x = Math.min(vect.x, this.width - delta);
        vect.y = Math.max(vect.y, delta);
        vect.y = Math.min(vect.y, this.height - delta);
        vect.power = -50.0;
        vect.using = true;
        return vect;
    }

    void doAntiGravityMovement(GravVector vect) {
        double robotX = this.getAdvancedRobot().getX();
        double robotY = this.getAdvancedRobot().getY();
        double robotHeading = this.getAdvancedRobot().getHeading();
        double speed = (double)2 * vect.power * Math.cos(Math.toRadians(vect.heading - robotHeading));
        if (Math.abs(speed) < 0.5 && this.random.nextDouble() < this.changeRate_AntiGravityTrim) {
            this.movementTrimFlg = this.random.nextDouble() < this.onoffRate_AntiGravityTrim;
        }
        if (this.movementTrimFlg) {
            if (speed > 1.0) {
                speed = 8.0 - this.random.nextDouble() * (double)2;
            } else if (speed < -1.0) {
                speed = -8.0 + this.random.nextDouble() * (double)2;
            }
        }
        this.motor.setSpeed(speed);
        if (Math.abs(Utils.normalRelativeAngle(vect.heading - robotHeading)) < 90.0) {
            this.motor.setTurn(Utils.normalRelativeAngle(vect.heading - robotHeading));
        } else {
            this.motor.setTurn(Utils.normalRelativeAngle(vect.heading - robotHeading + 180.0));
        }
    }

    GravVector calcAntiGravityForce(double robotX, double robotY, GravVector vect) {
        double forceX = 0.0;
        double forceY = 0.0;
        double forceHeading = 0.0;
        double forcePower = 0.0;
        vect.length = 0.0;
        Enumeration en = this.gravVectorVector.elements();
        while (en.hasMoreElements()) {
            double gravY;
            double gravX;
            double powbase = 2.5;
            GravVector gv = (GravVector)en.nextElement();
            double distance = Utils.calcDistance(gv.x, gv.y, robotX, robotY);
            if (distance < 1.0) {
                distance = 1.0;
            }
            if (!gv.using) continue;
            if (gv.length == 0.0) {
                gravX = gv.x;
                gravY = gv.y;
            } else {
                powbase = 3;
                double deg = Utils.calcRelativeBearing(gv.heading, gv.x, gv.y, robotX, robotY);
                if (Math.abs(deg) > 90.0) {
                    gravX = gv.x;
                    gravY = gv.y;
                } else if (distance * Math.cos(Math.toRadians(deg)) > gv.length) {
                    gravX = gv.x + gv.length * Math.sin(Math.toRadians(gv.heading));
                    gravY = gv.y + gv.length * Math.cos(Math.toRadians(gv.heading));
                } else {
                    double rate = distance * Math.cos(Math.toRadians(deg)) / gv.length;
                    gravX = gv.x + rate * gv.length * Math.sin(Math.toRadians(gv.heading));
                    gravY = gv.y + rate * gv.length * Math.cos(Math.toRadians(gv.heading));
                }
            }
            distance = Utils.calcDistance(gravX, gravY, robotX, robotY);
            if (distance < 1.0) {
                distance = 1.0;
            }
            if (distance == 0.0) continue;
            if (gv.power < 0.0) {
                powbase = 1.5;
            }
            double force = 1000.0 * gv.power / Math.pow(distance, powbase);
            forceX += force * (robotX - gravX) / distance;
            forceY += force * (robotY - gravY) / distance;
            vect.length += force;
        }
        forceHeading = Math.toDegrees(Math.atan2(forceX, forceY));
        forcePower = Utils.calcDistance(0.0, 0.0, forceX, forceY);
        vect.x = forceX;
        vect.y = forceY;
        vect.heading = forceHeading;
        vect.power = forcePower;
        return vect;
    }

    void resetGravityPoint() {
        Enumeration en = this.gravVectorVector.elements();
        while (en.hasMoreElements()) {
            GravVector gv = (GravVector)en.nextElement();
            gv.using = false;
        }
        this.gravVectorVectorIndex = 0;
    }

    void addGravityPoint(double x, double y, double power) {
        GravVector gv;
        if (this.gravVectorVectorIndex < this.gravVectorVector.size()) {
            gv = (GravVector)this.gravVectorVector.elementAt(this.gravVectorVectorIndex);
        } else {
            gv = new GravVector();
            this.gravVectorVector.addElement(gv);
        }
        gv.x = x;
        gv.y = y;
        gv.heading = 0.0;
        gv.length = 0.0;
        gv.power = power;
        gv.using = true;
        ++this.gravVectorVectorIndex;
    }

    void addGravityVector(double x, double y, double heading, double length, double power) {
        GravVector gv;
        if (this.gravVectorVectorIndex < this.gravVectorVector.size()) {
            gv = (GravVector)this.gravVectorVector.elementAt(this.gravVectorVectorIndex);
        } else {
            gv = new GravVector();
            this.gravVectorVector.addElement(gv);
        }
        gv.x = x;
        gv.y = y;
        gv.heading = heading;
        gv.length = length;
        gv.power = power;
        gv.using = true;
        ++this.gravVectorVectorIndex;
    }

    void aim(Enemy enemy) {
        double x = enemy.getNewEnemyInfo().x;
        double y = enemy.getNewEnemyInfo().y;
        boolean emergency = false;
        if (this.oneonone || this.aimCount < 30) {
            this.radar.setTargetPoint(x, y);
            ++this.aimCount;
        } else if (this.aimCount++ > 31) {
            this.aimCount = 0;
        }
        if (this.isNeedRam) {
            return;
        }
        double bulletPower = this.myBulletPower;
        if (enemy.getNewEnemyInfo().distance < 100.0) {
            bulletPower = 3;
        }
        bulletPower = Math.min(bulletPower, Utils.getBulletPowerToKill(enemy.getNewEnemyInfo().energy));
        double myEnergy = this.getAdvancedRobot().getEnergy();
        if (myEnergy < bulletPower) {
            bulletPower = 0.1;
            emergency = true;
        }
        Coordinate impactPoint = null;
        impactPoint = this.getBrain().getLogTraceEnemyImpactPoint(enemy, enemy, this.getBrain().myStoreList, bulletPower);
        if (impactPoint == null && Brain.enemyListBak != null) {
            Enemy prevRoundEnemy = (Enemy)Brain.enemyListBak.get(enemy.name);
            impactPoint = this.getBrain().getLogTraceEnemyImpactPoint(prevRoundEnemy, enemy, Brain.myStoreListBak, bulletPower);
            boolean bl = false;
            if (impactPoint != null) {
                bl = true;
            }
        }
        if (impactPoint == null && !emergency) {
            impactPoint = this.getBrain().getCircuitEnemyImpactPoint(enemy, bulletPower);
            if (this.random.nextDouble() < 0.5) {
                double mx = this.getAdvancedRobot().getX();
                double my = this.getAdvancedRobot().getY();
                double delta = enemy.deltaShoot / Utils.getBulletVelocity(bulletPower) * Utils.calcDistance(mx, my, x, y);
                if (Utils.normalRelativeAngle(Utils.calcAbsoluteBearing(mx, my, x, y) - Utils.calcAbsoluteBearing(mx, my, impactPoint.x, impactPoint.y)) < 0.0) {
                    delta = -delta;
                }
                this.gun.setDelta(delta);
            } else {
                this.gun.setDelta(0.0);
            }
        } else {
            this.gun.setDelta(0.0);
        }
        if (enemy.getNewEnemyInfo().energy != 0.0 && myEnergy < 0.2) {
            impactPoint = null;
        }
        this.gun.setBulletPower(bulletPower);
        if (this.prevEnemy != enemy) {
            this.aimCount = 0;
        }
        if (impactPoint != null && impactPoint.x > 0.0 && impactPoint.x < this.getAdvancedRobot().getBattleFieldWidth() && impactPoint.y > 0.0 && impactPoint.y < this.getAdvancedRobot().getBattleFieldHeight()) {
            this.gun.setTargetPoint(impactPoint.x, impactPoint.y);
        }
    }

    void aimCancel() {
        this.radar.resetTargetPoint();
        this.motor.resetTargetPoint();
        this.gun.resetTargetPoint();
    }

    public void onBulletHit(BulletHitEvent e) {
        super.onBulletHit(e);
        ++this.myFireHitted;
    }

    public void onRobotDeath(RobotDeathEvent e) {
        super.onRobotDeath(e);
        int num = this.getAdvancedRobot().getOthers() + 1;
        if (num > 2) {
            double ene = 100.0;
            while (num > 1) {
                num /= 2;
                ene += 100.0;
            }
            this.myBulletPower = this.calcBulletPower(this.getAdvancedRobot().getEnergy(), ene);
        }
    }

    public void onDeath(DeathEvent e) {
        super.onDeath(e);
        if (!this.damageRateBoxReaded) {
            if (this.meleeFileReaded) {
                this.storeDamageRates();
                this.backupDamageRateBox("melee");
            }
        } else {
            Enemy enemy = this.getBrain().getTarget();
            if (enemy != null) {
                this.storeDamageRates();
                this.backupDamageRateBox(enemy.name);
            }
        }
        this.dispose();
    }

    public void onHitRobot(HitRobotEvent e) {
        super.onHitRobot(e);
        this.totalDamage += Utils.getRobotHitDamage();
        Enemy enemy = this.getBrain().getTarget();
        if (enemy != null && e.getName().equals(enemy.name)) {
            this.aimCount = 0;
        }
        this.isNeedRam = false;
    }

    public void onHitWall(HitWallEvent e) {
        super.onHitWall(e);
        this.totalDamage += Utils.getWallHitDamage(this.getAdvancedRobot().getVelocity());
    }

    public void onWin(WinEvent e) {
        super.onWin(e);
        this.isWin = true;
        this.winX = this.getAdvancedRobot().getBattleFieldWidth();
        this.winY = this.getAdvancedRobot().getBattleFieldHeight();
        Enemy enemy = this.getBrain().getTarget();
        if (enemy != null) {
            if (!this.damageRateBoxReaded) {
                if (this.meleeFileReaded) {
                    this.storeDamageRates();
                    this.backupDamageRateBox("melee");
                }
            } else {
                this.storeDamageRates();
                this.backupDamageRateBox(enemy.name);
            }
            if (enemy.getNewEnemyInfo().x != -99999.0 && enemy.getNewEnemyInfo().y != -99999.0) {
                this.winX = enemy.getNewEnemyInfo().x;
                this.winY = enemy.getNewEnemyInfo().y;
            }
        }
        this.randomizeFlg = false;
        this.dispose();
    }

    public void onHitByBullet(HitByBulletEvent e) {
        super.onHitByBullet(e);
        ++this.yourFireHitted;
        int count = 0;
        Enemy enemy = this.getBrain().getTarget();
        if (enemy != null) {
            Enumeration en = enemy.bulletStoreList.elements();
            while (en.hasMoreElements()) {
                BulletStore bs = (BulletStore)en.nextElement();
                if (!(Math.abs(bs.x - this.getAdvancedRobot().getX()) < Utils.getRobotR() * (double)2) || !(Math.abs(bs.y - this.getAdvancedRobot().getY()) < Utils.getRobotR() * (double)2)) continue;
                ++count;
            }
            if (count == 0) {
                if (this.random.nextDouble() < this.changeRate_RandomAntiGravity) {
                    this.randomizeFlg = this.random.nextDouble() < this.onoffRate_RandomAntiGravity;
                }
                if (this.random.nextDouble() < this.onoffRate_EscapeCantGuessBullet) {
                    Bullet b = e.getBullet();
                    double len = Math.sqrt(this.width * this.width + this.height * this.height);
                    this.cantGuessBullet.x = b.getX() - len * Math.sin(Math.toRadians(e.getHeading())) - 10.0 + this.random.nextDouble() * 20.0;
                    this.cantGuessBullet.y = b.getY() - len * Math.cos(Math.toRadians(e.getHeading())) - 10.0 + this.random.nextDouble() * 20.0;
                    this.cantGuessBullet.heading = e.getHeading();
                    this.cantGuessBullet.length = len;
                    this.cantGuessBullet.power = Math.pow(e.getPower(), 0.5) * (40.0 * this.powerRatioDiff_EnemyBullet);
                    this.cantGuessBullet.using = true;
                }
            }
        }
        this.totalDamage += Utils.getBulletDamage(e.getPower());
    }

    void restoreDamageRateBox(String name) {
        try {
            File data = this.getAdvancedRobot().getDataFile(name + ".dat");
            DataInputStream dis = new DataInputStream(new FileInputStream(data));
            int i = 0;
            while (9 > i) {
                int j = 0;
                while (11 > j) {
                    this.damageRateBox[i][j].num = dis.readInt();
                    this.damageRateBox[i][j].damageRate = dis.readDouble();
                    ++j;
                }
                ++i;
            }
            this.iFired = dis.readInt();
            this.myFireHitted = dis.readInt();
            this.myBulletPowerAVL = dis.readDouble();
            this.youFired = dis.readInt();
            this.yourFireHitted = dis.readInt();
            this.yourBulletPowerAVL = dis.readDouble();
            dis.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void backupDamageRateBox(String name) {
        try {
            File data = this.getAdvancedRobot().getDataFile(name + ".dat");
            DataOutputStream dos = new DataOutputStream((OutputStream)new RobocodeFileOutputStream(data));
            int i = 0;
            while (9 > i) {
                int j = 0;
                while (11 > j) {
                    dos.writeInt(this.damageRateBox[i][j].num);
                    dos.writeDouble(this.damageRateBox[i][j].damageRate);
                    ++j;
                }
                ++i;
            }
            dos.writeInt(this.iFired);
            dos.writeInt(this.myFireHitted);
            dos.writeDouble(this.myBulletPowerAVL);
            dos.writeInt(this.youFired);
            dos.writeInt(this.yourFireHitted);
            dos.writeDouble(this.yourBulletPowerAVL);
            dos.flush();
            dos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final /* synthetic */ void this() {
        this.maxOwnArea = 300.0;
        this.survivalMode = false;
        this.onoffRate_AntiGravityTrim_IndexStore = 0;
        this.onoffRate_RandomAntiGravity_IndexStore = 0;
        this.onoffRate_EscapeCantGuessBullet_IndexStore = 0;
        this.onoffRate_CornerAntiGravity_IndexStore = 0;
        this.changeRate_AntiGravityTrim_IndexStore = 0;
        this.changeRate_RandomAntiGravity_IndexStore = 0;
        this.changeRate_RandomAntiGravityMove_IndexStore = 0;
        this.changeRate_ObjectivePointMove_IndexStore = 0;
        this.changeRate_FeintObjectivePointMove_IndexStore = 0;
        this.onoffRate_AntiGravityTrim = 0.5;
        this.onoffRate_RandomAntiGravity = 0.5;
        this.onoffRate_EscapeCantGuessBullet = 0.5;
        this.onoffRate_CornerAntiGravity = 0.5;
        this.changeRate_AntiGravityTrim = 0.1;
        this.changeRate_RandomAntiGravity = 0.5;
        this.changeRate_RandomAntiGravityMove = 0.2;
        this.changeRate_ObjectivePointMove = 0.05;
        this.changeRate_FeintObjectivePointMove = 0.5;
        this.powerDiff_Randomize = 1.0;
        this.powerDiff_ObjectivePoint = 1.0;
        this.powerDiff_Wall = 1.0;
        this.powerDiff_WallCorner = 1.0;
        this.powerDiff_Enemy = 1.0;
        this.powerRatioDiff_Enemy = 1.0;
        this.powerRatioDiff_EnemyBullet = 1.0;
        this.damageRateBox = new DamageRateBox[9][11];
        this.meleeFileReaded = false;
        this.damageRateBoxReaded = false;
        this.random = new Random();
        this.gravVectorVector = new Vector();
        this.gravVectorVectorIndex = 0;
        this.antiGravitiyForce = new GravVector();
        this.oneonone = false;
        this.aimCount = 0;
        this.randomizeFlg = false;
        this.isWin = false;
        this.isNeedRam = false;
        this.objectivePoints = new GravVector[18];
        this.selectedObjectPoints = 0;
        this.defaultObjectPoint = 0;
        this.objectPointState = 0;
        this.randomizeX = 0.0;
        this.randomizeY = 0.0;
        this.randomizePower = 0.0;
        this.winX = 0.0;
        this.winY = 0.0;
        this.winHeading = 0.0;
        this.dangerX = 0.0;
        this.dangerY = 0.0;
        this.width = 0.0;
        this.height = 0.0;
        this.taikaku = 0.0;
        this.cantGuessBullet = new GravVector();
        this.feintObjectivePoint = new GravVector();
        this.movementTrimFlg = false;
        this.antiGravityCancel = false;
        this.debugAreaMsg = new String[9];
        this.totalDamage = 0.0;
        this.damageChkCount = 0L;
        this.powerRate = 1.0;
        this.prevEnemy = null;
        this.iFired = 10;
        this.myFireHitted = 1;
        this.myBulletPowerAVL = 2;
        this.youFired = 10;
        this.yourFireHitted = 5;
        this.yourBulletPowerAVL = 2;
        this.myBulletPower = 2;
    }

    public TricoloreDriver() {
        this.this();
        this.init();
    }

    public TricoloreDriver(AdvancedRobot r) {
        super(r);
        this.this();
        this.init();
    }

    public TricoloreDriver(AdvancedRobot r, Mech[] m) {
        super(r, m);
        this.this();
        this.init();
    }

    public TricoloreDriver(AdvancedRobot r, Mech[] m, Brain b) {
        super(r, m, b);
        this.this();
        this.init();
    }
}

