/*
 * Decompiled with CFR 0.152.
 */
package gre.svman4.moves.MeleeMove;

import gre.svman4.moves.MeleeMove.EnemyForce;
import gre.svman4.moves.MeleeMove.LastPointForce;
import gre.svman4.moves.MeleeMove.MelleeMove;
import gre.svman4.moves.MovingOrder;
import gre.svman4.moves.WallSmoothing;
import gre.svman4.useful.FieldPoint;
import gre.svman4.useful.LastPositionHolder;
import gre.svman4.useful.RobotState;
import gre.svman4.useful.WallForce;
import java.awt.Graphics2D;

public class AntigravityMovement
extends MelleeMove {
    private WallForce wallForce = new WallForce();
    private EnemyForce enemyForce = new EnemyForce();
    private LastPointForce lastPointForce = new LastPointForce();
    double[] antigravityForce = new double[]{0.0, 0.0};
    private double _movingAngle = 0.0;

    public AntigravityMovement(RobotState mineRobot) {
        super(mineRobot);
    }

    @Override
    public String getName() {
        return "AntigravityMovement";
    }

    @Override
    public MovingOrder getMovingInfo() {
        double[] wForce = this.wallForce.calculate(this._mineRobot, _movingArea, 1);
        double[] enForce = this.enemyForce.calculate(this._enemies, this._mineRobot, 1);
        double[] laForce = this.lastPointForce.calculate(this._mineRobot, LastPositionHolder.getLastPositions(), 1);
        double xForce = 0.0;
        xForce += wForce[0];
        xForce += enForce[0];
        double yForce = 0.0;
        yForce += wForce[1];
        yForce += enForce[1];
        if ((xForce += laForce[0]) == 0.0 && (yForce += laForce[1]) == 0.0) {
            return null;
        }
        if (xForce == Double.NaN || yForce == Double.NaN) {
            System.out.println("NaN value on Forces");
        }
        double angle = Math.atan2(xForce, yForce);
        this._movingAngle = WallSmoothing.run(_movingArea, WALL_MARGIN, this._mineRobot, angle, -1);
        return new MovingOrder(this._movingAngle, 8.0, 50.0);
    }

    @Override
    public void onPaint(Graphics2D paint) {
        super.onPaint(paint);
        double max = Double.MIN_VALUE;
        max = Double.max(max, this.wallForce.abs());
        max = Double.max(max, this.lastPointForce.abs());
        max = Double.max(max, this.enemyForce.abs());
        this.wallForce.onPaint(this._mineRobot, max, paint);
        this.lastPointForce.onPaint(this._mineRobot, max, paint);
        this.enemyForce.onPaint(this._mineRobot, max, paint);
        FieldPoint point = this._mineRobot.project(50.0, this._movingAngle);
        paint.drawLine((int)this._mineRobot.x, (int)this._mineRobot.y, (int)point.x, (int)point.y);
        LastPositionHolder.onPaint(paint);
    }
}

