/*
 * Decompiled with CFR 0.152.
 */
package gre.svman4.useful;

import gre.svman4.useful.FieldPoint;
import java.awt.Color;
import java.awt.Graphics2D;

public abstract class Force {
    public static final int SAVE_INFO = 1;
    public static final int _NO_SAVE = 0;
    private static final double SAMPLE_DISTANCE = 50.0;
    double[] force = new double[]{0.0, 0.0};

    public double getX() {
        return this.force[0];
    }

    public double getY() {
        return this.force[1];
    }

    public void setX(double x) {
        this.force[0] = x;
    }

    public void setY(double y) {
        this.force[1] = y;
    }

    public abstract Color getColor();

    public void onPaint(FieldPoint point, Graphics2D paint) {
        paint.setColor(this.getColor());
        double angle = Math.atan2(this.getX(), this.getY());
        FieldPoint paintPoint = point.project(50.0, angle);
        paint.drawLine((int)point.x, (int)point.y, (int)paintPoint.x, (int)paintPoint.y);
    }

    public void onPaint(FieldPoint point, double maxSize, Graphics2D paint) {
        paint.setColor(this.getColor());
        double abs = this.abs();
        double distance = 50.0 * (abs / maxSize);
        double angle = Math.atan2(this.getX(), this.getY());
        FieldPoint paintPoint = point.project(distance, angle);
        paint.drawLine((int)point.x, (int)point.y, (int)paintPoint.x, (int)paintPoint.y);
    }

    protected abstract String getName();

    public double abs() {
        double x = this.getX();
        double y = this.getY();
        double result = Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0));
        if (Double.isInfinite(result)) {
            result = Double.MAX_VALUE;
        }
        return result;
    }
}

