/*
 * Decompiled with CFR 0.152.
 */
package catcat20.core.gun;

import catcat20.core.bot.Bot;
import catcat20.core.gun.Gun;
import java.awt.geom.Point2D;
import robocode.Rules;

public class VirtualBullet
extends Point2D.Double {
    public double angle;
    public double firePower;
    public long fireTime;
    public Gun gun;
    public Bot bot;
    public final double bulletVelocity;

    public VirtualBullet(double x, double y, double angle, double firePower, long fireTime, Gun gun, Bot bot) {
        super(x, y);
        this.angle = angle;
        this.firePower = firePower;
        this.fireTime = fireTime;
        this.gun = gun;
        this.bot = bot;
        this.bulletVelocity = Rules.getBulletSpeed((double)firePower);
    }

    public double distanceTraveled(long time) {
        return (double)(time - this.fireTime) * this.bulletVelocity;
    }

    public Point2D.Double simulatePos(long time) {
        return new Point2D.Double(this.x + this.bulletVelocity * Math.sin(this.angle) * (double)(time - this.fireTime), this.y + this.bulletVelocity * Math.cos(this.angle) * (double)(time - this.fireTime));
    }
}

