/*
 * Decompiled with CFR 0.152.
 */
package catcat20.core.utils;

import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Arrays;

public class OptimalPointPlacer {
    public static final int POINTS = 4;
    public static final DoubleBuffer intersectionBuf = new DoubleBuffer(32);
    public static final double[] resultX = new double[4];
    public static final double[] resultY = new double[4];
    private double centerX = 300.0;
    private double centerY = 300.0;
    private final double circleRadius = 100.0;

    public static void computePoints(RoundRectangle2D.Double boundary, double cx, double cy, double initialAngle, double radius, DoubleBuffer intersectionBuf, double[] outX, double[] outY) {
        intersectionBuf.clear();
        OptimalPointPlacer.findIntersectionsPrimitive(boundary, cx, cy, radius, intersectionBuf);
        AngleRange vr = OptimalPointPlacer.computeValidRangeFromIntersections(boundary, cx, cy, radius, intersectionBuf);
        if (vr.extent <= 1.0E-9) {
            for (int i = 0; i < 4; ++i) {
                outX[i] = cx;
                outY[i] = cy;
            }
            return;
        }
        int N = 4;
        double epsFull = 1.0E-9;
        if (vr.extent >= Math.PI * 2 - epsFull) {
            double step = 1.5707963267948966;
            double A = OptimalPointPlacer.normalizeAngle(initialAngle);
            int bestK = 0;
            int bestCount = -1;
            double halfWindow = 1.5707963267948966;
            for (int k = 0; k < 4; ++k) {
                double firstCandidate = A - (double)k * step;
                int cnt = 0;
                for (int i = 0; i < 4; ++i) {
                    double ang = OptimalPointPlacer.normalizeAngle(firstCandidate + (double)i * step);
                    double diff = Math.abs(OptimalPointPlacer.normalizeAngle(ang - A));
                    if (diff > Math.PI) {
                        diff = Math.PI * 2 - diff;
                    }
                    if (!(diff <= halfWindow + 1.0E-10)) continue;
                    ++cnt;
                }
                if (cnt <= bestCount) continue;
                bestCount = cnt;
                bestK = k;
            }
            double first = A - (double)bestK * step;
            for (int i = 0; i < 4; ++i) {
                double a = first + (double)i * step;
                outX[i] = cx + radius * Math.cos(a);
                outY[i] = cy + radius * Math.sin(a);
            }
            return;
        }
        double angleStep = vr.extent / 3.0;
        double totalSpan = vr.extent;
        double minCenter = vr.start + totalSpan / 2.0;
        double maxCenter = vr.start + vr.extent - totalSpan / 2.0;
        double normInit = OptimalPointPlacer.normalizeAngle(initialAngle - vr.start) + vr.start;
        double centerAng = Math.max(minCenter, Math.min(normInit, maxCenter));
        double first = centerAng - totalSpan / 2.0;
        for (int i = 0; i < 4; ++i) {
            double a = first + (double)i * angleStep;
            outX[i] = cx + radius * Math.cos(a);
            outY[i] = cy + radius * Math.sin(a);
        }
    }

    private static AngleRange computeValidRangeFromIntersections(RoundRectangle2D.Double boundary, double cx, double cy, double r, DoubleBuffer ib) {
        if (ib.size() == 0) {
            if (boundary.contains(new Rectangle2D.Double(cx - r, cy - r, 2.0 * r, 2.0 * r))) {
                return new AngleRange(0.0, Math.PI * 2);
            }
            return new AngleRange(0.0, Math.PI * 2);
        }
        int n = ib.size();
        double[] ang = new double[n];
        for (int i = 0; i < n; ++i) {
            ang[i] = OptimalPointPlacer.normalizeAngle(ib.get(i));
        }
        Arrays.sort(ang);
        int m = 0;
        for (int i = 0; i < n; ++i) {
            if (m != 0 && !(Math.abs(ang[i] - ang[m - 1]) > 1.0E-8)) continue;
            ang[m++] = ang[i];
        }
        if (m >= 2 && Math.abs(ang[0] + Math.PI * 2 - ang[m - 1]) < 1.0E-8) {
            ang[0] = ang[m - 1] - Math.PI * 2;
            System.arraycopy(ang, 1, ang, 1, --m - 1);
        }
        double bestStart = 0.0;
        double bestExtent = 0.0;
        for (int i = 0; i < m; ++i) {
            double ext;
            double my;
            double s = ang[i];
            double e = i + 1 < m ? ang[i + 1] : ang[0] + Math.PI * 2;
            double mid = s + (e - s) / 2.0;
            double mx = cx + r * Math.cos(mid);
            if (!boundary.contains(mx, my = cy + r * Math.sin(mid)) || !((ext = e - s) > bestExtent)) continue;
            bestExtent = ext;
            bestStart = s;
        }
        return new AngleRange(OptimalPointPlacer.normalizeAngle(bestStart), bestExtent);
    }

    private static void findIntersectionsPrimitive(RoundRectangle2D.Double rect, double cx, double cy, double r, DoubleBuffer out) {
        double x = rect.x;
        double y = rect.y;
        double w = rect.width;
        double h = rect.height;
        double aw = rect.arcwidth;
        double ah = rect.archeight;
        double arcR = aw / 2.0;
        OptimalPointPlacer.lineCircleIntersections(x + arcR, y, x + w - arcR, y, cx, cy, r, out);
        OptimalPointPlacer.lineCircleIntersections(x + arcR, y + h, x + w - arcR, y + h, cx, cy, r, out);
        OptimalPointPlacer.lineCircleIntersections(x, y + arcR, x, y + h - arcR, cx, cy, r, out);
        OptimalPointPlacer.lineCircleIntersections(x + w, y + arcR, x + w, y + h - arcR, cx, cy, r, out);
        OptimalPointPlacer.arcCircleIntersections(x + w - arcR, y + arcR, arcR, Math.toRadians(270.0), Math.toRadians(90.0), cx, cy, r, out);
        OptimalPointPlacer.arcCircleIntersections(x + arcR, y + arcR, arcR, Math.toRadians(180.0), Math.toRadians(90.0), cx, cy, r, out);
        OptimalPointPlacer.arcCircleIntersections(x + arcR, y + h - arcR, arcR, Math.toRadians(90.0), Math.toRadians(90.0), cx, cy, r, out);
        OptimalPointPlacer.arcCircleIntersections(x + w - arcR, y + h - arcR, arcR, Math.toRadians(0.0), Math.toRadians(90.0), cx, cy, r, out);
    }

    private static void lineCircleIntersections(double x1, double y1, double x2, double y2, double cx, double cy, double r, DoubleBuffer out) {
        double iy;
        double ix;
        double dx = x2 - x1;
        double dy = y2 - y1;
        double a = dx * dx + dy * dy;
        double b = 2.0 * (dx * (x1 - cx) + dy * (y1 - cy));
        double c = (x1 - cx) * (x1 - cx) + (y1 - cy) * (y1 - cy) - r * r;
        double det = b * b - 4.0 * a * c;
        if (a <= 1.0E-12 || det < 0.0) {
            return;
        }
        double sd = Math.sqrt(det);
        double t1 = (-b + sd) / (2.0 * a);
        double t2 = (-b - sd) / (2.0 * a);
        if (t1 >= 0.0 && t1 <= 1.0) {
            ix = x1 + t1 * dx;
            iy = y1 + t1 * dy;
            out.add(Math.atan2(iy - cy, ix - cx));
        }
        if (t2 >= 0.0 && t2 <= 1.0) {
            ix = x1 + t2 * dx;
            iy = y1 + t2 * dy;
            out.add(Math.atan2(iy - cy, ix - cx));
        }
    }

    private static void arcCircleIntersections(double ax, double ay, double arcR, double startRad, double extentRad, double cx, double cy, double r, DoubleBuffer out) {
        double dx = cx - ax;
        double dy = cy - ay;
        double d2 = dx * dx + dy * dy;
        double d = Math.sqrt(d2);
        if (d < 1.0E-12) {
            return;
        }
        if (d > arcR + r + 1.0E-12) {
            return;
        }
        if (d < Math.abs(arcR - r) - 1.0E-12) {
            return;
        }
        double a = (arcR * arcR - r * r + d2) / (2.0 * d);
        double h2 = arcR * arcR - a * a;
        if (h2 < -1.0E-12) {
            return;
        }
        double h = Math.sqrt(Math.max(0.0, h2));
        double xm = ax + a * (cx - ax) / d;
        double ym = ay + a * (cy - ay) / d;
        double rx = -(cy - ay) * (h / d);
        double ry = (cx - ax) * (h / d);
        double ix1 = xm + rx;
        double iy1 = ym + ry;
        double ix2 = xm - rx;
        double iy2 = ym - ry;
        double ang1Rel = OptimalPointPlacer.normalizeAngle(Math.atan2(iy1 - ay, ix1 - ax));
        double ang2Rel = OptimalPointPlacer.normalizeAngle(Math.atan2(iy2 - ay, ix2 - ax));
        if (OptimalPointPlacer.isAngleBetween(ang1Rel, startRad, extentRad)) {
            out.add(Math.atan2(iy1 - cy, ix1 - cx));
        }
        if (OptimalPointPlacer.isAngleBetween(ang2Rel, startRad, extentRad)) {
            out.add(Math.atan2(iy2 - cy, ix2 - cx));
        }
    }

    private static boolean isAngleBetween(double rel, double start, double extent) {
        double d = OptimalPointPlacer.normalizeAngle(rel - start);
        return d >= -1.0E-10 && d <= extent + 1.0E-10;
    }

    private static double normalizeAngle(double a) {
        double tp = Math.PI * 2;
        double r = a % tp;
        if (r < 0.0) {
            r += tp;
        }
        return r;
    }

    private static final class DoubleBuffer {
        double[] a;
        int size;

        DoubleBuffer(int cap) {
            this.a = new double[Math.max(8, cap)];
            this.size = 0;
        }

        void clear() {
            this.size = 0;
        }

        void add(double v) {
            if (this.size == this.a.length) {
                double[] b = new double[this.a.length * 2];
                System.arraycopy(this.a, 0, b, 0, this.a.length);
                this.a = b;
            }
            this.a[this.size++] = v;
        }

        int size() {
            return this.size;
        }

        double get(int i) {
            return this.a[i];
        }
    }

    private static final class AngleRange {
        double start;
        double extent;

        AngleRange(double s, double e) {
            this.start = s;
            this.extent = e;
        }
    }
}

