/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.data;

import dmh.robocode.data.BattleConstants;
import dmh.robocode.utils.Geometry;

public class Location {
    private double x;
    private double y;

    public Location(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Location(Location location) {
        if (location != null) {
            this.x = location.x;
            this.y = location.y;
        }
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Location other = (Location)obj;
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        return Double.doubleToLongBits(this.y) == Double.doubleToLongBits(other.y);
    }

    public boolean isSameAs(Location anotherLocation, double delta) {
        return Math.abs(anotherLocation.x - this.x) <= Math.abs(delta) && Math.abs(anotherLocation.y - this.y) <= Math.abs(delta);
    }

    public boolean isOnBattlefield(double width, double height) {
        return this.x >= 0.0 && this.y >= 0.0 && this.x <= width && this.y <= height;
    }

    public double getHowCloseToEdgeOfBattlefield(double width, double height) {
        if (!this.isOnBattlefield(width, height)) {
            return 0.0;
        }
        return Math.min(Math.min(Math.abs(width - this.x), Math.abs(height - this.y)), Math.min(this.x, this.y));
    }

    public double getHowCloseToEdgeOfBattlefield() {
        return this.getHowCloseToEdgeOfBattlefield(BattleConstants.getInstance().getBattlefieldWidth(), BattleConstants.getInstance().getBattlefieldHeight());
    }

    public boolean isOnBattlefield() {
        return this.isOnBattlefield(BattleConstants.getInstance().getBattlefieldWidth(), BattleConstants.getInstance().getBattlefieldHeight());
    }

    public byte getZone(double width, double height) {
        byte row = (byte)(this.y / height * 5.0);
        byte column = (byte)(this.x / width * 5.0);
        return (byte)((4 - row) * 5 + column + 1);
    }

    public byte getZone() {
        return this.getZone(BattleConstants.getInstance().getBattlefieldWidth(), BattleConstants.getInstance().getBattlefieldHeight());
    }

    public String getDebugString() {
        return "[ " + this.x + ", " + this.y + " ]";
    }

    public static Location getMidPoint(Location locationA, Location locationB) {
        return new Location((locationA.x + locationB.x) / 2.0, (locationA.y + locationB.y) / 2.0);
    }

    public void chopNearEdgesOfBattlefield(double xGap, double yGap) {
        if (this.x < xGap) {
            this.x = xGap;
        } else if (this.x > BattleConstants.getInstance().getBattlefieldWidth() - xGap) {
            this.x = BattleConstants.getInstance().getBattlefieldWidth() - xGap;
        }
        if (this.y < yGap) {
            this.y = yGap;
        } else if (this.y > BattleConstants.getInstance().getBattlefieldHeight() - yGap) {
            this.y = BattleConstants.getInstance().getBattlefieldHeight() - yGap;
        }
    }

    public int getLostDegreesOfFreedom(int bearingGap, double distance) {
        int result = 0;
        for (int bearing = 0; bearing < 360; bearing += bearingGap) {
            if (Geometry.getLocationAtBearing(this, bearing, distance).isOnBattlefield()) continue;
            ++result;
        }
        return result;
    }
}

