/*
 * Decompiled with CFR 0.152.
 */
package bjl;

import bjl.BattleField;
import bjl.Blip;
import bjl.Command;
import bjl.Enemy;
import bjl.EnemyList;
import bjl.ExtendedBlip;
import bjl.FireDemand;
import bjl.IndividualCommand;
import bjl.Plan;
import bjl.Point;
import bjl.RobotColors;
import bjl.StrategyManager;
import bjl.SuperBlip;
import bjl.Utils;
import bjl.fire.PointStrat;
import java.awt.Color;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.MessageEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

public class LoneDragon
extends AdvancedRobot {
    private static boolean isInited = false;
    private static PointStrat pointStrat = new PointStrat();
    private boolean isLeader = false;
    private boolean forward = true;
    private Enemy leader = null;
    private Enemy me = null;
    private int type = 1;
    private HitByBulletEvent byBulletEvt;
    private HitRobotEvent hitRobotEvt;
    private HitWallEvent hitWallEvt;

    public void run() {
        if (this.getEnergy() > 180.0) {
            this.isLeader = true;
            this.type = 2;
        } else if (this.getEnergy() > 110.0) {
            this.type = 0;
        }
        BattleField.setBlip(this.selfBlip());
        if (!isInited) {
            BattleField.setBattleField(this.getBattleFieldWidth(), this.getBattleFieldHeight());
            BattleField.setOthers(this.getOthers());
            BattleField.setNumRounds(this.getNumRounds());
            BattleField.setCoolRate(this.getGunCoolingRate());
            EnemyList.init();
            StrategyManager.init(this.type);
            isInited = true;
            this.me = new Enemy(this.getName(), true, this.getEnergy(), true);
            EnemyList.addEnemy(this.me);
        } else {
            BattleField.setOthersAlive(this.getOthers());
            EnemyList.reInit();
            StrategyManager.reInit();
            this.me = EnemyList.getEnemy(this.getName());
        }
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        while (true) {
            FireDemand f;
            if (this.getTime() == 1L) {
                this.pickLeader();
            }
            BattleField.setBlip(this.selfBlip());
            EnemyList.calculateInfo();
            this.me.addBlip(BattleField.getMe());
            this.sendBlip(ExtendedBlip.makeExtendedBlip(BattleField.getMe()), this.me.getName());
            Plan p = StrategyManager.getPlan(this.isLeader);
            if (p.radarAngle != 0.0) {
                this.setTurnRadarRight(p.radarAngle);
            }
            if (p.move.setAhead) {
                this.setAhead(p.move.ahead);
            }
            if (p.move.setRight) {
                this.setTurnRight(p.move.right);
            }
            if (p.move.maxSpeed != 0.0) {
                this.setMaxVelocity(p.move.maxSpeed);
            } else {
                this.setMaxVelocity(8.0);
            }
            if (p.move.maxTurn != 0.0) {
                this.setMaxTurnRate(p.move.maxTurn);
            } else {
                this.setMaxTurnRate(10.0);
            }
            Enumeration e = p.commands.elements();
            while (e.hasMoreElements()) {
                Command c = (Command)e.nextElement();
                if (c instanceof IndividualCommand) {
                    if (this.getName().equals(((IndividualCommand)c).to)) {
                        this.receiveCommand(c, this.getName());
                        continue;
                    }
                    this.sendCommand(c);
                    continue;
                }
                this.sendCommand(c);
                this.receiveCommand(c, this.getName());
            }
            if (p.target != EnemyList.getTarget()) {
                if (p.target != null) {
                    BattleField.println("I am targetting " + p.target.getName() + " at time " + this.getTime() + " round num " + this.getRoundNum());
                } else {
                    BattleField.println("I am targetting null at time " + this.getTime() + " round num " + this.getRoundNum());
                }
                EnemyList.setTarget(p.target);
            }
            if (p.target == null) {
                Point tPoint = BattleField.getTargetPoint();
                if (tPoint == null) {
                    this.execute();
                    continue;
                }
                pointStrat.setPoint(tPoint);
                f = pointStrat.getFireDemand();
                BattleField.setTargetPoint(null);
            } else {
                f = p.target.getFireDemand();
            }
            double gunTurn = Utils.normalRelativeAngle(this.getGunHeading() - f.bearing);
            if (f.prob < 0.0) {
                gunTurn = 0.0;
            }
            this.setTurnGunLeft(gunTurn);
            if (this.getGunHeat() == 0.0 && Math.abs(gunTurn) < 4.0) {
                this.doFire(f);
                continue;
            }
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        if (EnemyList.getEnemy(e.getName()) == null) {
            EnemyList.addEnemy(new Enemy(e.getName(), this.isTeammate(e.getName()), e.getEnergy(), false));
        }
        Enemy en = EnemyList.getEnemy(e.getName());
        double enemyBearing = this.getHeading() + e.getBearing();
        double enemyX = this.getX() + e.getDistance() * Math.sin(Math.toRadians(enemyBearing));
        double enemyY = this.getY() + e.getDistance() * Math.cos(Math.toRadians(enemyBearing));
        Blip b = new Blip(new Point(enemyX, enemyY), e.getTime(), this.getRoundNum(), e.getEnergy(), e.getHeading(), e.getVelocity());
        if (this.isTeammate(e.getName())) {
            return;
        }
        if (!en.haveBlip(e.getTime())) {
            en.addBlip(b);
        }
        this.sendBlip(b, en.getName());
    }

    public void onMessageReceived(MessageEvent e) {
        if (e.getMessage() instanceof Command) {
            this.receiveCommand((Command)e.getMessage(), e.getSender());
        } else if (e.getMessage() instanceof RobotColors) {
            RobotColors c = (RobotColors)e.getMessage();
            this.setColors(c.getBodyColor(), c.getGunColor(), c.getRadarColor());
            BattleField.println("Colours changing");
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        Enemy en;
        this.byBulletEvt = e;
        StrategyManager.onHit();
        double damage = 4.0 * e.getBullet().getPower();
        if (damage > 4.0) {
            damage += damage / 2.0 - 2.0;
        }
        if ((en = EnemyList.getEnemy(e.getName())) == null) {
            return;
        }
        en.addDamageDone(damage);
        en.addDamage(-3.0 * e.getBullet().getPower());
    }

    public void onHitRobot(HitRobotEvent e) {
        this.hitRobotEvt = e;
    }

    public void onHitWall(HitWallEvent e) {
        this.hitWallEvt = e;
    }

    public void onRobotDeath(RobotDeathEvent e) {
        BattleField.setOthersAlive(this.getOthers());
        if (StrategyManager.getCurrentTarget().equals(e.getName())) {
            BattleField.println("Death of " + e.getName() + " - Target");
            StrategyManager.setCurrentTarget(null);
        } else {
            BattleField.println("Death of " + e.getName());
        }
        EnemyList.getEnemy(e.getName()).setDead();
        if (e.getName().equals(this.leader.getName())) {
            BattleField.println("Leader died.");
            this.pickLeader();
        }
    }

    public void onDeath(DeathEvent e) {
        StrategyManager.onFinish();
        BattleField.doWin(false, (this.getRoundNum() + 1) % 10 == 0);
    }

    public void onWin(WinEvent e) {
        StrategyManager.onFinish();
        BattleField.doWin(true, (this.getRoundNum() + 1) % 10 == 0);
    }

    public void onBulletHit(BulletHitEvent e) {
        String stratname;
        double damage = 4.0 * e.getBullet().getPower();
        if (damage > 4.0) {
            damage += damage / 2.0 - 2.0;
        }
        if ((stratname = EnemyList.doHit(e.getBullet(), e.getName())) != null) {
            BattleField.addDamage(damage);
            Command c = new Command(5, (Serializable)((Object)e.getName()), (Serializable)((Object)stratname));
            this.sendCommand(c);
        }
    }

    public void onBulletMissed(BulletMissedEvent e) {
        Command c = EnemyList.doMiss(e.getBullet());
        if (c != null) {
            this.sendCommand(c);
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        EnemyList.doHitBullet(e.getBullet());
    }

    public void pickLeader() {
        if (this.type == 2) {
            this.isLeader = true;
            this.leader = this.me;
            this.SendColor();
        } else {
            this.leader = null;
            this.isLeader = true;
            Enumeration en = EnemyList.getHashElements();
            boolean sameEnergy = false;
            while (en.hasMoreElements()) {
                Enemy temp = (Enemy)en.nextElement();
                if (!this.isTeammate(temp.getName()) && temp != this.me || temp.isDead()) continue;
                if (this.leader == null) {
                    this.leader = temp;
                    continue;
                }
                if (this.leader.getLastBlip().energy < temp.getLastBlip().energy) {
                    this.leader = temp;
                    continue;
                }
                if (!(this.leader.getLastBlip().energy < temp.getLastBlip().energy) || this.leader.getName().compareTo(temp.getName()) >= 0) continue;
                this.leader = temp;
            }
            if (this.leader.getName().compareTo(this.me.getName()) == 0) {
                this.isLeader = true;
                this.SendColor();
            }
        }
        BattleField.println("The leader is " + this.leader.getName() + " at time: " + this.getTime());
    }

    public SuperBlip selfBlip() {
        return new SuperBlip(new Blip(new Point(this.getX(), this.getY()), this.getTime(), this.getRoundNum(), this.getEnergy(), this.getHeading(), this.getVelocity()), this.getDistanceRemaining(), this.getTurnRemaining(), this.getGunTurnRemaining(), this.getRadarTurnRemaining(), this.getGunHeading(), this.getGunHeat(), this.getRadarHeading(), this.byBulletEvt, this.hitRobotEvt, this.hitWallEvt);
    }

    public void sendBlip(Blip b, String n) {
        this.sendCommand(new Command(1, b, (Serializable)((Object)n)));
    }

    public void receiveCommand(Command c, String sender) {
        if (c instanceof IndividualCommand && !((IndividualCommand)c).to.equals(this.getName())) {
            return;
        }
        switch (c.com) {
            case 1: {
                Enemy en;
                Blip b = (Blip)c.data;
                String enemyName = (String)((Object)c.data2);
                if (EnemyList.getEnemy(enemyName) == null) {
                    EnemyList.addEnemy(new Enemy(enemyName, this.isTeammate(enemyName), b.energy, false));
                }
                if ((en = EnemyList.getEnemy(enemyName)).haveBlip(b.time) || en.getName().equals(this.me.getName())) break;
                en.addBlip(b);
                break;
            }
            case 4: {
                String enemyName = (String)((Object)c.data);
                if (enemyName == null) {
                    StrategyManager.setCurrentTarget(null);
                } else {
                    StrategyManager.setCurrentTarget(EnemyList.getEnemy(enemyName));
                }
                BattleField.println("Have been told to target " + enemyName);
                break;
            }
            case 5: {
                String enemyName = (String)((Object)c.data);
                Enemy en = EnemyList.getEnemy(enemyName);
                en.info((String)((Object)c.data2), true);
                break;
            }
            case 6: {
                String enemyName = (String)((Object)c.data);
                Enemy en = EnemyList.getEnemy(enemyName);
                en.info((String)((Object)c.data2), false);
                break;
            }
            case 102: {
                StrategyManager.setScanTarget((String)((Object)c.data));
                break;
            }
            case 103: {
                StrategyManager.setScanTarget(null);
                break;
            }
            case 111: {
                StrategyManager.setStrategyData((Vector)c.data, (Vector)c.data2);
            }
        }
    }

    public void doFire(FireDemand dem) {
        Bullet bullet;
        if (this.getGunHeat() != 0.0 || this.getEnergy() == 0.0 || dem.power == 0.0 || dem.power >= this.getEnergy()) {
            this.execute();
            return;
        }
        double pow = BattleField.getFirePower();
        if (pow != 0.0) {
            bullet = this.fireBullet(pow);
            BattleField.setFirePower(0.0);
        } else {
            bullet = this.fireBullet(dem.power);
        }
        if (bullet == null) {
            BattleField.println("Gun heat is zero, but we can't fire (!!!?!?!)");
            this.execute();
            return;
        }
        EnemyList.doFire(bullet, dem);
    }

    public void sendMiss(String e, String fs) {
        this.sendCommand(new Command(6, (Serializable)((Object)e), (Serializable)((Object)fs)));
    }

    public void execute() {
        this.byBulletEvt = null;
        this.hitRobotEvt = null;
        this.hitWallEvt = null;
        super.execute();
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
        BattleField.println("Skipped turn at " + e.getTime());
        EnemyList.skipped(e.getTime());
    }

    public void SendColor() {
        Color myColor = new Color((float)Math.random(), (float)Math.random(), (float)Math.random());
        this.setColors(myColor, Color.black, Color.blue);
        if (this.getTeammates() != null) {
            this.broadcastMessage(new RobotColors(myColor, Color.black, Color.blue));
        }
    }

    public void sendCommand(Command com) {
        if (this.getTeammates() == null) {
            return;
        }
        if (com instanceof IndividualCommand) {
            this.sendMessage(((IndividualCommand)com).to, com);
        } else {
            this.broadcastMessage(com);
        }
    }

    public boolean isTeammate(String s) {
        return false;
    }

    public String[] getTeammates() {
        return null;
    }

    public void sendMessage(String Name, Serializable message) {
    }

    public void broadcastMessage(Serializable message) {
    }
}

