/*
 * Decompiled with CFR 0.152.
 */
package bjl.fire;

import bjl.BattleField;
import bjl.Blip;
import bjl.Enemy;
import bjl.EnemyList;
import bjl.FireDemand;
import bjl.PatternBlip;
import bjl.Point;
import bjl.fire.FireStrategy;

public class PatternMatch
extends FireStrategy {
    protected long curPatternTime;

    public String toString() {
        return "PatternMatch";
    }

    public void reInit() {
        super.reInit();
        this.curPatternTime = -1;
    }

    public void doTick() {
        int length;
        super.doTick();
        if (EnemyList.getNumOpponents() != 1) {
            return;
        }
        if (this.enemy.isTeammate() || this.enemy.isDead()) {
            return;
        }
        if (BattleField.getTime() < 120L) {
            this.curPatternTime = -1;
            return;
        }
        long now = BattleField.getTime() - 31L;
        long ans = -1;
        double curVal = 75.0;
        try {
            length = 2000 / EnemyList.getNumOpponents();
        }
        catch (ArithmeticException db0) {
            System.out.println("Error predicting for " + this.enemy.getName() + ": no opponents?!?");
            this.curPatternTime = -1;
            return;
        }
        if (length < 100) {
            this.curPatternTime = -1;
            return;
        }
        long start = BattleField.getTime() - 61L - (long)length;
        if (start < 0L) {
            start = 0L;
        }
        long then = BattleField.getTime() - 61L;
        while (then > start) {
            double tVal = 0.0;
            int i = 0;
            while (i <= 30) {
                PatternBlip t1 = this.enemy.getPBlip(then + (long)i);
                PatternBlip t2 = this.enemy.getPBlip(now + (long)i);
                tVal = t1 != null && t2 != null ? (tVal += Math.abs(t1.distVel - t2.distVel) + Math.abs(t1.turnRate - t2.turnRate)) : (tVal += (double)5);
                if (tVal > curVal) break;
                ++i;
            }
            if (tVal < curVal) {
                ans = then;
                curVal = tVal;
            }
            --then;
        }
        this.curPatternTime = curVal < 75.0 ? ans + 30L : (long)-1;
    }

    public Point getPosition(long time) {
        if (EnemyList.getNumOpponents() != 1) {
            return new Point(0.0, 0.0);
        }
        Blip b = new Blip(this.enemy.getBlipBefore(time));
        long now = b.time;
        long then = this.curPatternTime - (BattleField.getTime() - now);
        long deltaTime = 0L;
        if (time - now > 30L || this.curPatternTime == (long)-1) {
            return b.pos;
        }
        int i = 0;
        while ((long)i + now < time) {
            ++deltaTime;
            PatternBlip p = this.enemy.getPBlip((long)i + then);
            if (p != null) {
                b.head += p.turnRate * (double)deltaTime;
                b.pos.x += Math.sin(Math.toRadians(b.head)) * p.vel * (double)deltaTime;
                b.pos.y += Math.cos(Math.toRadians(b.head)) * p.vel * (double)deltaTime;
                b.vel = p.vel;
                deltaTime = 0L;
            }
            ++i;
        }
        b.pos.x += Math.sin(Math.toRadians(b.head)) * b.vel * (double)deltaTime;
        b.pos.y += Math.cos(Math.toRadians(b.head)) * b.vel * (double)deltaTime;
        return b.pos;
    }

    protected FireDemand getFireDemand() {
        if (EnemyList.getNumOpponents() != 1) {
            return new FireDemand(0.0, -1.0, 0.0, 0.0, this);
        }
        double pow = 0.0;
        Blip b = new Blip(this.enemy.getLastBlip());
        Point pos = BattleField.getPos();
        Point them = new Point(b.pos);
        long now = b.time;
        long then = this.curPatternTime - (BattleField.getTime() - now);
        long deltaTime = 0L;
        if (then < 0L) {
            return new FireDemand(0.0, -1.0, 0.0, 0.0, this);
        }
        double power = (20.0 - b.pos.dist(pos) / Math.min(20.0, 50.0 * Math.sqrt(this.getProb()))) / (double)3;
        double prob = this.getProb();
        if (power < 0.1) {
            power = 0.1;
        }
        if (power > (double)3) {
            power = 3;
        }
        int i = 0;
        while (i < 30) {
            Point bulletPos = Point.makePoint(pos, pos.angleTo(them), (20.0 - (double)3 * power) * (double)(now + (long)i - BattleField.getTime()));
            if (Math.abs(bulletPos.dist(them)) < 10.0) break;
            ++deltaTime;
            PatternBlip p = this.enemy.getPBlip((long)i + then);
            if (p == null) {
                them.x += Math.sin(Math.toRadians(b.head)) * b.vel;
                them.y += Math.cos(Math.toRadians(b.head)) * b.vel;
            } else {
                int j = 0;
                while ((long)j < deltaTime) {
                    b.head += p.turnRate;
                    b.pos.x += Math.sin(Math.toRadians(b.head)) * p.vel;
                    b.pos.y += Math.cos(Math.toRadians(b.head)) * p.vel;
                    ++j;
                }
                b.vel = p.vel;
                them = new Point(b.pos);
                deltaTime = 0L;
            }
            ++i;
        }
        if (i == 30) {
            return new FireDemand(0.0, -1.0, 0.0, 0.0, this);
        }
        double bear = pos.angleTo(them);
        double dist = pos.dist(them);
        if (them.isOutsideArena()) {
            return new FireDemand(0.0, -1.0, 0.0, 0.0, this);
        }
        if (this.bulletsFired < 5) {
            prob = 1.0;
        }
        return new FireDemand(power, prob, bear, dist, this);
    }

    public PatternMatch(Enemy t) {
        super(t);
    }
}

