/*
 * Decompiled with CFR 0.152.
 */
package agrach;

import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import robocode.TurnCompleteCondition;
import robocode.util.Utils;

public class MicroDalek
extends AdvancedRobot {
    private ScannedRobotEvent target = null;
    private ScannedRobotEvent old = null;
    private int shotCount = 0;
    private int hitCount = 0;
    private int changeDirByHit = 1;
    private double firePower;
    private int moveDir = 1;

    public void run() {
        this.setTurnRadarLeft(360.0);
        while (true) {
            this.waitFor((Condition)new TurnCompleteCondition((AdvancedRobot)this));
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double tankTurn;
        this.old = this.target;
        this.target = e;
        double tankAhead = 100.0;
        double maxTankTurn = 10.0 - 0.75 * Math.abs(this.getVelocity());
        if (this.getX() < 80.0 || this.getY() < 80.0 || this.getX() > this.getBattleFieldWidth() - 80.0 || this.getY() > this.getBattleFieldHeight() - 80.0) {
            tankTurn = e.getBearing() - 15.0 + Math.random() * 25.0;
            this.moveDir = 1;
        } else {
            if (this.old != null && this.target.getEnergy() < this.old.getEnergy() && this.shotCount % this.changeDirByHit == 0) {
                this.moveDir *= -1;
                ++this.shotCount;
            }
            if (this.getTime() % 9L == 0L) {
                tankAhead = 5.0;
            }
            tankTurn = e.getBearing() + 90.0 - 15.0 + Math.random() * 25.0;
        }
        if (tankTurn > maxTankTurn) {
            tankTurn = maxTankTurn;
        } else if (tankTurn < -maxTankTurn) {
            tankTurn = -maxTankTurn;
        }
        double gunTurn = this.getGunRelativeHeading();
        gunTurn -= Utils.normalRelativeAngleDegrees((double)(this.getGunHeading() - this.getHeading()));
        gunTurn -= tankTurn;
        gunTurn = this.optimizeTurn(gunTurn);
        double radarTurn = this.getHeading() - this.getRadarHeading() + e.getBearing();
        radarTurn = Math.abs(gunTurn) < 20.0 ? (radarTurn -= gunTurn) : (gunTurn > 0.0 ? (radarTurn -= 20.0) : (radarTurn += 20.0));
        radarTurn -= tankTurn;
        radarTurn = this.optimizeTurn(radarTurn);
        this.setTurnRight(tankTurn);
        this.setTurnGunRight(gunTurn);
        this.setTurnRadarRight(radarTurn);
        this.setAhead(tankAhead * (double)this.moveDir);
        this.setFire(this.firePower);
    }

    public void onHitByBullet(HitByBulletEvent event) {
        ++this.hitCount;
        if ((double)(this.shotCount / this.hitCount) > 1.5) {
            this.changeDirByHit %= 2;
            ++this.changeDirByHit;
            this.shotCount = 0;
            this.hitCount = 0;
        }
    }

    private double getGunRelativeHeading() {
        double relHeading;
        double bearing = this.target.getBearing();
        double velocity = this.target.getVelocity();
        double heading = this.target.getHeading();
        this.firePower = Math.min(450.0 / this.target.getDistance(), 3.0);
        double bulletSpeed = 20.0 - this.firePower * 3.0;
        double gama = 180.0 - (heading - (this.getHeading() + bearing) % 180.0);
        gama = Math.toRadians(Math.abs(gama) % 180.0);
        double gunHeading = Math.abs(Math.toDegrees(Math.asin(velocity / bulletSpeed * Math.sin(gama))));
        double absBearing = this.getHeading() + bearing;
        if (absBearing > 180.0) {
            absBearing -= 360.0;
        }
        if ((relHeading = heading - absBearing) > 180.0) {
            relHeading -= 360.0;
        }
        gunHeading = relHeading * velocity >= 0.0 ? bearing + gunHeading : bearing - gunHeading;
        return gunHeading;
    }

    private double optimizeTurn(double turn) {
        if (turn > 180.0) {
            turn -= 360.0;
        } else if (turn < -180.0) {
            turn += 360.0;
        }
        return turn;
    }
}

