/*
 * Decompiled with CFR 0.152.
 */
package deo.virtual;

import deo.virtual.AdvancedEnemyBot;
import deo.virtual.Gun;
import java.awt.Color;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.util.Utils;

public class CircularTargetingGun
extends Gun {
    double oldEnemyHeading = 0.0;

    CircularTargetingGun() {
    }

    @Override
    public double getFireAngle(AdvancedRobot shooter, AdvancedEnemyBot e, double BulletPower) {
        double bulletPower = Math.min(3.0, shooter.getEnergy());
        double myX = shooter.getX();
        double myY = shooter.getY();
        double absoluteBearing1 = shooter.getHeadingRadians() + e.getBearingRadians();
        double enemyX = shooter.getX() + e.getDistance() * Math.sin(absoluteBearing1);
        double enemyY = shooter.getY() + e.getDistance() * Math.cos(absoluteBearing1);
        double enemyHeading = e.getHeadingRadians();
        double enemyHeadingChange = enemyHeading - this.oldEnemyHeading;
        double enemyVelocity = e.getVelocity();
        this.oldEnemyHeading = enemyHeading;
        double deltaTime = 0.0;
        double battleFieldHeight = shooter.getBattleFieldHeight();
        double battleFieldWidth = shooter.getBattleFieldWidth();
        double predictedX = enemyX;
        double predictedY = enemyY;
        while ((deltaTime += 1.0) * (20.0 - 3.0 * bulletPower) < Point2D.Double.distance(myX, myY, predictedX, predictedY)) {
            predictedY += Math.cos(enemyHeading) * enemyVelocity;
            if (!((predictedX += Math.sin(enemyHeading += enemyHeadingChange) * enemyVelocity) < 18.0 || predictedY < 18.0 || predictedX > battleFieldWidth - 18.0) && !(predictedY > battleFieldHeight - 18.0)) continue;
            predictedX = Math.min(Math.max(18.0, predictedX), battleFieldWidth - 18.0);
            predictedY = Math.min(Math.max(18.0, predictedY), battleFieldHeight - 18.0);
            break;
        }
        double theta = Utils.normalAbsoluteAngle((double)Math.atan2(predictedX - shooter.getX(), predictedY - shooter.getY()));
        return theta;
    }

    @Override
    public Color getColor() {
        return Color.DARK_GRAY;
    }

    @Override
    public String getName() {
        return "Circular Targeting Gun";
    }
}

