/*
 * Decompiled with CFR 0.152.
 */
package ntw;

import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Sigsys
extends AdvancedRobot {
    private double shootAngle;
    private double firePower = 2.0;
    private boolean moving = false;

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setTurnRadarRight(Double.POSITIVE_INFINITY);
        while (true) {
            this.move();
            this.shoot();
            this.execute();
        }
    }

    private void move() {
        if (Math.abs(this.getDistanceRemaining()) < 1.0) {
            double d = Math.random() * 200.0;
            this.setBack(d);
            if (this.moving) {
                this.setAhead(d);
            }
            this.moving = !this.moving;
            double d2 = (Math.random() - 0.5) * 150.0;
            this.setTurnRight(d2);
            if (d2 < 0.0) {
                this.setTurnLeft(-d2);
            }
        }
    }

    private void shoot() {
        double d = this.shootAngle - this.getGunHeadingRadians();
        if (Math.abs(d) < 0.05) {
            this.setFire(this.firePower);
        } else {
            d = Utils.normalAbsoluteAngle((double)d);
            this.setTurnGunRightRadians(d);
            if (d > Math.PI) {
                this.setTurnGunLeftRadians(Math.PI * 2 - d);
            }
        }
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
        this.firePower = scannedRobotEvent.getDistance() < 200.0 ? 3.0 : 2.0;
        this.shootAngle = Utils.normalAbsoluteAngle((double)(this.getHeadingRadians() + scannedRobotEvent.getBearingRadians() + (Math.random() - 0.5) * Math.atan2(this.getVelocity(), 14.0)));
    }
}

