/*
 * Decompiled with CFR 0.152.
 */
package rampancy.util;

import rampancy.RampantRobot;
import rampancy.util.RDistanceFunction;
import rampancy.util.REnemyRobot;
import rampancy.util.RPoint;
import rampancy.util.RUtil;
import rampancy.util.data.segmentArray.RSegmentFunction;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class RRobotState {
    public RPoint location;
    public double absoluteBearing;
    public double velocity;
    public double lateralVelocity;
    public double advancingVelocity;
    public double deltaV;
    public double heading;
    public double deltaH;
    public double distance;
    public double distanceFromWall;
    public int distanceFromWallCategory;
    public double timeSinceVelocityChange;
    public double timeSinceDirectionChange;
    public double timeSinceStop;
    public double energy;
    public boolean accelerating;
    public boolean breaking;
    public int directionTraveling;
    public static final RDistanceFunction<RRobotState> DELTA_H_DISTANCE_FUNCTION = new RDistanceFunction<RRobotState>(){

        @Override
        public double distance(RRobotState o1, RRobotState o2) {
            return 0.0;
        }
    };
    public static final RSegmentFunction DISTANCE_SEGMENT_FUNCTION = new RSegmentFunction(){

        public int getIndexForState(RRobotState state, int segmentSize) {
            return (int)RUtil.scaleToRange(0.0, segmentSize - 1, 0.0, 18.0, state.distance);
        }
    };
    public static final RSegmentFunction DISTANCE_FROM_WALL_SEGMENT_FUNCTION = new RSegmentFunction(){

        public int getIndexForState(RRobotState state, int segmentSize) {
            return RampantRobot.getGlobalBattlefield().distanceFromWallCategory(state.location);
        }
    };
    public static final RSegmentFunction VELOCITY_SEGMENT_FUNCTION = new RSegmentFunction(){

        public int getIndexForState(RRobotState state, int segmentSize) {
            return (int)RUtil.scaleToRange(0.0, segmentSize - 1, -8.0, 8.0, state.velocity, segmentSize / 2);
        }
    };
    public static final RSegmentFunction LATERAL_VELOCITY_SEGMENT_FUNCTION = new RSegmentFunction(){

        public int getIndexForState(RRobotState state, int segmentSize) {
            return (int)RUtil.scaleToRange(0.0, segmentSize - 1, -8.0, 8.0, state.lateralVelocity, segmentSize / 2);
        }
    };
    public static final RSegmentFunction ADVANCING_VELOCITY_SEGMENT_FUNCTION = new RSegmentFunction(){

        public int getIndexForState(RRobotState state, int segmentSize) {
            return (int)RUtil.scaleToRange(0.0, segmentSize - 1, -8.0, 8.0, state.advancingVelocity, segmentSize / 2);
        }
    };
    public static final RSegmentFunction DELTA_V_SEGMENT_FUNCTION = new RSegmentFunction(){

        public int getIndexForState(RRobotState state, int segmentSize) {
            return (int)RUtil.scaleToRange(0.0, segmentSize - 1, -8.0, 8.0, state.deltaV, segmentSize / 2);
        }
    };
    public static final RSegmentFunction ABSOLUTE_BEARING_SEGMENT_FUNCTION = new RSegmentFunction(){

        public int getIndexForState(RRobotState state, int segmentSize) {
            return (int)RUtil.scaleToRange(0.0, segmentSize - 1, 0.0, Math.PI * 2, state.absoluteBearing);
        }
    };
    public static final RSegmentFunction HEADNG_SEGMENT_FUNCTION = new RSegmentFunction(){

        public int getIndexForState(RRobotState state, int segmentSize) {
            return (int)RUtil.scaleToRange(0.0, segmentSize - 1, 0.0, Math.PI * 2, state.heading);
        }
    };
    public static final RSegmentFunction DELTA_H_SEGMENT_FUNCTION = new RSegmentFunction(){

        public int getIndexForState(RRobotState state, int segmentSize) {
            return (int)RUtil.scaleToRange(0.0, segmentSize - 1, 0.0, Math.PI, state.deltaH);
        }
    };
    public static final RSegmentFunction TIME_SINCE_VELOCITY_CHANGE_SEGMENT_FUNCTION = new RSegmentFunction(){

        public int getIndexForState(RRobotState state, int segmentSize) {
            return (int)RUtil.scaleToRange(0.0, segmentSize - 1, 0.0, 1000.0, state.timeSinceVelocityChange);
        }
    };
    public static final RSegmentFunction TIME_SINCE_DIRECTION_CHANGE_SEGMENT_FUNCTION = new RSegmentFunction(){

        public int getIndexForState(RRobotState state, int segmentSize) {
            return (int)RUtil.scaleToRange(0.0, segmentSize - 1, 0.0, 1000.0, state.timeSinceDirectionChange);
        }
    };
    public static final RSegmentFunction TIME_SINCE_STOP_SEGMENT_FUCNTION = new RSegmentFunction(){

        public int getIndexForState(RRobotState state, int segmentSize) {
            return (int)RUtil.scaleToRange(0.0, segmentSize - 1, 0.0, 1000.0, state.timeSinceStop);
        }
    };
    public static final RSegmentFunction ACCELERATING_OR_BREAKING_SEGMENT_FUNCTION = new RSegmentFunction(){

        public int getIndexForState(RRobotState state, int segmentSize) {
            if (state.breaking) {
                return 0;
            }
            if (state.accelerating) {
                return 1;
            }
            return 2;
        }
    };
    public static final RSegmentFunction DIRECTION_TRAVELING_SEGMENT_FUNCTION = new RSegmentFunction(){

        public int getIndexForState(RRobotState state, int segmentSize) {
            return 1 + state.directionTraveling;
        }
    };

    public RRobotState() {
    }

    public RRobotState(RampantRobot robot, ScannedRobotEvent e) {
        RRobotState lastState = robot.getCurrentState();
        double enemyAbsoluteBearing = e == null ? 0.0 : Utils.normalAbsoluteAngle((double)(robot.getHeadingRadians() + e.getBearingRadians()));
        double enemyDistance = e == null ? 100.0 : e.getDistance();
        this.location = new RPoint(robot.getX(), robot.getY());
        RPoint enemyLocation = RUtil.project(this.location, enemyAbsoluteBearing, enemyDistance);
        this.absoluteBearing = RUtil.computeAbsoluteBearing(enemyLocation, this.location);
        this.heading = robot.getHeadingRadians();
        this.velocity = robot.getVelocity();
        this.lateralVelocity = this.velocity * Math.sin(this.heading - this.absoluteBearing);
        this.advancingVelocity = 0.0;
        this.deltaV = lastState == null ? 0.0 : this.velocity - lastState.velocity;
        this.accelerating = this.deltaV > 0.0;
        this.breaking = !this.accelerating;
        this.deltaH = lastState == null ? 0.0 : this.heading - lastState.heading;
        this.distance = 0.0;
        this.distanceFromWall = RUtil.getDistanceFromWall(this.location);
        this.distanceFromWallCategory = RampantRobot.getGlobalBattlefield().distanceFromWallCategory(this.location);
        this.timeSinceVelocityChange = this.deltaV != 0.0 || lastState == null ? 0.0 : lastState.timeSinceVelocityChange + 1.0;
        this.directionTraveling = this.lateralVelocity >= 0.0 ? 1 : -1;
        this.timeSinceDirectionChange = lastState == null || lastState.directionTraveling != this.directionTraveling ? 0.0 : lastState.timeSinceDirectionChange + 1.0;
        this.timeSinceStop = this.velocity == 0.0 || lastState == null ? 0.0 : lastState.timeSinceStop + 1.0;
        this.energy = robot.getEnergy();
    }

    public RRobotState(REnemyRobot robot, ScannedRobotEvent e) {
        RampantRobot reference = robot.getReference();
        if (reference == null) {
            return;
        }
        RRobotState lastState = robot.getCurrentState();
        this.heading = e.getHeadingRadians();
        this.absoluteBearing = Utils.normalAbsoluteAngle((double)(reference.getHeadingRadians() + e.getBearingRadians()));
        this.location = RUtil.project(reference.getLocation(), this.absoluteBearing, e.getDistance());
        this.velocity = e.getVelocity();
        this.lateralVelocity = this.velocity * Math.sin(this.heading - this.absoluteBearing);
        this.advancingVelocity = this.velocity * -1.0 * Math.cos(this.heading - this.absoluteBearing);
        this.deltaV = lastState == null ? 0.0 : this.velocity - lastState.velocity;
        this.accelerating = this.deltaV > 0.0;
        this.breaking = !this.accelerating;
        this.deltaH = lastState == null ? 0.0 : this.heading - lastState.heading;
        this.distance = e.getDistance();
        this.distanceFromWall = RUtil.getDistanceFromWall(this.location);
        this.distanceFromWallCategory = RampantRobot.getGlobalBattlefield().distanceFromWallCategory(this.location);
        this.timeSinceVelocityChange = this.deltaV != 0.0 || lastState == null ? 0.0 : lastState.timeSinceVelocityChange + 1.0;
        this.directionTraveling = this.lateralVelocity >= 0.0 ? 1 : -1;
        this.timeSinceDirectionChange = lastState == null || lastState.directionTraveling != this.directionTraveling ? 0.0 : lastState.timeSinceDirectionChange + 1.0;
        this.timeSinceStop = this.velocity == 0.0 || lastState == null ? 0.0 : lastState.timeSinceStop + 1.0;
        this.energy = e.getEnergy();
    }

    public RRobotState(RPoint location, double absoluteBearing, double velocity, double lateralVelocity, double advancingVelocity, double deltaV, double heading, double deltaH, double distance, double distanceFromWall, double timeSinceVelocityChange, double timeSinceDirectionChange, double timeSinceStop, double energy, int directionTraveling) {
        this.location = location.getCopy();
        this.absoluteBearing = absoluteBearing;
        this.velocity = velocity;
        this.lateralVelocity = lateralVelocity;
        this.advancingVelocity = advancingVelocity;
        this.deltaV = deltaV;
        this.heading = heading;
        this.deltaH = deltaH;
        this.distance = distance;
        this.distanceFromWall = distanceFromWall;
        this.timeSinceVelocityChange = timeSinceVelocityChange;
        this.timeSinceDirectionChange = timeSinceDirectionChange;
        this.timeSinceStop = timeSinceStop;
        this.energy = energy;
        this.directionTraveling = directionTraveling;
        this.accelerating = deltaV > 0.0;
        this.breaking = deltaV < 0.0;
    }

    public RRobotState(RRobotState state) {
        this(state.location, state.absoluteBearing, state.velocity, state.lateralVelocity, state.advancingVelocity, state.deltaV, state.heading, state.deltaH, state.distance, state.distanceFromWall, state.timeSinceVelocityChange, state.timeSinceDirectionChange, state.timeSinceStop, state.energy, state.directionTraveling);
    }

    public RRobotState getCopy() {
        return new RRobotState(this);
    }
}

