/*
 * Decompiled with CFR 0.152.
 */
package benhorner;

import benhorner.utility.projection.LinearProjector;
import benhorner.utility.projection.Projection;
import benhorner.utility.turning.Item;
import benhorner.utility.turning.TurnCoordinator;
import benhorner.utility.turning.TurnSet;
import benhorner.utility.units.Bearing;
import benhorner.utility.units.Distance;
import benhorner.utility.units.Heading;
import benhorner.utility.units.Location;
import benhorner.utility.units.RelativeLocation;
import benhorner.utility.units.Speed;
import benhorner.utility.units.Time;
import benhorner.utility.units.Velocity;
import java.awt.Color;
import java.awt.Graphics2D;
import robocode.AdvancedRobot;
import robocode.HitRobotEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;

public class PureAggression
extends AdvancedRobot {
    Double turn_direction;
    Time scan_loc_time;
    Time scan_heading_time;
    Time scan_velocity_time;
    Time last_gun_heading_time;
    Time last_energy_time;
    Location scan_loc;
    Heading scan_heading;
    Velocity scan_velocity;
    Heading last_gun_heading;
    double last_energy;
    boolean last_alive;
    Projection scan_proj;
    Projection ram_proj;
    Projection target_proj;
    Location my_loc;
    Heading my_heading;
    Velocity my_velocity;
    Heading my_gun_heading;
    Heading my_radar_heading;
    double my_energy;

    public void run() {
        this.setBodyColor(Color.black);
        this.setGunColor(Color.blue);
        this.setRadarColor(Color.black);
        LinearProjector projector = new LinearProjector(17.9, this.getBattleFieldWidth() - 17.9, 17.9, this.getBattleFieldHeight() - 17.9);
        TurnCoordinator turner = new TurnCoordinator(Item.RADAR, Item.ROBOT, Item.GUN);
        while (true) {
            Time time = new Time(this.getTime());
            if (this.initialTurnAndScanComplete()) {
                if (this.scan_loc_time.toDouble() < time.toDouble() && this.getOthers() > 0) {
                    System.out.println("********");
                    System.out.println("* SLIP *");
                    System.out.println("********");
                }
                this.updateSelf();
                this.setStop();
                this.scan_proj = projector.project(this.scan_loc, this.scan_velocity, time.subtract(this.scan_loc_time).add(1.0));
                this.ram_proj = projector.project(this.scan_loc, this.scan_velocity, this.my_loc, this.my_velocity);
                this.target_proj = projector.project(this.scan_loc, this.scan_velocity, this.my_loc, new Velocity(this.my_heading, new Speed(11.0)));
                Heading ram_heading = this.my_loc.getHeadingTo(this.ram_proj.getLocation());
                Bearing goal_robot_turn = this.my_heading.getBearingTo(ram_heading);
                Heading gun_heading = this.my_loc.getHeadingTo(this.target_proj.getLocation());
                Bearing goal_gun_turn = this.my_gun_heading.getBearingTo(gun_heading);
                Heading scan_heading = this.my_loc.getHeadingTo(this.scan_proj.getLocation());
                Bearing goal_radar_turn = this.my_radar_heading.getBearingTo(scan_heading);
                TurnSet turns = turner.coordinate(this.my_velocity, goal_robot_turn, goal_gun_turn, goal_radar_turn);
                this.setTurnRight(turns.getBotTurn().toDegrees());
                this.setTurnGunRight(turns.getGunTurn().toDegrees());
                double radar_turn = turns.getRadarTurn().toDegrees();
                radar_turn = radar_turn == 0.0 ? 0.1 : radar_turn;
                this.setTurnRadarRight(radar_turn);
                if (this.last_alive) {
                    if (this.target_proj.getDuration().toDouble() <= 12.0 && this.getGunHeat() == 0.0) {
                        if (this.last_energy > 4.0 || this.my_energy < 16.0) {
                            this.setFire((this.last_energy - 3.0 + 2.0) / 6.0);
                        } else {
                            this.setFire(this.last_energy / 4.0 - 0.1);
                        }
                    } else {
                        this.setFire(2.0);
                    }
                    this.setAhead(turns.getMoveDirection() * Double.POSITIVE_INFINITY);
                }
            }
            this.execute();
        }
    }

    protected void printState() {
        System.out.println("me:");
        System.out.println("\t location:      " + this.my_loc);
        System.out.println("\t heading:       " + this.my_heading);
        System.out.println("\t velocity:      " + this.my_velocity);
        System.out.println("\t gun heading:   " + this.my_gun_heading);
        System.out.println("\t radar heading: " + this.my_radar_heading);
        System.out.println("\t energy:        " + this.my_energy);
        System.out.println("enemy:");
        System.out.println("\tlast_loc_time:         " + this.scan_loc_time);
        System.out.println("\tlast_heading_time:     " + this.scan_heading_time);
        System.out.println("\tlast_velocity_time:    " + this.scan_velocity_time);
        System.out.println("\tlast_gun_heading_time: " + this.last_gun_heading_time);
        System.out.println("\tlast_energy_time:      " + this.last_energy_time);
        System.out.println("\tlast location:      " + this.scan_loc);
        System.out.println("\tlast heading:       " + this.scan_heading);
        System.out.println("\tlast velocity:      " + this.scan_velocity);
        System.out.println("\tlast gun heading:   " + this.last_gun_heading);
        System.out.println("\tlast energy:        " + this.last_energy);
    }

    protected boolean initialTurnAndScanComplete() {
        if (this.turn_direction == null) {
            this.updateSelf();
            Location center_field = new Location(new Distance(this.getBattleFieldWidth() / 2.0), new Distance(this.getBattleFieldHeight() / 2.0));
            RelativeLocation to_center = new RelativeLocation(this.my_loc, center_field);
            this.turn_direction = Math.signum(this.my_heading.getBearingTo(to_center.getHeading()).toDegrees());
            this.turn_direction = this.turn_direction == 0.0 ? 1.0 : this.turn_direction;
        }
        if (this.scan_loc == null) {
            this.setTurnRight(this.turn_direction * 10.0);
            this.setTurnGunRight(this.turn_direction * 25.0);
            this.setTurnRadarRight(this.turn_direction * 40.0);
        }
        return this.scan_loc != null;
    }

    protected void updateSelf() {
        this.my_loc = new Location(new Distance(this.getX()), new Distance(this.getY()));
        this.my_heading = new Heading(this.getHeading());
        this.my_velocity = new Velocity(this.my_heading, new Speed(this.getVelocity()));
        this.my_gun_heading = new Heading(this.getGunHeading());
        this.my_radar_heading = new Heading(this.getRadarHeading());
        this.my_energy = this.getEnergy();
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.updateSelf();
        Time time = new Time(this.getTime());
        Heading direction_to_enemy = this.my_heading.add(new Bearing(e.getBearing()));
        this.scan_loc_time = time;
        this.scan_loc = this.my_loc.add(new RelativeLocation(direction_to_enemy, new Distance(e.getDistance())));
        this.scan_heading_time = time;
        this.scan_heading = new Heading(e.getHeading());
        this.scan_velocity_time = time;
        this.scan_velocity = new Velocity(this.scan_heading, new Speed(e.getVelocity()));
        this.last_energy_time = time;
        this.last_energy = e.getEnergy();
        this.last_alive = this.getOthers() > 0;
    }

    public void onHitRobot(HitRobotEvent e) {
        Time time;
        this.updateSelf();
        this.last_energy_time = time = new Time(this.getTime());
        this.last_energy = e.getEnergy();
        this.last_alive = this.getOthers() > 0;
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
        System.out.println("********");
        System.out.println("* SKIP *");
        System.out.println("********");
    }

    public void onPaint(Graphics2D g) {
        g.setColor(Color.GREEN);
        if (this.scan_loc != null) {
            int scan_x = (int)Math.round(this.scan_loc.getX().toDouble());
            int scan_y = (int)Math.round(this.scan_loc.getY().toDouble());
            g.fillOval(scan_x - 3, scan_y - 3, 6, 6);
            g.drawRect(scan_x - 18, scan_y - 18, 36, 36);
            if (this.scan_proj != null) {
                Location scan_loc = this.scan_proj.getLocation();
                int next_x = (int)Math.round(scan_loc.getX().toDouble());
                int next_y = (int)Math.round(scan_loc.getY().toDouble());
                g.fillOval(next_x - 2, next_y - 2, 4, 4);
                g.drawLine(scan_x, scan_y, next_x, next_y);
            }
        }
        if (this.my_loc != null) {
            int my_x = (int)Math.round(this.my_loc.getX().toDouble());
            int my_y = (int)Math.round(this.my_loc.getY().toDouble());
            g.setColor(Color.BLUE);
            g.drawRect(my_x - 18, my_y - 18, 36, 36);
            g.setColor(Color.YELLOW);
            if (this.target_proj != null) {
                Location target_loc = this.target_proj.getLocation();
                int target_x = (int)Math.round(target_loc.getX().toDouble());
                int target_y = (int)Math.round(target_loc.getY().toDouble());
                g.fillOval(target_x - 4, target_y - 4, 8, 8);
                g.drawLine(my_x, my_y, target_x, target_y);
            }
            g.setColor(Color.RED);
            if (this.ram_proj != null) {
                Location ram_loc = this.ram_proj.getLocation();
                int ram_x = (int)Math.round(ram_loc.getX().toDouble());
                int ram_y = (int)Math.round(ram_loc.getY().toDouble());
                g.fillOval(ram_x - 3, ram_y - 3, 6, 6);
                g.drawLine(my_x, my_y, ram_x, ram_y);
            }
        }
    }
}

