/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import java.awt.Color;
import java.awt.Graphics2D;
import pa3k.CircleMoving;
import pa3k.Coloring;
import pa3k.GlobalTracking;
import pa3k.Gun;
import pa3k.Log;
import pa3k.MonteCarlo;
import pa3k.MonteCarloAiming;
import pa3k.MonteCarloGun;
import pa3k.Opponent;
import pa3k.OpponentCreator;
import pa3k.Position;
import pa3k.RandomChangeMoving;
import pa3k.RobotModule;
import pa3k.SelfTracking;
import pa3k.Tracking;
import pa3k.TronAiming;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.Robot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;

public class Manta
extends AdvancedRobot
implements OpponentCreator {
    protected RobotModule[] modules;
    protected Tracking tracking;
    protected Gun gun;
    protected CircleMoving moving;
    protected MonteCarlo mc;

    public Manta() {
        SelfTracking st = new SelfTracking(this, 4);
        this.tracking = new GlobalTracking(this, st, this);
        this.mc = new MonteCarlo(this, this.tracking, st);
        this.gun = new MonteCarloGun(this, this.tracking, this.mc);
        this.moving = new RandomChangeMoving(this, this.tracking, false);
        this.tracking.setMoving(this.moving);
        this.modules = new RobotModule[6];
        this.modules[0] = new Coloring(this, new Color(255, 120, 120), new Color(255, 255, 120), Color.BLACK, new Color(200, 200, 40), Color.WHITE);
        this.modules[1] = this.moving;
        this.modules[2] = st;
        this.modules[3] = this.tracking;
        this.modules[4] = this.mc;
        this.modules[5] = this.gun;
    }

    public void onBulletMissed(BulletMissedEvent e) {
        this.tracking.bulletMissed(e);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.tracking.opponentScanned(e);
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.tracking.hitByBullet(e);
    }

    public void onBuletHitBullet(BulletHitBulletEvent e) {
        this.tracking.bulletHitBullet(e);
    }

    public void onBulletHit(BulletHitEvent e) {
        this.tracking.bulletHit(e);
    }

    public void onHitRobot(HitRobotEvent e) {
        this.moving.onHitRobot(e);
        this.gun.hitRobot(this.tracking.getByName(e.getName()));
        this.tracking.onHitRobot(e);
    }

    public void onRobotDeath(RobotDeathEvent e) {
        this.tracking.robotDeath(e);
        this.gun.robotDeath(e);
    }

    public void onPaint(Graphics2D g) {
        RobotModule.onPaint(this.modules, g);
        Log.onPaint(g);
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
        Log.log(1, "***********************************");
        Log.log(1, "Turn " + e.getTime() + " skipped!");
    }

    public void onDeath(DeathEvent e) {
        this.mc.dumpData();
    }

    public void run() {
        Position.setBattleField((Robot)this);
        RobotModule.init(this.modules);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        while (true) {
            RobotModule.turn(this.modules);
            this.execute();
        }
    }

    @Override
    public Opponent createOpponent(String name, AdvancedRobot robot) {
        return new Opponent(name, robot, new MonteCarloAiming(robot, name, true, this.mc), new TronAiming(robot, name, false));
    }
}

