/*
 * Decompiled with CFR 0.152.
 */
package gre.svman4.morfeas;

import gre.svman4.WaveBullet;
import gre.svman4.morfeas.EnemyWaveBullet;
import gre.svman4.morfeas.MineWaveBullet;
import gre.svman4.useful.Buffer;
import gre.svman4.useful.RobotState;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import robocode.AdvancedRobot;
import robocode.RobocodeFileOutputStream;
import robocode.util.Utils;

public class EnemyState
extends RobotState
implements Serializable {
    private static final int MAX_DISTANCE_WAVE_SURFING_CHECK = 1200;
    private static final int MAX_DISTANCE_GUN_TARGETING = 900;
    public static final int GUN_WAVE_BINS = 61;
    public static final int GUN_WAVE_DISTANCE_INDEXES = 10;
    public static final int GUN_WAVE_VELOCITY_INDEXES = 10;
    public static final int GUN_WAVE_MOVE_TIME_INDEXES = 5;
    public static final int GUN_WAVE_PLACE_ON_BATTLEFIELD_INDEXES = 3;
    public static final int GUN_ROLLING_AVERAGE_MAX_READS = 25;
    private static float[][][][][] gunProfile;
    private static final long serialVersionUID = 5185811350477189479L;
    public static final int MOVE_WAVE_BINS = 61;
    public static final int MOVE_WAVE_DISTANCE_INDEXES = 10;
    public static final int MOVE_WAVE_VELOCITY_INDEXES = 10;
    public static final int MOVE_WAVE_PLACE_ON_INDEXES = 3;
    private static float[][][][] enemyShootingProfile;
    private static final int MOVE_ROLLING_AVERAGE_MAX_READS = 25;
    public int[] hits;
    public boolean isAlive = true;
    public double lastVelocity;
    public int lateralDirection;
    public Buffer surfAbsBearing = new Buffer(2);
    public Buffer surfDirections = new Buffer(2);
    public int moveTime = 0;
    private int RollingAverageReadsCounter = 0;
    private int RollingAverageGunReadsCounter = 0;

    public static double rollingAvg(double value, double newEntry, double n, double weighting) {
        return (value * n + newEntry * weighting) / (n + weighting);
    }

    public EnemyState(String name, int numberOfGuns) {
        this.name = name;
        this.hits = new int[numberOfGuns];
        gunProfile = new float[3][5][10][10][61];
        enemyShootingProfile = new float[3][10][10][61];
    }

    public EnemyState(AdvancedRobot mineRobot, String enemyName) {
        this.name = enemyName;
        this.ReadProfilesFromFile(mineRobot);
    }

    public float[] getEnemyGunCurrentStatus(double mineVelocity, double distance, int relativePlace) {
        int indexVelocity = this.getVelocityIndex(10, mineVelocity);
        int indexDistance = (int)Math.abs(distance) / 120;
        int indexRelativePlace = relativePlace;
        return this.getEnemyGunCurrentStatus(indexRelativePlace, indexVelocity, indexDistance);
    }

    private float[] getEnemyGunCurrentStatus(int indexRelativePlace, int indexVelocity, int indexDistance) {
        return enemyShootingProfile[indexRelativePlace][indexDistance][indexVelocity];
    }

    public float[] getGunCurrentStatus(double distance, double velocity, int placeOnBattleField, int moveTimeOnAttackTime) {
        int distanceIndex = (int)(distance / 90.0);
        distanceIndex = Math.min(distanceIndex, 9);
        int velocityIndex = this.getVelocityIndex(10, velocity);
        int placeIndex = Math.min(placeOnBattleField, 2);
        int moveTimeIndex = Math.min(moveTimeOnAttackTime / 5, 4);
        float[] answer = gunProfile[placeIndex][moveTimeIndex][distanceIndex][velocityIndex];
        return answer;
    }

    public void logGunHit(MineWaveBullet wave, double offsetAngle) {
        this.logGunHit(wave.distanceToEnemyPosition, wave.enemyVelocity, offsetAngle, wave.relativePosition, wave.bulletVelocity, wave.lateralDirection, wave.moveTime);
    }

    public void logGunHit(double distance, double velocity, double offsetAngle, int placeOnBattle, double attackVelocity, int enemyLateralDirectionOnAttackTime, int moveTimeOnAttack) {
        int distanceIndex = (int)(distance / 90.0);
        if (distanceIndex >= 10) {
            distanceIndex = 9;
        }
        int indexAngle = this.getFactorIndex(offsetAngle, attackVelocity, enemyLateralDirectionOnAttackTime);
        int placeOnBattleIndex = Math.min(placeOnBattle, 2);
        int velocityIndex = this.getVelocityIndex(10, velocity);
        int moveTimeIndex = Math.min(moveTimeOnAttack / 10, 4);
        int rollingAverageCounterValue = Math.min(this.RollingAverageGunReadsCounter++, 25);
        for (int placeLoop = 0; placeLoop < 3; ++placeLoop) {
            double placeValue = Math.pow(placeOnBattleIndex - placeLoop, 2.0);
            for (int moveTimeLoop = 0; moveTimeLoop < 5; ++moveTimeLoop) {
                double moveTimeValue = Math.pow(moveTimeIndex - moveTimeLoop, 2.0);
                for (int distanceLoop = 0; distanceLoop < 10; ++distanceLoop) {
                    double distanceValue = Math.pow(distanceIndex - distanceLoop, 2.0);
                    for (int velocityLoop = 0; velocityLoop < 10; ++velocityLoop) {
                        double velocityValue = Math.pow(velocityIndex - velocityLoop, 2.0);
                        for (int binsLoop = 0; binsLoop < 61; ++binsLoop) {
                            float newValue;
                            double sum = distanceValue;
                            sum += velocityValue;
                            sum += placeValue;
                            sum += moveTimeValue;
                            EnemyState.gunProfile[placeLoop][moveTimeLoop][distanceLoop][velocityLoop][binsLoop] = newValue = (float)EnemyState.rollingAvg(gunProfile[placeLoop][moveTimeLoop][distanceLoop][velocityLoop][binsLoop], 1.0 / ((sum += Math.pow(indexAngle - binsLoop, 2.0)) + 1.0), rollingAverageCounterValue, 1.0);
                        }
                    }
                }
            }
        }
    }

    public int getFactorIndex(double offsetAngle, double bulletVelocity, double lateralDirection) {
        double factor = Utils.normalRelativeAngle((double)offsetAngle) / this.getMaxEscapeAngle(bulletVelocity) * lateralDirection;
        return (int)WaveBullet.limit(0.0, factor * 30.0 + 30.0, 60.0);
    }

    public void logEnemyHit(double mineRobotVelocity, double distanceToEnemyPosition, double offsetAngle, int relativePlaceOnAttackTime, double bulletVelocity, double lateralDirectionOnAttackTime) {
        int indexVelocity = this.getVelocityIndex(10, mineRobotVelocity);
        int indexDistance = (int)Math.abs(distanceToEnemyPosition) / 120;
        int indexPlace = Math.min(relativePlaceOnAttackTime / 10, 2);
        int indexAngle = this.getFactorIndex(offsetAngle, bulletVelocity, lateralDirectionOnAttackTime);
        int rollingAverageCounterValue = Math.min(this.RollingAverageReadsCounter++, 25);
        for (int placeLoop = 0; placeLoop < 3; ++placeLoop) {
            double placeValue = Math.pow(indexPlace - placeLoop, 2.0);
            for (int distanceLoop = 0; distanceLoop < 10; ++distanceLoop) {
                double distanceValue = Math.pow(indexDistance - distanceLoop, 2.0);
                for (int velocityLoop = 0; velocityLoop < 10; ++velocityLoop) {
                    double velocityValue = Math.pow(indexVelocity - velocityLoop, 2.0);
                    for (int binsLoop = 0; binsLoop < 61; ++binsLoop) {
                        double sum = Math.pow(indexAngle - binsLoop, 2.0);
                        sum += velocityValue;
                        sum += distanceValue;
                        double newValue = 1.0 / ((sum += placeValue) + 1.0);
                        EnemyState.enemyShootingProfile[placeLoop][distanceLoop][velocityLoop][binsLoop] = (float)EnemyState.rollingAvg(enemyShootingProfile[placeLoop][distanceLoop][velocityLoop][binsLoop], newValue, rollingAverageCounterValue, 1.0);
                    }
                }
            }
        }
    }

    public void onPaint(Graphics2D g) {
        if (!this.isAlive) {
            return;
        }
        g.draw(new Rectangle2D.Double(this.x - 18.0, this.y - 18.0, 36.0, 36.0));
    }

    private int getVelocityIndex(int INDEXES, double velocity) {
        double temp = ((double)INDEXES - 1.0) / 8.0 * Math.abs(velocity);
        return (int)temp;
    }

    private void ReadProfilesFromFile(AdvancedRobot mineRobot) {
        boolean itsAllOk = true;
        try {
            FileInputStream fileIn = new FileInputStream(mineRobot.getDataFile(this.name + ".data"));
            GZIPInputStream input = new GZIPInputStream(fileIn);
            ObjectInputStream objectIn = new ObjectInputStream(input);
            objectIn.close();
            input.close();
            fileIn.close();
        }
        catch (FileNotFoundException ex) {
            itsAllOk = false;
        }
        catch (IOException exp) {
            itsAllOk = false;
        }
        if (!itsAllOk) {
            // empty if block
        }
    }

    public void saveProfilesToFile(AdvancedRobot robot) {
        try {
            RobocodeFileOutputStream fileOut = new RobocodeFileOutputStream(robot.getDataFile(this.name + ".data"));
            GZIPOutputStream zipOut = new GZIPOutputStream((OutputStream)fileOut){
                {
                    this.def.setLevel(9);
                }
            };
            ObjectOutputStream objectOutput = new ObjectOutputStream(zipOut);
            objectOutput.writeObject(gunProfile);
            objectOutput.writeObject(enemyShootingProfile);
            objectOutput.flush();
            zipOut.flush();
            fileOut.flush();
            objectOutput.close();
            zipOut.close();
            fileOut.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void logEnemyHit(EnemyWaveBullet enemyWave, double offsetAngle) {
        this.logEnemyHit(Math.abs(enemyWave.mineRobotVelocity), enemyWave.distanceToEnemyPosition, offsetAngle, enemyWave.relativePosition, enemyWave.bulletVelocity, enemyWave.lateralDirection);
    }
}

