/*
 * Decompiled with CFR 0.152.
 */
package nic;

import java.awt.Color;
import java.util.Hashtable;
import nic.BulletDodgeRecogniser;
import nic.Enemy;
import nic.FireControlManager;
import nic.HelperFunctions;
import nic.MovementManager;
import nic.ScannerManager;
import nic.TargetingManager;
import nic.VelocityController;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

public class Nicator
extends AdvancedRobot {
    public Hashtable targets;
    Enemy target;
    final double PI = Math.PI;
    int direction = 1;
    boolean robotdeathturn = false;
    boolean loadstats = false;
    public HelperFunctions hf;
    public static FireControlManager fm;
    public MovementManager mm;
    public ScannerManager sm;
    public TargetingManager tm;
    public static BulletDodgeRecogniser br;
    public VelocityController vc;

    public void run() {
        this.hf = new HelperFunctions(this);
        if (br == null) {
            br = new BulletDodgeRecogniser(this);
        } else {
            br.init(this);
        }
        if (fm == null) {
            fm = new FireControlManager(this);
        } else {
            fm.init(this);
        }
        this.mm = new MovementManager(this);
        this.sm = new ScannerManager(this);
        this.tm = new TargetingManager(this);
        this.vc = new VelocityController(this);
        this.targets = new Hashtable();
        this.target = new Enemy(this);
        this.target.distance = 100000.0;
        this.target.name = "";
        this.setColors(Color.white, Color.white, Color.black);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        while (true) {
            this.tm.pickTarget();
            if (this.getOthers() == 1) {
                br.add();
            }
            this.mm.move();
            this.vc.add();
            this.sm.moveScanner();
            if (this.loadstats) {
                fm.loadBulletStats();
                this.loadstats = false;
            }
            fm.moveGun();
            fm.fire();
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        Enemy en;
        if (this.targets.containsKey(e.getName())) {
            en = (Enemy)this.targets.get(e.getName());
        } else {
            en = new Enemy(this);
            this.targets.put(e.getName(), en);
            fm.setEnemies(e.getName());
        }
        if (Nicator.fm.onevonegame && Nicator.fm.onlyenemy == "" && this.getRoundNum() == 0) {
            Nicator.fm.onlyenemy = e.getName();
            this.loadstats = true;
        }
        double absbearing_rad = (this.getHeadingRadians() + e.getBearingRadians()) % (Math.PI * 2);
        if (en.energy - e.getEnergy() >= 0.1 && en.energy - e.getEnergy() <= 3.0) {
            en.fired = true;
        }
        en.name = e.getName();
        double h = this.hf.normaliseBearing(e.getHeadingRadians() - en.heading);
        en.changehead = h /= (double)(this.getTime() - en.ctime);
        en.x = this.getX() + Math.sin(absbearing_rad) * e.getDistance();
        en.y = this.getY() + Math.cos(absbearing_rad) * e.getDistance();
        en.bearing = e.getBearingRadians();
        en.heading = e.getHeadingRadians();
        if (this.getOthers() == 1) {
            en.absavgspeed = (en.absavgspeed * en.noabsavgspeed + Math.abs(e.getVelocity())) / (en.noabsavgspeed + 1.0);
            en.noabsavgspeed += 1.0;
        }
        en.ctime = this.getTime();
        en.speed = e.getVelocity();
        en.distance = e.getDistance();
        if (Math.abs(e.getVelocity()) > en.maxvelocity && this.getOthers() == 1) {
            en.maxvelocity = Math.abs(e.getVelocity());
        }
        en.energy = e.getEnergy();
        if (this.getOthers() == 1) {
            en.apr.add(e.getVelocity(), this.getTime());
        }
        en.live = true;
    }

    public void onRobotDeath(RobotDeathEvent e) {
        Enemy en = (Enemy)this.targets.get(e.getName());
        en.live = false;
        this.robotdeathturn = true;
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
        System.out.println("Skipped Turn");
    }

    public void onBulletHit(BulletHitEvent e) {
        fm.bullethit(e);
        fm.remove(e.getBullet());
    }

    public void onBulletMissed(BulletMissedEvent e) {
        fm.remove(e.getBullet());
    }

    public void onDeath(DeathEvent e) {
        Nicator.fm.bsm.printshotinfo();
        fm.saveBulletStats();
    }

    public void onWin(WinEvent e) {
        Nicator.fm.bsm.printshotinfo();
        fm.saveBulletStats();
    }
}

