/*
 * Decompiled with CFR 0.152.
 */
package rdt.Wraith.Targeting;

import java.util.ArrayList;
import java.util.HashMap;
import rdt.Wraith.IBulletHitEventHandler;
import rdt.Wraith.IHitByBulletEventHandler;
import rdt.Wraith.IRobot;
import rdt.Wraith.IRobotDeathEventHandler;
import rdt.Wraith.IRoundEndedEventHandler;
import rdt.Wraith.IRoundStartedEventHandler;
import rdt.Wraith.IScannedRobotEventHandler;
import rdt.Wraith.RobotSnapshots.RobotSnapshot;
import rdt.Wraith.RobotSnapshots.RobotSnapshotUtils;
import rdt.Wraith.RobotSnapshots.RobotSnapshots;
import rdt.Wraith.Stats.IStats;
import rdt.Wraith.Targeting.ITargeting;
import rdt.Wraith.Targeting.Target;
import rdt.Wraith.Utils.MathUtils;
import rdt.Wraith.Utils.RuleUtils;
import rdt.Wraith.Waves.IWaveManager;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.RobotDeathEvent;
import robocode.RoundEndedEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Targeting
implements ITargeting,
IScannedRobotEventHandler,
IRobotDeathEventHandler,
IRoundStartedEventHandler,
IRoundEndedEventHandler,
IBulletHitEventHandler,
IHitByBulletEventHandler {
    private IStats _stats;
    private IRobot _robot;
    private IWaveManager _friendlyWaveManager;
    private IWaveManager _enemyWaveManager;
    private Target _currentTarget;
    private HashMap<String, Target> _targetsLookup = new HashMap();
    private ArrayList<Target> _targets = new ArrayList();

    public Targeting(IRobot robot, IStats stats) {
        this._robot = robot;
        this._stats = stats;
        this._robot.RegisterForEventHandling(this);
        this._robot.RegisterForEventHandling(this);
        this._robot.RegisterForEventHandling(this);
        this._robot.RegisterForEventHandling(this);
        this._robot.RegisterForEventHandling(this);
        this._robot.RegisterForEventHandling(this);
    }

    @Override
    public void SetWaveManagers(IWaveManager friendlyWaveManager, IWaveManager enemyWaveManager) {
        this._friendlyWaveManager = friendlyWaveManager;
        this._enemyWaveManager = enemyWaveManager;
    }

    @Override
    public ArrayList<Target> GetTargets() {
        return this._targets;
    }

    @Override
    public boolean HasValidTarget() {
        if (this._currentTarget == null) {
            return false;
        }
        return this._currentTarget.Valid;
    }

    @Override
    public void SetCurrentTarget(Target target) {
        this._currentTarget = target;
    }

    @Override
    public Target GetCurrentTarget() {
        return this._currentTarget;
    }

    public Target GetTargetByName(String name) {
        Target target = this._targetsLookup.get(name);
        if (target == null) {
            target = new Target(name, this._robot, this._friendlyWaveManager, this._enemyWaveManager, this._stats);
            this._targetsLookup.put(name, target);
            this._targets.add(target);
        }
        return target;
    }

    @Override
    public void OnScannedRobotEvent(ScannedRobotEvent eventData) {
        Target target = this.GetTargetByName(eventData.getName());
        RobotSnapshots snapshots = target.RobotSnapshots;
        RobotSnapshot snapshot = snapshots.Write(this._robot.getTime());
        double absoluteAngle = this._robot.getHeadingRadians() + eventData.getBearingRadians();
        double x = this._robot.getX() + eventData.getDistance() * MathUtils.FastSin(absoluteAngle);
        double y = this._robot.getY() + eventData.getDistance() * MathUtils.FastCos(absoluteAngle);
        this.UpdateTarget(target, snapshot, x, y, eventData.getHeadingRadians(), eventData.getVelocity(), eventData.getEnergy());
        this.PredictTargetFuture(target);
        this.CheckForTargetFiring(target);
        if (target.NextTickCanFireAgain < this._robot.getTime()) {
            target.NextTickCanFireAgain = this._robot.getTime();
        }
    }

    @Override
    public void OnHitByBulletEvent(HitByBulletEvent event) {
        Target target = this.GetTargetByName(event.getName());
        if (target == null || !target.Valid || !target.Alive) {
            return;
        }
        target.LastTickTargetHitUs = this._robot.getTime();
        target.LastEnergyGainedFromHittingUs = event.getPower() * 3.0;
    }

    @Override
    public void OnBulletHitEvent(BulletHitEvent event) {
        Target target = this.GetTargetByName(event.getName());
        if (target == null || !target.Valid || !target.Alive) {
            return;
        }
        double firepower = event.getBullet().getPower();
        double energyLost = firepower * 4.0;
        if (firepower > 1.0) {
            energyLost += 2.0 * (firepower - 1.0);
        }
        target.LastTickWeHitTarget = this._robot.getTime();
        target.LastEnergyLostFromUsHittingTarget = energyLost;
    }

    @Override
    public void OnRobotDeathEvent(RobotDeathEvent eventData) {
        Target target = this.GetTargetByName(eventData.getName());
        target.Invalidate();
        if (target == this._currentTarget) {
            this._currentTarget = null;
        }
    }

    @Override
    public void OnRoundStartedEvent() {
        this._currentTarget = null;
        for (int targetIndex = 0; targetIndex < this._targets.size(); ++targetIndex) {
            this._targets.get(targetIndex).OnRoundStart();
        }
    }

    @Override
    public void OnRoundEndedEvent(RoundEndedEvent eventData) {
        this._currentTarget = null;
        for (int targetIndex = 0; targetIndex < this._targets.size(); ++targetIndex) {
            this._targets.get(targetIndex).Invalidate();
        }
    }

    private void UpdateTarget(Target target, RobotSnapshot snapshot, double x, double y, double absHeading, double velocity, double energy) {
        long thisTick;
        long scanTick = thisTick = this._robot.getTime();
        int roundNum = this._robot.getRoundNum();
        long lastUpdatedTick = -1L;
        boolean targetWasValid = target.Valid;
        if (targetWasValid) {
            lastUpdatedTick = target.LastUpdatedTick;
        }
        target.Valid = true;
        target.Alive = true;
        target.Disabled = Utils.isNear((double)energy, (double)0.0);
        target.LastUpdatedTick = thisTick;
        target.MaxSafePredictedTick = thisTick + 99L - 1L;
        if (lastUpdatedTick != thisTick - 1L) {
            for (long tick = lastUpdatedTick + 1L; tick <= thisTick - 1L; ++tick) {
                RobotSnapshot fillInData = target.RobotSnapshots.Write(tick);
                RobotSnapshotUtils.FillInSnapshot(fillInData, roundNum, tick, x, y, velocity, absHeading, this._robot.getX(), this._robot.getY(), energy, target.RobotSnapshots);
            }
        }
        RobotSnapshotUtils.FillInSnapshot(snapshot, roundNum, scanTick, x, y, velocity, absHeading, this._robot.getX(), this._robot.getY(), energy, target.RobotSnapshots);
        target.EscapeEnvelope.Update((long)Math.ceil(target.RobotSnapshots.Read((long)thisTick).DistanceToItsTarget / RuleUtils.GetBulletVelocity(3.0)));
        this.UpdateTargetFrequencyValues(target);
    }

    private void PredictTargetFuture(Target target) {
        long thisTick;
        long lastScannedTick = thisTick = this._robot.getTime();
        long lastPredictionTick = thisTick + 99L;
        int round = this._robot.getRoundNum();
        RobotSnapshot mostRecentScannedSnapshot = target.RobotSnapshots.Read(lastScannedTick);
        double dX = MathUtils.FastSin(mostRecentScannedSnapshot.AbsoluteHeading) * mostRecentScannedSnapshot.VelocityAlongHeading;
        double dY = MathUtils.FastCos(mostRecentScannedSnapshot.AbsoluteHeading) * mostRecentScannedSnapshot.VelocityAlongHeading;
        double x = mostRecentScannedSnapshot.LocationX;
        double y = mostRecentScannedSnapshot.LocationY;
        for (long predictionTick = thisTick + 1L; predictionTick < lastPredictionTick; ++predictionTick) {
            RobotSnapshot futureSnapshot = target.RobotSnapshots.Write(predictionTick);
            long safePredictedTargetTick = this._robot.GetSafePredictedTick(predictionTick);
            RobotSnapshot targetAtFutureTick = this._robot.ReadRobotSnapshot(safePredictedTargetTick);
            RobotSnapshotUtils.FillInSnapshot(futureSnapshot, round, predictionTick, x += dX, y += dY, mostRecentScannedSnapshot.VelocityAlongHeading, mostRecentScannedSnapshot.AbsoluteHeading, targetAtFutureTick.LocationX, targetAtFutureTick.LocationY, mostRecentScannedSnapshot.Energy, target.RobotSnapshots);
        }
    }

    private void CheckForTargetFiring(Target target) {
        double bulletFirepower;
        double velocityChange;
        long thisTick = this._robot.getTime();
        if (target.NextTickCanFireAgain > thisTick) {
            return;
        }
        long lastestScannedTick = thisTick;
        long previousScannedTick = lastestScannedTick - 1L;
        RobotSnapshot latestScannedSnapshot = target.RobotSnapshots.Read(lastestScannedTick);
        RobotSnapshot previousScannedSnapshot = target.RobotSnapshots.Read(previousScannedTick);
        boolean hitUs = false;
        if (!hitUs && Utils.isNear((double)latestScannedSnapshot.VelocityAlongHeading, (double)0.0) && (velocityChange = Math.abs(previousScannedSnapshot.VelocityAlongHeading)) > 2.0) {
            return;
        }
        double energyChange = latestScannedSnapshot.Energy - previousScannedSnapshot.Energy;
        if (target.LastTickTargetHitUs == thisTick) {
            energyChange -= target.LastEnergyGainedFromHittingUs;
        }
        if (target.LastTickWeHitTarget == thisTick) {
            energyChange += target.LastEnergyLostFromUsHittingTarget;
        }
        if (Utils.isNear((double)(bulletFirepower = Math.abs(energyChange)), (double)0.0)) {
            return;
        }
        if ((bulletFirepower < 0.0 || bulletFirepower > 3.0) && !Utils.isNear((double)bulletFirepower, (double)3.0)) {
            System.out.println("Detected firing energy drop but it is out of range: " + bulletFirepower);
            return;
        }
        target.LastTickFired = previousScannedSnapshot.Tick;
        target.LastFiredBulletFirepower = bulletFirepower;
        double gunHeatGenerated = 1.0 + bulletFirepower / 5.0;
        long ticksToCool = (int)Math.ceil(gunHeatGenerated / 0.1);
        target.NextTickCanFireAgain = target.LastTickFired + ticksToCool;
    }

    private void UpdateTargetFrequencyValues(Target target) {
        RobotSnapshot latestSnapshot = target.RobotSnapshots.Read(this._robot.getTime());
        target.DirectionChangeFrequency2.OnTick(latestSnapshot.TicksSinceDirectionChange == 0L);
        target.DirectionChangeFrequency3.OnTick(latestSnapshot.TicksSinceDirectionChange == 0L);
        target.DirectionChangeFrequency5.OnTick(latestSnapshot.TicksSinceDirectionChange == 0L);
        target.DirectionChangeFrequency9.OnTick(latestSnapshot.TicksSinceDirectionChange == 0L);
        latestSnapshot.DirectionChangeFrequency2 = target.DirectionChangeFrequency2.Mean;
        latestSnapshot.DirectionChangeFrequency3 = target.DirectionChangeFrequency3.Mean;
        latestSnapshot.DirectionChangeFrequency5 = target.DirectionChangeFrequency5.Mean;
        latestSnapshot.DirectionChangeFrequency9 = target.DirectionChangeFrequency9.Mean;
    }
}

