/*
 * Decompiled with CFR 0.152.
 */
package tcf;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import robocode.AdvancedRobot;
import robocode.DeathEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import tcf.MyRules;
import tcf.Opponent;
import tcf.PatternStore;
import tcf.Utils;
import tcf.Vec2d;

public class Repat3
extends AdvancedRobot {
    public static final int MAX_PATTERNS = 75000;
    public static final int HISTORY_LEN = 200;
    public static final boolean TC_DODGE = false;
    public static final boolean TC_SHOOT = false;
    public static final double TC_SHOOT_PW = 0.5;
    private static List<Vec2d> m_predictions = new ArrayList<Vec2d>();
    private static int m_nSkippedTurns;
    private double m_lastOppHeading;
    private double m_lastOppSpeed;
    private volatile int m_aliveCount = 0;
    private volatile long m_lastTargetTime = 0L;
    private Opponent m_target;
    private static PatternStore m_patterns;
    private static Hashtable<String, Opponent> m_opponents;

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setColors(Color.red, Color.red, Color.white);
        Enumeration<Opponent> e = m_opponents.elements();
        while (e.hasMoreElements()) {
            Opponent opp = e.nextElement();
            opp.startNewRound();
        }
        m_patterns.report();
        this.setTurnRadarRight(Double.POSITIVE_INFINITY);
        while (true) {
            this.execute();
            this.doRadar();
            this.doMovement();
            this.doUpdateOpponents();
        }
    }

    public Vec2d location() {
        return new Vec2d(this.getX(), this.getY());
    }

    private void doRadar() {
        if (this.getTime() > 8L) {
            Opponent oldest = null;
            Enumeration<Opponent> e = m_opponents.elements();
            while (e.hasMoreElements()) {
                Opponent opp = e.nextElement();
                if (!opp.m_isAlive || oldest != null && oldest.m_curScan.getTime() <= opp.m_curScan.getTime()) continue;
                oldest = opp;
            }
            if (oldest != null) {
                double oppHeading = oldest.m_curPos.minus(this.location()).getHeading();
                double radarHeading = this.getRadarHeading();
                double angle = Utils.normAngle180(oppHeading - radarHeading);
                angle += Math.signum(angle) * 22.5;
                if (oldest.m_curScan.getTime() + 8L < this.getTime()) {
                    angle = 360.0;
                }
                this.setTurnRadarRight(angle);
            } else {
                this.setTurnRadarRight(360.0);
            }
        }
    }

    public void doUpdateOpponents() {
        Enumeration<Opponent> e = m_opponents.elements();
        while (e.hasMoreElements()) {
            Opponent opp = e.nextElement();
            opp.doTickUpdate();
        }
        if (this.m_target != null) {
            this.m_target.doTargetUpdate();
            this.m_target.aimAndFireGun(m_predictions);
        }
    }

    private void doMovement() {
        double da;
        if (this.getDistanceRemaining() == 0.0) {
            int range = 301;
            if (this.m_target != null) {
                double time = this.m_target.m_curScan.getDistance() / MyRules.getBulletSpeed(2.0);
                time *= 1.0 + Math.random() * 0.2 - 0.1;
                double speed = Math.min(8.0, 4.0 + Math.random() * 8.0);
                this.setMaxVelocity(speed);
                if (Math.random() < 0.5) {
                    speed = -speed;
                }
                this.setAhead(speed * time);
            } else {
                double distToMove = Utils.rand(range) - range / 2;
                this.setMaxVelocity(8.0);
                this.setAhead(distToMove);
            }
        }
        double heading = this.getHeading();
        if (this.getDistanceRemaining() < 0.0) {
            heading += 180.0;
        }
        if ((da = this.calcDistAhead(this.location(), heading, 75.0)) < 50.0) {
            this.setAhead(-this.getDistanceRemaining());
        }
        if (this.m_target != null) {
            Vec2d delta = this.m_target.m_curPos.minus(this.location());
            double heading2 = delta.getHeading() + 90.0;
            double turn = Utils.normAngle180(heading2 - this.getHeading());
            double dist = this.m_target.m_curScan.getDistance();
            if (dist < 100.0) {
                double bearing = this.m_target.m_curScan.getBearing();
                if (Math.abs(bearing) < 90.0) {
                    this.setAhead(-50.0);
                    turn = Utils.normAngle180(turn - 45.0);
                } else {
                    this.setAhead(50.0);
                    turn = Utils.normAngle180(turn + 45.0);
                }
            } else {
                double da2 = this.calcDistAhead(this.location(), this.getHeading(), 75.0);
                double db = this.calcDistAhead(this.location(), this.getHeading() + 180.0, 75.0);
                double dr = this.getDistanceRemaining();
                if (da2 + db < 250.0) {
                    turn = (dr = -dr) < 0.0 ? Utils.normAngle180(turn - 15.0) : Utils.normAngle180(turn + 15.0);
                }
            }
            this.setTurnRight(turn);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        Opponent opp = m_opponents.get(e.getName());
        if (opp == null) {
            opp = new Opponent(this, m_patterns);
            opp.m_name = e.getName();
            System.out.printf("New opponent detected: %s\n", opp.m_name);
            m_opponents.put(opp.m_name, opp);
            ++this.m_aliveCount;
        } else if (!opp.m_isAlive) {
            opp.m_isAlive = true;
            opp.m_prevScan = null;
            opp.m_curScan = null;
            opp.m_prevPos = null;
            opp.m_curPos = null;
            ++this.m_aliveCount;
        }
        opp.onScannedRobot(e);
        if (this.m_target == null || this.m_target.m_name.equals(e.getName()) || this.m_target.m_curScan.getDistance() > e.getDistance()) {
            this.m_target = opp;
            this.m_lastTargetTime = this.getTime();
            this.onTargetUpdated();
        }
    }

    public void onTargetUpdated() {
        if (this.m_target != null) {
            // empty if block
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        Opponent opp = m_opponents.get(e.getName());
        if (opp != null) {
            opp.m_isAlive = false;
            --this.m_aliveCount;
            opp.onRobotDeath(e);
        }
        if (this.m_target == opp) {
            this.m_target = null;
        }
    }

    public void onDeath(DeathEvent evt) {
        Enumeration<Opponent> e = m_opponents.elements();
        while (e.hasMoreElements()) {
            Opponent opp = e.nextElement();
            opp.onDeath(evt);
        }
    }

    public void onPaint(Graphics2D g) {
        g.setColor(Color.yellow);
        for (Vec2d p : m_predictions) {
            g.fillOval((int)p.x - 2, (int)p.y - 2, 5, 5);
        }
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
        System.out.printf("Skipped turn [%d]!!!!!!\n", ++m_nSkippedTurns);
    }

    public void OnRobotDeath(RobotDeathEvent e) {
    }

    public double calcDistAhead(Vec2d v, double heading, double buffer) {
        double dx;
        double dy;
        double s = Math.sin(Math.toRadians(heading));
        double c = Math.cos(Math.toRadians(heading));
        double dist = Double.MAX_VALUE;
        if (c > 0.0) {
            dy = this.getBattleFieldHeight() - buffer - v.y;
            dist = Math.min(dist, dy / c);
        } else if (c < 0.0) {
            dy = buffer - v.y;
            dist = Math.min(dist, dy / c);
        }
        if (s > 0.0) {
            dx = this.getBattleFieldWidth() - buffer - v.x;
            dist = Math.min(dist, dx / s);
        } else if (s < 0.0) {
            dx = buffer - v.x;
            dist = Math.min(dist, dx / s);
        }
        return dist;
    }

    static {
        m_patterns = new PatternStore(75000);
        m_opponents = new Hashtable();
    }
}

