/*
 * Decompiled with CFR 0.152.
 */
package eem.frame.gameInfo;

import eem.frame.bot.InfoBot;
import eem.frame.bot.botsManager;
import eem.frame.bot.fighterBot;
import eem.frame.core.CoreBot;
import eem.frame.event.botListener;
import eem.frame.misc.logger;
import eem.frame.motion.basicMotion;
import eem.frame.wave.wave;
import eem.frame.wave.wavesManager;
import java.awt.Graphics2D;
import java.util.HashMap;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;

public class gameInfo
implements botListener {
    public CoreBot myBot;
    public basicMotion _motion;
    public botsManager _botsmanager;
    public wavesManager _wavesManager;
    public static HashMap<String, fighterBot> liveBots = new HashMap();
    public static HashMap<String, fighterBot> deadBots = new HashMap();

    public gameInfo(CoreBot coreBot) {
        logger.noise("----- Creating gameInfo -----");
        this.setMasterBot(coreBot);
        this._wavesManager = new wavesManager(this.myBot);
        this._botsmanager = new botsManager(this.myBot, this);
        this._botsmanager.addBotListener(this);
    }

    public void setMasterBot(CoreBot coreBot) {
        this.myBot = coreBot;
    }

    public CoreBot getMasterBot() {
        return this.myBot;
    }

    public fighterBot getFighterBot(String string) {
        fighterBot fighterBot2 = null;
        fighterBot2 = liveBots.get(string);
        if (fighterBot2 != null) {
            return fighterBot2;
        }
        fighterBot2 = deadBots.get(string);
        return fighterBot2;
    }

    public void initBattle(CoreBot coreBot) {
        this.setMasterBot(coreBot);
    }

    public void initTic() {
        long l = this.myBot.getTime();
        this._botsmanager.initTic(l);
        this._wavesManager.initTic(l);
        for (fighterBot fighterBot2 : liveBots.values()) {
            fighterBot2.initTic();
        }
    }

    public long getRoundNum() {
        return this.myBot.getRoundNum();
    }

    public long getTime() {
        return this.myBot.getTime();
    }

    public int getNumEnemyAlive() {
        return this.myBot.numEnemyBotsAlive;
    }

    public wavesManager getWavesManager() {
        return this._wavesManager;
    }

    public void run() {
        for (fighterBot fighterBot2 : liveBots.values()) {
            fighterBot2.manage();
        }
        this.myBot.execute();
    }

    public String fightType() {
        return this.myBot.fightType();
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
        this._botsmanager.onScannedRobot(scannedRobotEvent);
        for (fighterBot fighterBot2 : liveBots.values()) {
            fighterBot2.onScannedRobot(scannedRobotEvent);
        }
    }

    @Override
    public void onScannedRobot(InfoBot infoBot) {
    }

    public void specialOnScannedRobot(InfoBot infoBot) {
        String string = infoBot.getName();
        logger.noise("Time: " + this.getTime() + " Scanned bot " + string);
        fighterBot fighterBot2 = null;
        fighterBot2 = liveBots.get(string);
        if (fighterBot2 != null) {
            return;
        }
        fighterBot2 = deadBots.get(string);
        if (fighterBot2 != null) {
            logger.noise("game manager ressurecting " + string);
            logger.noise("old ref " + deadBots.get(string));
            logger.noise("new ref " + fighterBot2);
            liveBots.put(string, fighterBot2);
            deadBots.remove(string);
            return;
        }
        fighterBot2 = new fighterBot(infoBot, this);
        if (fighterBot2 == null) {
            logger.error("Something wery wrong! We should have got fighterBot for " + string);
        }
        liveBots.put(string, fighterBot2);
    }

    public void onRobotDeath(RobotDeathEvent robotDeathEvent) {
        this._botsmanager.onRobotDeath(robotDeathEvent);
        for (fighterBot fighterBot2 : liveBots.values()) {
            fighterBot2.onRobotDeath(robotDeathEvent);
        }
    }

    @Override
    public void onRobotDeath(InfoBot infoBot) {
        logger.noise("gameInfo: bot " + infoBot.getName() + " is dead");
        String string = infoBot.getName();
        fighterBot fighterBot2 = liveBots.get(string);
        deadBots.put(string, fighterBot2);
        liveBots.remove(string);
        logger.noise(this.toString());
    }

    public void onWin(WinEvent winEvent) {
        this.botsReportStats();
    }

    public void onDeath(DeathEvent deathEvent) {
        this.botsReportStats();
    }

    public void onBulletHit(BulletHitEvent bulletHitEvent) {
        HashMap<String, fighterBot> hashMap = this.getAllFighterBots();
        for (fighterBot fighterBot2 : hashMap.values()) {
            fighterBot2.onBulletHit(bulletHitEvent);
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent bulletHitBulletEvent) {
        Bullet bullet = bulletHitBulletEvent.getHitBullet();
        String string = bullet.getName();
        fighterBot fighterBot2 = this.getFighterBot(string);
        if (fighterBot2 == null) {
            return;
        }
        this.getFighterBot(this.getMasterBot().getName()).onBulletHitBullet(fighterBot2, bulletHitBulletEvent);
        fighterBot2.onBulletHitBullet(this.getFighterBot(this.getMasterBot().getName()), bulletHitBulletEvent);
    }

    public void onHitByBullet(HitByBulletEvent hitByBulletEvent) {
        HashMap<String, fighterBot> hashMap = this.getAllFighterBots();
        for (fighterBot fighterBot2 : hashMap.values()) {
            fighterBot2.onHitByBullet(hitByBulletEvent);
        }
    }

    public void onWavePassingOverBot(wave wave2, InfoBot infoBot) {
        for (fighterBot fighterBot2 : liveBots.values()) {
            fighterBot2.onWavePassingOverBot(wave2, infoBot);
        }
    }

    public HashMap<String, fighterBot> getAllFighterBots() {
        HashMap<String, fighterBot> hashMap = new HashMap<String, fighterBot>();
        hashMap.putAll(liveBots);
        hashMap.putAll(deadBots);
        return hashMap;
    }

    public void botsReportStats() {
        HashMap<String, fighterBot> hashMap = this.getAllFighterBots();
        fighterBot fighterBot2 = null;
        for (fighterBot fighterBot3 : hashMap.values()) {
            if (fighterBot3.getName().equals(this.myBot.getName())) {
                fighterBot2 = fighterBot3;
                continue;
            }
            fighterBot3.reportStats();
        }
        fighterBot2.reportStats();
    }

    public void onPaint(Graphics2D graphics2D) {
        this._botsmanager.onPaint(graphics2D);
        long l = this.myBot.getTime();
        for (fighterBot fighterBot2 : liveBots.values()) {
            fighterBot2.onPaint(graphics2D, l);
        }
    }

    public String toString() {
        String string = "";
        string = string + "Game Info stats\n";
        string = string + " liveBots known = " + liveBots.size() + "\n";
        for (fighterBot fighterBot2 : liveBots.values()) {
            string = string + "  bot: " + fighterBot2.getName() + "\n";
        }
        string = string + " deadBots known = " + deadBots.size() + "\n";
        for (fighterBot fighterBot2 : deadBots.values()) {
            string = string + "  bot: " + fighterBot2.getName() + "\n";
        }
        string = string + this._botsmanager.toString();
        return string;
    }
}

