/*
 * Decompiled with CFR 0.152.
 */
package synnalagma.mouvement;

import robocode.HitByBulletEvent;
import synnalagma.BulletTracker;
import synnalagma.mouvement.AntiGravMouvement;
import synnalagma.mouvement.MouvStrategie;

public class MouvementManager {
    private static MouvementManager single = new MouvementManager();
    private MouvStrategie[] strategies = new MouvStrategie[this.size];
    private MouvStrategie current;
    private int size = 1;

    private MouvementManager() {
        this.strategies[0] = new AntiGravMouvement();
        this.current = this.strategies[0];
        this.current.enable();
    }

    public MouvStrategie getCurrent() {
        return this.current;
    }

    public void chooseBest() {
        this.current = this.strategies[0];
    }

    public void move() {
        this.chooseBest();
        this.current.move();
    }

    public String toString() {
        String string = "\n------------------------------\nInformation Mouvement\n-------------------------\n";
        int n = 0;
        while (n < this.size) {
            string = string + this.strategies[n].toString() + "\n";
            ++n;
        }
        return string;
    }

    public void update(BulletTracker bulletTracker) {
        this.current.update(bulletTracker);
    }

    public void update(HitByBulletEvent hitByBulletEvent) {
        this.current.update(hitByBulletEvent);
    }

    public static MouvementManager getInstance() {
        return single;
    }
}

