/*
 * Decompiled with CFR 0.152.
 */
package seed.predmodel;

import seed.dataset.DatasetElement;
import seed.util.RingBuffer;

public class Regressor
extends Thread {
    protected RingBuffer<DatasetElement> sampleBuf = new RingBuffer();
    protected double[] bias;
    protected double[][] weight;
    protected double learningRate = 0.001;
    protected int epoch = 10;
    protected int batchSize;
    protected int batchStart = 0;

    public Regressor(int sampleBufSize, int xDimension, int degree) {
        this.sampleBuf.setBuffer(sampleBufSize);
        this.bias = new double[xDimension];
        this.weight = new double[degree][xDimension];
        this.batchSize = sampleBufSize;
        int i = 0;
        while (i < xDimension) {
            this.bias[i] = Math.random();
            int deg = 0;
            while (deg < degree) {
                this.weight[deg][i] = Math.random();
                ++deg;
            }
            ++i;
        }
    }

    public Regressor(int sampleBufSize, int batchSize, int xDimension, int degree) {
        this.sampleBuf.setBuffer(sampleBufSize);
        this.bias = new double[xDimension];
        this.weight = new double[degree][xDimension];
        this.batchSize = batchSize <= sampleBufSize ? batchSize : sampleBufSize;
        int i = 0;
        while (i < xDimension) {
            this.bias[i] = Math.random();
            int deg = 0;
            while (deg < degree) {
                this.weight[deg][i] = Math.random();
                ++deg;
            }
            ++i;
        }
    }

    public void addSample(DatasetElement sample) {
        if (sample == null) {
            return;
        }
        this.sampleBuf.add(sample);
    }

    public void updateModel() {
        if (this.sampleBuf.start == this.sampleBuf.end) {
            return;
        }
        int end = this.sampleBuf.end;
        int start = this.sampleBuf.start;
        int availableSize = end > start ? end - start : this.sampleBuf.buf.size() + (end - start);
        int dim = 0;
        while (dim < this.bias.length) {
            int step = 0;
            while (step < this.epoch) {
                double sigma = 0.0;
                int i = 0;
                while (i < availableSize && i < this.batchSize) {
                    DatasetElement dataset = (DatasetElement)this.sampleBuf.buf.get((this.batchStart + i) % this.batchSize);
                    if (dataset == null) {
                        return;
                    }
                    double fx = this.calcFunc(dataset.getVector().x);
                    sigma += fx - dataset.getVector().y[0];
                    ++i;
                }
                int n = dim;
                this.bias[n] = this.bias[n] - (sigma *= this.learningRate);
                ++step;
            }
            ++dim;
        }
        dim = 0;
        while (dim < this.bias.length) {
            int degree = 1;
            while (degree < this.weight.length + 1) {
                int step = 0;
                while (step < this.epoch) {
                    double sigma = 0.0;
                    int i = 0;
                    while (i < availableSize && i < this.batchSize) {
                        DatasetElement dataset = (DatasetElement)this.sampleBuf.buf.get((this.batchStart + i) % this.batchSize);
                        if (dataset == null) {
                            return;
                        }
                        double fx = this.calcFunc(dataset.getVector().x);
                        sigma += (fx - dataset.getVector().y[0]) * Math.pow(dataset.getVector().x[dim], degree);
                        ++i;
                    }
                    double[] dArray = this.weight[degree - 1];
                    int n = dim;
                    dArray[n] = dArray[n] - (sigma *= this.learningRate);
                    ++step;
                }
                ++degree;
            }
            ++dim;
        }
        if (availableSize > this.batchSize) {
            this.batchStart = this.batchStart + this.batchSize <= end ? this.batchStart + this.batchSize : start + (this.batchStart + this.batchSize - end - 1);
        }
    }

    protected double calcFunc(double[] x) {
        double value = 0.0;
        int dim = 0;
        while (dim < this.bias.length) {
            value += this.bias[dim];
            ++dim;
        }
        int degree = 1;
        while (degree <= this.weight.length) {
            int dim2 = 0;
            while (dim2 < this.weight[degree - 1].length) {
                value += this.weight[degree - 1][dim2] * Math.pow(x[dim2], degree);
                ++dim2;
            }
            ++degree;
        }
        return value;
    }

    public double predict(DatasetElement dataset) {
        if (dataset == null) {
            return 0.0;
        }
        if (dataset.getVector().x == null) {
            return 0.0;
        }
        return this.calcFunc(dataset.getVector().x);
    }

    public void printWeight() {
        System.out.print("[");
        int dim = 0;
        while (dim < this.bias.length) {
            System.out.print(this.bias[dim]);
            if (dim + 1 < this.bias.length) {
                System.out.print(",");
            } else {
                System.out.println(",");
            }
            ++dim;
        }
        int degree = 1;
        while (degree <= this.weight.length) {
            int dim2 = 0;
            while (dim2 < this.weight[degree - 1].length) {
                System.out.print(this.weight[degree - 1][dim2]);
                if (dim2 + 1 < this.weight[degree - 1].length) {
                    System.out.print(",");
                } else if (degree != this.weight.length) {
                    System.out.println(",");
                }
                ++dim2;
            }
            ++degree;
        }
        System.out.println("]");
    }

    public void printMSE() {
        if (this.sampleBuf.end == this.sampleBuf.start) {
            return;
        }
        int end = this.sampleBuf.end;
        int start = this.sampleBuf.start;
        int availableSize = end > start ? end - start : this.sampleBuf.buf.size() + (end - start);
        double mse = 0.0;
        int i = 0;
        while (i < availableSize) {
            DatasetElement dataset = (DatasetElement)this.sampleBuf.buf.get((start + i) % this.sampleBuf.buf.size());
            mse += Math.pow(dataset.getVector().y[0] - this.predict(dataset), 2.0);
            ++i;
        }
        System.out.println(mse /= (double)availableSize);
    }
}

