/*
 * Decompiled with CFR 0.152.
 */
package wcsv.mega;

import robocode.ScannedRobotEvent;
import wcsv.mega.BaseScanInfo;
import wcsv.mega.MyInfo;

public class ScanInfo {
    private BaseScanInfo[] scans;
    private int index;
    private int totalAdded;
    private double rollingLatVel;
    private int readings;
    private int timeSinceReverse;

    public ScanInfo(int depth) {
        this.scans = new BaseScanInfo[depth];
        this.index = 0;
        this.rollingLatVel = 4.0;
        this.readings = 0;
        this.timeSinceReverse = 0;
        this.totalAdded = 0;
    }

    public ScanInfo(int depth, MyInfo me, ScannedRobotEvent initial) {
        this.scans = new BaseScanInfo[depth];
        this.index = 0;
        this.add(me, initial);
        this.totalAdded = 0;
    }

    public void add(MyInfo me, ScannedRobotEvent e) {
        this.add(new BaseScanInfo(me, e));
    }

    public void add(MyInfo me, BaseScanInfo other) {
        this.add(new BaseScanInfo(other, me));
    }

    public void add(BaseScanInfo scan) {
        int i;
        ++this.totalAdded;
        if (this.index < this.scans.length) {
            i = this.index;
            while (i < this.scans.length) {
                this.scans[i] = scan;
                ++i;
            }
            ++this.index;
        } else {
            i = this.scans.length - 1;
            while (i > 0) {
                this.scans[i] = this.scans[i - 1];
                --i;
            }
            this.scans[0] = scan;
        }
        double n = Math.min(this.readings, 5);
        this.rollingLatVel = (this.rollingLatVel * n + this.scans[0].getLatVel()) / (n + 1.0);
        ++this.readings;
        if (this.scans[0].getOrbit() == 0.0) {
            this.scans[0].setOrbit(this.scans[1].getOrbit());
        }
        this.timeSinceReverse = this.scans[0].getOrbit() != this.scans[1].getOrbit() ? 0 : ++this.timeSinceReverse;
    }

    public BaseScanInfo get(int index) {
        if (this.totalAdded <= this.scans.length && this.totalAdded != 0) {
            return this.scans[this.totalAdded - 1];
        }
        return index < this.scans.length ? this.scans[index] : null;
    }

    public BaseScanInfo last() {
        return this.scans[0];
    }

    public double getAccel() {
        return this.scans[0].getVelocity() - this.scans[1].getVelocity();
    }

    public double getLatAccel() {
        return this.scans[0].getLatVel() - this.scans[1].getLatVel();
    }

    public double getRollingLatVel() {
        return this.rollingLatVel;
    }

    public double getRevTime() {
        return this.timeSinceReverse;
    }

    public double getBulletPower() {
        double delta = this.scans[1].getEnergy() - this.scans[0].getEnergy() - this.scans[0].getEnergyGain();
        if (delta < 3.001 && delta > 0.001) {
            return delta;
        }
        return -1.0;
    }
}

