/*
 * Decompiled with CFR 0.152.
 */
package wcsv.mega;

import wcsv.mega.Location;
import wcsv.mega.ScanInfo;
import wcsv.mega.Utils;

public class SegAxis {
    public double minValue;
    public double maxValue;
    public double interval;
    public int intervalCount;
    public int segments;

    public SegAxis(double min, double max, int intervals) {
        this.minValue = min;
        this.maxValue = max;
        this.intervalCount = intervals;
        this.segments = intervals + 1;
        this.interval = (max - min) / (double)intervals;
    }

    public int getIndex(double value) {
        int i = 0;
        while (i < this.segments) {
            if (value <= this.minValue + (double)i * this.interval) {
                return i;
            }
            ++i;
        }
        return this.segments;
    }

    public int wallIndex(Location center, ScanInfo scan) {
        double dist = scan.last().getDistance();
        int i = 0;
        while (i < this.segments) {
            if (Utils.outside_field(center.project((this.minValue + (double)i * this.interval) * scan.last().getOrbit() + scan.last().getBearing(), dist))) {
                return i;
            }
            ++i;
        }
        return this.segments;
    }
}

