/*
 * Decompiled with CFR 0.152.
 */
package com.spp.robocode;

import com.spp.robocode.BattlefieldModel;
import com.spp.robocode.Debug;
import com.spp.robocode.Enemy;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class RadarScanner {
    private Mode mode;
    private AdvancedRobot robot;
    private BattlefieldModel model;
    private Enemy target;
    private int scanTurns;
    private int lockTurns;

    RadarScanner(AdvancedRobot r, BattlefieldModel m) {
        this.robot = r;
        this.mode = Mode.SCANNING;
        this.scanTurns = 0;
        this.lockTurns = 0;
        this.model = m;
        this.target = null;
    }

    void startScanning() {
        this.startRescan();
    }

    void onScannedRobot(ScannedRobotEvent event) {
        if (this.mode == Mode.LOCKING) {
            ++this.lockTurns;
            if (this.target.getName().equals(event.getName())) {
                Debug.DebugScan("Locked on to " + this.target.getName());
                this.mode = Mode.LOCKED;
            }
            if (this.lockTurns > 20) {
                System.out.println("Failed to lock onto " + this.target.getName());
                this.model.onRobotDeath(this.target.getName());
                this.mode = Mode.SCANNING;
            }
        }
        if (this.mode == Mode.LOCKED) {
            double radarTurn = this.robot.getHeadingRadians() + this.target.getBearingRadians() - this.robot.getRadarHeadingRadians();
            radarTurn = (radarTurn = Utils.normalRelativeAngle((double)radarTurn)) > 0.0 ? (radarTurn += 0.4487989505128276) : (radarTurn -= 0.4487989505128276);
            this.robot.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)radarTurn));
        }
    }

    private void startRescan() {
        this.target = null;
        this.robot.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
        this.mode = Mode.SCANNING;
        this.scanTurns = 0;
    }

    void setTarget(Enemy t) {
        ++this.scanTurns;
        if (this.mode == Mode.SCANNING && this.scanTurns <= 8) {
            return;
        }
        if (t == null) {
            Debug.DebugScan("No target.");
            this.startRescan();
        } else if (this.target == null || !this.target.getName().equals(t.getName())) {
            Debug.DebugScan("Setting target to " + t.getName());
            this.target = t;
            this.mode = Mode.LOCKING;
            this.lockTurns = 0;
            if (Utils.normalRelativeAngle((double)(this.robot.getRadarHeadingRadians() - this.robot.getHeadingRadians() - this.target.getBearingRadians())) < 0.0) {
                this.robot.setTurnRadarRightRadians(Double.MAX_VALUE);
            } else {
                this.robot.setTurnRadarLeftRadians(Double.MAX_VALUE);
            }
        }
        if (this.scanTurns > 50 && this.model.numEnemies() > 1) {
            this.startRescan();
        }
    }

    static enum Mode {
        SCANNING,
        LOCKING,
        LOCKED;

    }
}

