/*
 * Decompiled with CFR 0.152.
 */
package com.spp.robocode.targeting;

import com.spp.robocode.BattlefieldModel;
import com.spp.robocode.Enemy;
import com.spp.robocode.targeting.TargetModel;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class CircularTargeting
implements TargetModel {
    private long lastTurn;

    @Override
    public double getFiringSolution(Enemy enemy, double power, AdvancedRobot robot, double robotHeading) {
        double predictedY;
        double predictedX;
        block1: {
            double retVal = 0.0;
            double myX = robot.getX();
            double myY = robot.getY();
            double absoluteBearing = robotHeading + enemy.getBearingRadians();
            double enemyX = robot.getX() + (double)enemy.getDistance() * Math.sin(absoluteBearing);
            double enemyY = robot.getY() + (double)enemy.getDistance() * Math.cos(absoluteBearing);
            double enemyHeading = enemy.getHeadingRadians();
            double enemyHeadingChange = enemyHeading - enemy.getLastHeadingRadians();
            double enemyVelocity = enemy.getVelocity();
            double deltaTime = 0.0;
            double battleFieldHeight = robot.getBattleFieldHeight();
            double battleFieldWidth = robot.getBattleFieldWidth();
            predictedX = enemyX;
            predictedY = enemyY;
            do {
                double d;
                deltaTime += 1.0;
                if (!(d * (20.0 - 3.0 * power) < Point2D.Double.distance(myX, myY, predictedX, predictedY))) break block1;
                predictedY += Math.cos(enemyHeading) * enemyVelocity;
            } while (!((predictedX += Math.sin(enemyHeading += enemyHeadingChange) * enemyVelocity) < 18.0 || predictedY < 18.0 || predictedX > battleFieldWidth - 18.0) && !(predictedY > battleFieldHeight - 18.0));
            predictedX = Math.min(Math.max(18.0, predictedX), battleFieldWidth - 18.0);
            predictedY = Math.min(Math.max(18.0, predictedY), battleFieldHeight - 18.0);
        }
        double theta = Utils.normalAbsoluteAngle((double)Math.atan2(predictedX - robot.getX(), predictedY - robot.getY()));
        return Utils.normalRelativeAngle((double)(theta - robot.getGunHeadingRadians()));
    }

    @Override
    public void onScannedRobot(AdvancedRobot robot, ScannedRobotEvent event, BattlefieldModel model) {
    }

    @Override
    public String getName() {
        return "CIRCULAR";
    }
}

