/*
 * Decompiled with CFR 0.152.
 */
package mb.movement;

import java.awt.Graphics2D;
import mb.MBRobot;
import mb.core.Coordinates;
import mb.movement.Movement;
import mb.utils.MathUtils;
import mb.utils.PaintUtils;
import robocode.HitRobotEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class WallSmoother
extends Movement {
    private PaintUtils paintUtils;
    private boolean escapeMode = false;
    private long escapeTime = 0L;

    public WallSmoother(MBRobot me) {
        super(me);
        this.movedirection = 1;
        this.minDistanceToWall = 36.0;
        this.paintUtils = new PaintUtils(me.getGraphics());
    }

    @Override
    public void onHitRobot(HitRobotEvent event) {
        this.toggleDirection();
        super.onHitRobot(event);
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent event) {
        this.paintBattleField();
        if (this.escapeMode && (double)(this.getTime() - this.escapeTime) < 100.0 / this.getVelocity()) {
            return;
        }
        this.escapeMode = false;
        int closingIn = 1;
        if (event.getDistance() < this.battleFieldHeight / 2.0) {
            closingIn = 2;
        }
        if (event.getDistance() > this.battleFieldHeight * 3.0 / 4.0) {
            closingIn = -1;
        }
        if (event.getDistance() > this.battleFieldHeight * 6.0 / 8.0) {
            // empty if block
        }
        closingIn = -2;
        double lastBearing = event.getBearing() + 90.0 + (double)(this.movedirection * closingIn);
        double angle = (this.getHeading() + lastBearing) % 360.0;
        Coordinates myCoords = this.getMyCoordinates();
        Coordinates moveTo = MathUtils.getCoordinates(myCoords, angle, 100 * this.movedirection);
        int i = 1;
        while (!this.isInsideBattleField(moveTo)) {
            angle = (this.getHeading() + (lastBearing -= (double)(this.movedirection * 2))) % 360.0;
            moveTo = MathUtils.getCoordinates(myCoords, angle, 100 * this.movedirection);
            if (++i > 20) {
                this.toggleDirection();
                i = 1;
                this.escapeMode = true;
                this.escapeTime = this.getTime();
                break;
            }
            this.paintUtils.paintVector(myCoords, angle, 100 * this.movedirection);
        }
        this.paintUtils.paintVector(myCoords, angle, 100 * this.movedirection);
        this.getRobot().setAdjustRadarForGunTurn(true);
        this.setTurnRight(lastBearing);
        this.setAhead(100 * this.movedirection);
        this.setMaxVelocity(Math.max(0.7, Utils.getRandom().nextDouble()) * 8.0);
    }

    @Override
    public void onRobotFired(ScannedRobotEvent event) {
    }

    private void paintBattleField() {
        Graphics2D graphic = this.getRobot().getGraphics();
        graphic.drawRect((int)this.minDistanceToWall, (int)this.minDistanceToWall, (int)(this.battleFieldWidth - 2.0 * this.minDistanceToWall), (int)(this.battleFieldHeight - 2.0 * this.minDistanceToWall));
    }
}

