/*
 * Decompiled with CFR 0.152.
 */
package pedersen.debug;

import java.util.LinkedList;
import java.util.Queue;
import pedersen.core.GameState;
import pedersen.debug.Console;
import pedersen.debug.Debuggable;
import pedersen.debug.Persistence;
import pedersen.util.ExceptionHandler;

public abstract class DebuggableBase
implements Debuggable {
    public static final Queue<String> fileDump = new LinkedList<String>();

    @Override
    public void debug() {
        DebuggableBase.commonDebug(this.description());
    }

    @Override
    public void console(String line) {
        DebuggableBase.commonConsole(line);
    }

    protected void consoleTick(String message) {
        DebuggableBase.commonConsole("[" + GameState.getInstance().getTurn() + "] " + message);
    }

    @Override
    public void checkpoint(String checkpoint) {
        DebuggableBase.commonCheckpoint(this, checkpoint);
    }

    @Override
    public String trim(double value) {
        return DebuggableBase.commonTrim(value);
    }

    public static void commonDebug(String description) {
        try {
            fileDump.add(description);
        }
        catch (Exception ex) {
            ExceptionHandler.handleException(ex);
        }
    }

    public static void commonConsole(String line) {
        try {
            Console.getInstance().log(line);
        }
        catch (Exception ex) {
            ExceptionHandler.handleException(ex);
        }
    }

    public static void commonCheckpoint(Object o, String checkpoint) {
        DebuggableBase.commonCheckpoint(o.getClass().getSimpleName(), checkpoint);
    }

    public static void commonCheckpoint(String o, String checkpoint) {
        DebuggableBase.commonConsole(String.valueOf(o) + " Checkpoint: " + checkpoint);
    }

    public static String commonTrim(double value) {
        String untrimmed;
        String trimmed = untrimmed = String.valueOf(value);
        int indexOfDecimal = untrimmed.indexOf(46);
        if (indexOfDecimal > 0 && untrimmed.length() > indexOfDecimal + 4) {
            trimmed = untrimmed.substring(0, indexOfDecimal + 5);
        }
        if (untrimmed.indexOf(101) > 0) {
            trimmed = String.valueOf(trimmed) + untrimmed.substring(untrimmed.indexOf(101));
        }
        if (untrimmed.indexOf(69) > 0) {
            trimmed = String.valueOf(trimmed) + untrimmed.substring(untrimmed.indexOf(69));
        }
        return trimmed;
    }

    public static void globalTeardown() {
        try {
            Persistence.writeListToFile("debug", fileDump);
        }
        catch (Exception ex) {
            ExceptionHandler.handleException(ex);
        }
    }

    @Override
    public void paint() {
        this.console("paint() not implement for " + this.getClass().getSimpleName());
    }

    @Override
    public String description() {
        return this.getClass().getName();
    }
}

