/*
 * Decompiled with CFR 0.152.
 */
package pedersen.debug;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.CharBuffer;
import java.util.LinkedList;
import java.util.Queue;
import pedersen.debug.Console;
import pedersen.util.ExceptionHandler;
import robocode.RobocodeFileOutputStream;

public class Persistence {
    private static File dataDirectory = null;

    public static void setDataDirectory(File newDataDirectory) {
        dataDirectory = newDataDirectory;
    }

    public static PrintStream getPrintStream(String filename) {
        PrintStream outputStream = null;
        File dataFile = Persistence.getDataFile(filename);
        if (dataFile != null) {
            try {
                outputStream = new PrintStream((OutputStream)new RobocodeFileOutputStream(dataFile));
            }
            catch (Exception ex) {
                ExceptionHandler.handleException(ex);
            }
        }
        return outputStream;
    }

    public static CharBuffer getFileContents(String filename) {
        CharBuffer fileContents = null;
        File dataFile = Persistence.getDataFile(filename);
        if (dataFile != null) {
            FileReader inputStream = null;
            try {
                try {
                    inputStream = new FileReader(dataFile);
                    CharBuffer buffer = CharBuffer.allocate((int)dataFile.length());
                    if (inputStream.read(buffer) == (int)dataFile.length()) {
                        fileContents = buffer;
                    }
                }
                catch (Exception ex) {
                    ExceptionHandler.handleException(ex);
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException ex2) {
                        ExceptionHandler.handleException(ex2);
                    }
                }
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException ex) {
                    ExceptionHandler.handleException(ex);
                }
            }
        }
        return fileContents;
    }

    public static void writeListToFile(String filename, Queue<String> queue) {
        PrintStream outputStream = Persistence.getPrintStream(filename);
        System.out.println("Writing " + queue.size() + " lines to " + filename + "...");
        if (outputStream != null) {
            try {
                try {
                    for (String e : queue) {
                        outputStream.println(Persistence.encrypt(e));
                    }
                }
                catch (Exception ex) {
                    ExceptionHandler.handleException(ex);
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
            }
            finally {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
        }
    }

    public static Queue<String> readListFromFile(String filename) {
        LinkedList<String> queue = new LinkedList<String>();
        CharBuffer fileContents = Persistence.getFileContents(filename);
        if (fileContents != null) {
            String buffer = fileContents.toString();
            int indexStart = 0;
            int indexEnd = buffer.indexOf("\n", indexStart);
            while (indexEnd != -1) {
                queue.add(Persistence.decrypt(buffer.substring(indexStart, indexEnd)));
                indexStart = indexEnd + 1;
                indexEnd = buffer.indexOf("\n", indexStart);
            }
        }
        return queue;
    }

    private static File getDataFile(String filename) {
        File dataFile = null;
        if (dataDirectory != null) {
            dataFile = new File(dataDirectory, Persistence.mangle(filename));
        }
        if (dataFile == null) {
            Console.getInstance().log("Access to file [" + filename + "] is denied.");
        }
        return dataFile;
    }

    private static String encrypt(String readable) {
        String unreadable = null;
        unreadable = readable;
        return unreadable;
    }

    private static String decrypt(String unreadable) {
        String readable = null;
        readable = unreadable;
        return readable;
    }

    private static String mangle(String original) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < original.length()) {
            char character = original.charAt(i);
            if (character > '/' && character < ':') {
                buffer.append(character);
            } else if (character > '@' && character < '[') {
                buffer.append(character);
            } else if (character > '`' && character < '{') {
                buffer.append(character);
            }
            ++i;
        }
        buffer.append(".txt");
        return buffer.toString();
    }
}

