/*
 * Decompiled with CFR 0.152.
 */
package pedersen.divination;

import java.util.HashSet;
import java.util.Map;
import pedersen.core.Combatant;
import pedersen.divination.BaseCombatWave;
import pedersen.divination.FiringSolution;
import pedersen.divination.TargetAnalysis;
import pedersen.opponent.Target;
import pedersen.opponent.TargetBank;
import pedersen.physics.Direction;
import pedersen.physics.HasWave;
import pedersen.physics.Snapshot;
import pedersen.targeting.TargetingMethod;

public class WaveOutboundImpl
extends BaseCombatWave {
    public final Direction firingSolution;

    public WaveOutboundImpl(HasWave wave) {
        super(wave);
        FiringSolution preferredFiringSolution = null;
        double preferredSuccessRate = 0.0;
        Snapshot agressor = Combatant.getCombatant().getHistoricalSnapshot(0L);
        for (Target e : TargetBank.getInstance().getActiveTargets()) {
            Snapshot defender = e.getHistoricalSnapshot(0L);
            TargetAnalysis targetAnalysis = new TargetAnalysis(this, agressor, defender);
            this.targetAnalyses.put(e, targetAnalysis);
            HashSet<FiringSolution> firingSolutions = new HashSet<FiringSolution>(e.getDefensiveGunCount());
            for (TargetingMethod targetingMethod : e.getDefensiveTargetingMethods()) {
                FiringSolution firingSolution = targetingMethod.getFiringSolution(this, targetAnalysis, e);
                if (firingSolution == null) continue;
                firingSolutions.add(firingSolution);
                double successRate = firingSolution.getSuccessRate();
                if (preferredFiringSolution != null && !(successRate > preferredSuccessRate)) continue;
                preferredFiringSolution = firingSolution;
                preferredSuccessRate = successRate;
            }
            this.addFiringSolutions(e, firingSolutions);
        }
        this.firingSolution = preferredFiringSolution == null ? null : preferredFiringSolution.getDirection();
    }

    @Override
    protected void recordWave() {
        for (Map.Entry e : this.targetAnalyses.entrySet()) {
            ((Target)e.getKey()).recordDefensiveWave(this, (TargetAnalysis)e.getValue());
        }
    }

    @Override
    public boolean isWaveUseful() {
        for (Target e : this.targetAnalyses.keySet()) {
            if (!e.isActive() || super.isWavePastTarget(e)) continue;
            return true;
        }
        return false;
    }
}

