/*
 * Decompiled with CFR 0.152.
 */
package pedersen.divination.analysis;

import pedersen.core.GameState;
import pedersen.debug.DebuggableBase;
import pedersen.physics.BearingOffsetRange;
import pedersen.util.BaseConstraints;
import pedersen.util.Constraints;

public class SpectrumAnalysis
extends DebuggableBase {
    protected double[] bin;
    private static final int granularity = 100;
    private static final double[] relativeBearingOffset = SpectrumAnalysis.initializeOffsets();

    public SpectrumAnalysis() {
        int size = 201;
        this.bin = new double[size];
        int i = 0;
        while (i < this.bin.length) {
            this.bin[i] = 1.0E-6 * (1.0 - Math.random());
            ++i;
        }
        assert (this.bin.length % 2 == 1) : "Bin size must be an odd number.";
    }

    private void incrementBinValueByIndex(int index, double increment) {
        if (Constraints.isInRange(0, index, this.bin.length - 1)) {
            int n = index;
            this.bin[n] = this.bin[n] + increment;
        }
    }

    private double getRelativeBearingByUnsignedIndex(int index) {
        return relativeBearingOffset[index];
    }

    public void addRange(BearingOffsetRange rangeOfIntercept, double increment) {
        if (rangeOfIntercept == null) {
            return;
        }
        int index = 0;
        while (index < relativeBearingOffset.length && rangeOfIntercept.min() > relativeBearingOffset[index]) {
            ++index;
        }
        while (index < relativeBearingOffset.length && rangeOfIntercept.max() >= relativeBearingOffset[index]) {
            this.incrementBinValueByIndex(index, increment);
            ++index;
        }
    }

    public double getRelativeBearingByPopularity() {
        int indexMostVisited = 0;
        int index = 0;
        while (index < this.bin.length) {
            if (this.bin[index] > this.bin[indexMostVisited]) {
                indexMostVisited = index;
            }
            ++index;
        }
        return this.getRelativeBearingByUnsignedIndex(indexMostVisited);
    }

    public double getRelativeBearingByProbability() {
        double random = GameState.getInstance().getPersistentRandom();
        double volume = 0.0;
        double[] dArray = this.bin;
        int n = this.bin.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            volume += value;
            ++n2;
        }
        volume *= 1.0 - random;
        int index = 0;
        while (index < this.bin.length - 1) {
            if ((volume -= this.bin[index]) <= 0.0) break;
            ++index;
        }
        return this.getRelativeBearingByUnsignedIndex(index);
    }

    private double getRelativeBearingByProbability(Double random) {
        double volume = 0.0;
        double[] dArray = this.bin;
        int n = this.bin.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            volume += value;
            ++n2;
        }
        volume *= 1.0 - random;
        int index = 0;
        while (index < this.bin.length - 1) {
            if ((volume -= this.bin[index]) <= 0.0) break;
            ++index;
        }
        return this.getRelativeBearingByUnsignedIndex(index);
    }

    public void backDoorTestPopulate() {
        int i = 0;
        while (i < this.bin.length) {
            this.bin[i] = i;
            ++i;
        }
    }

    public void backDoorTestPopulate(SpectrumAnalysis other) {
        int i = 0;
        while (i < 100000) {
            double bearing = other.getRelativeBearingByProbability(Math.random());
            BearingOffsetRange range = new BearingOffsetRange(bearing - 9.0E-4, bearing + 9.0E-4);
            this.addRange(range, 1.0);
            ++i;
        }
    }

    private static final double[] initializeOffsets() {
        double[] offset = new double[201];
        double maxValue = BaseConstraints.maxEscapeAngle;
        double valuePerIndex = maxValue / 100.0;
        int i = 0;
        while (i < offset.length) {
            offset[i] = (double)(i - 100) * valuePerIndex;
            ++i;
        }
        return offset;
    }

    public static void debugRelativeBearingOffsets() {
        int i = 0;
        while (i < relativeBearingOffset.length) {
            System.out.println("[" + i + "] " + relativeBearingOffset[i]);
            ++i;
        }
    }
}

