/*
 * Decompiled with CFR 0.152.
 */
package pedersen.util;

import pedersen.physics.Direction;
import pedersen.physics.Firepower;
import pedersen.physics.HasDirection;
import pedersen.physics.HasFirepower;
import pedersen.physics.HasPosition;
import pedersen.physics.HasVehicle;
import pedersen.physics.HasVelocity;
import pedersen.physics.Velocity;
import pedersen.physics.constant.DirectionImpl;
import pedersen.physics.constant.FirepowerImpl;
import pedersen.physics.constant.VelocityImpl;
import pedersen.util.BaseConstraints;

public class Constraints
extends BaseConstraints {
    public static final Firepower maxFirepower = new FirepowerImpl(3.0);
    public static final Firepower minFirepower = new FirepowerImpl(0.1);
    public static final Velocity maxBulletVelocity = new VelocityImpl(19.7);
    public static final Velocity minBulletVelocity = new VelocityImpl(11.0);
    public static final Velocity maxAbsVehicleVelocity = new VelocityImpl(8.0);
    public static final Direction maxAbsVehicularTurnRate = new DirectionImpl(0.17453292519943295);
    public static final Direction maxAbsTurretTurnRate = new DirectionImpl(0.3490658503988659);
    public static final Direction maxAbsRadarTurnRate = new DirectionImpl(0.7853981633974483);
    public static final Velocity maxAbsVehicularAcceleration = new VelocityImpl(1.0);
    public static final Velocity maxAbsVehicularDeceleration = new VelocityImpl(2.0);
    public static final Direction maxEscapeAngle = new DirectionImpl(Math.atan(maxAbsVehicleVelocity.velocity() / minBulletVelocity.velocity()));

    public static boolean isFirepowerLegal(HasFirepower firepower) {
        return BaseConstraints.isFirepowerLegal(firepower.getFirepower().firepower());
    }

    public static Firepower limitFirepower(HasFirepower firepower) {
        return new FirepowerImpl(BaseConstraints.limitFirepower(firepower.getFirepower().firepower()));
    }

    public static Velocity limitBulletVelocity(HasVelocity velocity) {
        return new VelocityImpl(BaseConstraints.limitBulletVelocity(velocity.getVelocity().velocity()));
    }

    public static Direction limitChassisRotation(HasDirection turnRate) {
        return new DirectionImpl(BaseConstraints.limitChassisRotation(turnRate.getDirection().getAbsoluteRadians()));
    }

    public static Velocity limitChassisVelocity(HasVelocity velocity) {
        return new VelocityImpl(BaseConstraints.limitChassisVelocity(velocity.getVelocity().velocity()));
    }

    public static Velocity limitChassisAcceleration(HasVelocity acceleration) {
        return new VelocityImpl(BaseConstraints.limitChassisAcceleration(acceleration.getVelocity().velocity()));
    }

    public static Velocity limitChassisDecelleration(HasVelocity deceleration) {
        return new VelocityImpl(BaseConstraints.limitChassisDecelleration(deceleration.getVelocity().velocity()));
    }

    public static boolean isRelativeBearingToRear(HasVehicle a, HasPosition b) {
        return Constraints.isRelativeBearingToRear(a.getVehicle().getRelativeBearing(b).getRelativeRadians());
    }
}

