/*
 * Decompiled with CFR 0.152.
 */
package mcb.tools;

import mcb.tools.FieldPoint;
import mcb.tools.RobotState;
import mcb.tools.Tools;

public class BulletWave {
    RobotState me;
    private long startTime;
    private double absoluteAngle;
    private double bulletSpeed;

    private BulletWave() {
    }

    public BulletWave(RobotState robotState, RobotState robotState2, double d, long l) {
        this.me = robotState;
        this.startTime = l;
        this.absoluteAngle = this.me.absoluteAngleTo(robotState2);
        this.bulletSpeed = 20.0 - 3.0 * d;
    }

    public double getDistanceTraveled(long l) {
        return this.bulletSpeed * (double)(l - this.startTime);
    }

    public double getAngleMiss(FieldPoint fieldPoint) {
        double d = Tools.normalRelativeAngle(Math.toDegrees(Math.atan2(fieldPoint.getX() - this.me.getX(), fieldPoint.getY() - this.me.getY())) - this.absoluteAngle);
        return d;
    }

    public FieldPoint getCenter() {
        return new FieldPoint(this.me.getX(), this.me.getY());
    }
}

