/*
 * Decompiled with CFR 0.152.
 */
package shrub;

import shrub.BodyInstruction;
import shrub.Heading;
import shrub.Location;
import shrub.MHTracker;
import shrub.MovementModeAPI;
import shrub.MovementModeMTW;
import shrub.MovementModeNOP;
import shrub.Navigator;
import shrub.RobotDataStore;
import shrub.Sighting;
import shrub.Waypoint;

public class MoveMgrMelee
implements MovementModeAPI {
    private double mDodgeDir = 1.0;
    private double mDodgeDirChangeTime = 0.0;
    private final long mDodgeDirIntervalMin = 100L;
    private final long mDodgeDirIntervalVar = 100L;
    private MovementModeAPI mMovementModeMTW = null;
    private MovementModeAPI mMovementModeNOP = null;
    private final long mWpDurationMin = 10L;
    private final long mWpDurationMax = 25L;
    private Waypoint mWaypoint = new Waypoint(Location.ZERO_ZERO, 0L, 0L);
    private final RobotDataStore mDataStore = RobotDataStore.getInstance();
    private Navigator mNavigator = Navigator.getInstance();
    private final MHTracker mTracker;
    private final double mRobotRadius = 20.0;
    private final boolean mAllowReversal = true;

    public MoveMgrMelee(MHTracker trackerRef) {
        this.mMovementModeMTW = new MovementModeMTW(true);
        this.mMovementModeNOP = new MovementModeNOP();
        this.mTracker = trackerRef;
    }

    public void setWaypointExternal(Location newLocn) {
        this.setWaypointInternal(newLocn, 0L);
    }

    public BodyInstruction[] generateInstructions() {
        double closestTgtDist;
        long wpDuration;
        BodyInstruction[] instructArray = null;
        long timeNow = this.mDataStore.getCurrentTime();
        Location robotLocn = this.mDataStore.getMyLocn();
        Heading robotHdng = this.mDataStore.getMyHdng();
        if ((double)this.mDataStore.getCurrentTime() >= this.mDodgeDirChangeTime) {
            this.mDodgeDirChangeTime += 100.0 + Math.random() * 100.0;
            this.mDodgeDir *= -1.0;
        }
        double wallAvoidDist = 50.0;
        if (this.mDataStore.getMyEnergy() < 3.05) {
            wallAvoidDist = 100.0;
        }
        if ((wpDuration = (long)((closestTgtDist = this.mTracker.FindDistanceToClosestFreshTarget()) / 25.0)) < 10L) {
            wpDuration = 10L;
        } else if (wpDuration > 25L) {
            wpDuration = 25L;
        }
        Sighting currentTarget = this.mTracker.GetCurrentTarget();
        Heading hdngToTarget = Heading.ZERO;
        if (currentTarget != null) {
            hdngToTarget = Heading.valueOfFromTo(this.mDataStore.getMyLocn(), currentTarget.GetLocation());
        }
        this.mNavigator.SetWallAvoidDistance(wallAvoidDist);
        this.mNavigator.SetEvalPowerLaw(0.5);
        if (this.mDataStore.getNumOthers() == 0L) {
            instructArray = this.mMovementModeNOP.generateInstructions();
        } else if (this.mDataStore.getCurrentTime() < 15L) {
            instructArray = this.mMovementModeNOP.generateInstructions();
        } else if (this.mTracker.GetNumFreshTargets() == 1) {
            if (closestTgtDist < 300.0) {
                ((MovementModeMTW)this.mMovementModeMTW).setTimeNow(timeNow);
                ((MovementModeMTW)this.mMovementModeMTW).setWaypoint(this.mWaypoint);
                ((MovementModeMTW)this.mMovementModeMTW).setRobotLocn(robotLocn);
                ((MovementModeMTW)this.mMovementModeMTW).setRobotHdng(robotHdng);
                instructArray = this.mMovementModeMTW.generateInstructions();
                if (this.bodyInstructsIncludeEnded(instructArray)) {
                    this.mNavigator.SetStepLength(100.0);
                    this.mNavigator.SetStepLengthVar(25.0);
                    this.mNavigator.SetNumPaths(5);
                    this.mNavigator.SetPathHdngBase(hdngToTarget.Get());
                    this.mNavigator.SetPathHdngVar(20.0);
                    Location newWp = this.mNavigator.QuantumGravWaypoint(robotLocn);
                    this.setWaypointInternal(newWp, wpDuration);
                }
            } else if (closestTgtDist > 500.0) {
                ((MovementModeMTW)this.mMovementModeMTW).setTimeNow(timeNow);
                ((MovementModeMTW)this.mMovementModeMTW).setWaypoint(this.mWaypoint);
                ((MovementModeMTW)this.mMovementModeMTW).setRobotLocn(robotLocn);
                ((MovementModeMTW)this.mMovementModeMTW).setRobotHdng(robotHdng);
                instructArray = this.mMovementModeMTW.generateInstructions();
                if (this.bodyInstructsIncludeEnded(instructArray)) {
                    Location newWp = this.mNavigator.RandomWaypointAbs();
                    this.setWaypointInternal(newWp, wpDuration);
                }
            } else {
                double shotAtPower = -1.0;
                if (this.mDataStore.getCurrentTime() > 30L && this.mTracker.GetNumFreshTargets() == 1) {
                    shotAtPower = this.mTracker.BulletFireDetection();
                }
                if (shotAtPower > 0.001) {
                    double pathBaseAngle = 90.0;
                    Heading perpToTarget = Heading.valueOfAdjust(hdngToTarget, this.mDodgeDir * 90.0);
                    this.mNavigator.SetStepLength(100.0);
                    this.mNavigator.SetStepLengthVar(50.0);
                    this.mNavigator.SetNumPaths(1);
                    this.mNavigator.SetPathHdngBase(perpToTarget.Get());
                    this.mNavigator.SetPathHdngVar(60.0);
                    this.actOnBulletFireDetection(wpDuration);
                }
                ((MovementModeMTW)this.mMovementModeMTW).setTimeNow(timeNow);
                ((MovementModeMTW)this.mMovementModeMTW).setWaypoint(this.mWaypoint);
                ((MovementModeMTW)this.mMovementModeMTW).setRobotLocn(robotLocn);
                ((MovementModeMTW)this.mMovementModeMTW).setRobotHdng(robotHdng);
                instructArray = this.mMovementModeMTW.generateInstructions();
            }
        } else {
            ((MovementModeMTW)this.mMovementModeMTW).setTimeNow(timeNow);
            ((MovementModeMTW)this.mMovementModeMTW).setWaypoint(this.mWaypoint);
            ((MovementModeMTW)this.mMovementModeMTW).setRobotLocn(robotLocn);
            ((MovementModeMTW)this.mMovementModeMTW).setRobotHdng(robotHdng);
            instructArray = this.mMovementModeMTW.generateInstructions();
            if (this.bodyInstructsIncludeEnded(instructArray)) {
                this.mNavigator.SetStepLength(100.0);
                this.mNavigator.SetStepLengthVar(25.0);
                this.mNavigator.SetNumPaths(7);
                this.mNavigator.SetPathHdngBase(hdngToTarget.Get());
                this.mNavigator.SetPathHdngVar(20.0);
                Location newWp = this.mNavigator.QuantumGravWaypoint(robotLocn);
                this.setWaypointInternal(newWp, wpDuration);
            }
        }
        return instructArray;
    }

    private void setWaypointInternal(Location newLocn, long duration) {
        long timeNow = this.mDataStore.getCurrentTime();
        this.mWaypoint = new Waypoint(newLocn, timeNow, duration);
    }

    private boolean bodyInstructsIncludeEnded(BodyInstruction[] instructs) {
        boolean answer = false;
        int numElements = instructs.length;
        for (int index = 0; index < numElements && !answer; ++index) {
            BodyInstruction thisInstruct = instructs[index];
            if (thisInstruct.getType() != BodyInstruction.ENDED) continue;
            answer = true;
        }
        return answer;
    }

    public void actOnRobotHitWall() {
        Location robotLocn = this.mDataStore.getMyLocn();
        Location newWp = this.mNavigator.QuantumGravWaypoint(robotLocn);
        this.setWaypointInternal(newWp, 10L);
    }

    private void actOnBulletFireDetection(long wpDuration) {
        Location robotLocn = this.mDataStore.getMyLocn();
        Location newWp = this.mNavigator.RandomWaypointRel(robotLocn);
        this.setWaypointInternal(newWp, wpDuration);
    }
}

