/*
 * Decompiled with CFR 0.152.
 */
package shrub;

import java.text.NumberFormat;
import shrub.Bearing;
import shrub.Box;
import shrub.Heading;
import shrub.Line;
import shrub.Location;
import shrub.Sighting;

public class Movement {
    public static final Movement NULL_MOVE = new Movement(0.0, Location.ZERO_ZERO, Heading.ZERO, Bearing.ZERO, 0.0, 0L, false, 0L, 0L);
    private final double mVelocityNow;
    private final Location mLocnNow;
    private final Heading mHdngNow;
    private final Bearing mHdngDelta;
    private final boolean mIsEstimate;
    private final long mEstimationTicks;
    private final double mEnergyNow;
    private final long mTimeNow;
    private final long mTimeDelta;
    private static final NumberFormat dp2 = NumberFormat.getInstance();

    public static Movement valueOf(double velocityNow, Location locnNow, Heading hdngNow, Bearing hdngDelta, double energyNow, long estimationTicks, boolean isEstimate, long timeAt, long timeDelta) {
        Movement newObj = new Movement(velocityNow, locnNow, hdngNow, hdngDelta, energyNow, estimationTicks, isEstimate, timeAt, timeDelta);
        return newObj;
    }

    private Movement(double velocityNow, Location locnNow, Heading hdngNow, Bearing hdngDelta, double energyNow, long estimationTicks, boolean isEstimate, long timeAt, long timeDelta) {
        this.mVelocityNow = velocityNow;
        this.mLocnNow = locnNow;
        this.mHdngNow = hdngNow;
        this.mHdngDelta = hdngDelta;
        this.mEnergyNow = energyNow;
        this.mEstimationTicks = estimationTicks;
        this.mIsEstimate = isEstimate;
        this.mTimeNow = timeAt;
        this.mTimeDelta = timeDelta;
    }

    public final long GetTimeNow() {
        return this.mTimeNow;
    }

    public final long GetTimeDelta() {
        return this.mTimeDelta;
    }

    public final double GetVelocityNow() {
        return this.mVelocityNow;
    }

    public final Location GetLocnNow() {
        return this.mLocnNow;
    }

    public final Heading GetHdngNow() {
        return this.mHdngNow;
    }

    public final Bearing GetHdngDelta() {
        return this.mHdngDelta;
    }

    public final boolean GetIsEstimate() {
        return this.mIsEstimate;
    }

    public final long GetEstimationTicks() {
        return this.mEstimationTicks;
    }

    public final double GetEnergyNow() {
        return this.mEnergyNow;
    }

    public static Movement valueOfExtrapolation(Movement startMove, long res_TimeNow, Box allowedArea, Movement deltaMoveSupplied) {
        Movement answer = null;
        long res_TimeDelta = res_TimeNow - startMove.GetTimeNow();
        if (res_TimeDelta < 0L) {
            System.out.println("ERROR: Movement::valueOfExtrapolation, time delta < 0");
        } else if (res_TimeDelta != 0L) {
            double res_VelocityNow;
            Location res_LocnNow;
            Bearing res_HdngDelta;
            double deltaVelocity;
            if (deltaMoveSupplied == null) {
                deltaVelocity = startMove.GetVelocityNow();
                res_HdngDelta = startMove.GetHdngDelta();
            } else {
                deltaVelocity = deltaMoveSupplied.GetVelocityNow();
                res_HdngDelta = deltaMoveSupplied.GetHdngDelta();
            }
            long res_EstimationTicks = startMove.GetEstimationTicks() + res_TimeDelta;
            double res_EnergyNow = startMove.GetEnergyNow();
            Heading res_HdngNow = Heading.valueOfAdjust(startMove.GetHdngNow(), res_HdngDelta.Get() * (double)res_TimeDelta);
            Location newExtrapLocn = Location.valueOfRelative(startMove.GetLocnNow(), res_HdngNow, deltaVelocity * (double)res_TimeDelta);
            if (allowedArea == null) {
                res_LocnNow = newExtrapLocn;
                res_VelocityNow = deltaVelocity;
            } else if (allowedArea.IsInside(startMove.GetLocnNow())) {
                if (allowedArea.IsInside(newExtrapLocn)) {
                    res_LocnNow = newExtrapLocn;
                    res_VelocityNow = deltaVelocity;
                } else {
                    Line moveLine;
                    Location intLocn;
                    Heading adjHdng = res_HdngNow;
                    if (deltaVelocity > 0.0) {
                        adjHdng = Heading.valueOfFlip(res_HdngNow);
                    }
                    if ((intLocn = allowedArea.EdgeIntersectOutward(moveLine = Line.valueOfStartHdng(startMove.GetLocnNow(), adjHdng))) == null) {
                        System.out.println("ERROR: Movement::Extrapolate(), intersect locn null");
                        res_LocnNow = startMove.GetLocnNow();
                        res_VelocityNow = 0.0;
                    } else {
                        res_LocnNow = intLocn;
                        res_VelocityNow = 0.0;
                    }
                }
            } else {
                res_LocnNow = startMove.GetLocnNow();
                res_VelocityNow = 0.0;
            }
            boolean res_IsEstimate = true;
            answer = Movement.valueOf(res_VelocityNow, res_LocnNow, res_HdngNow, res_HdngDelta, res_EnergyNow, res_EstimationTicks, true, res_TimeNow, res_TimeDelta);
        }
        return answer;
    }

    public static Movement valueOfSighting(Sighting fromSight) {
        Movement answer = Movement.valueOfSightingPlus(fromSight, Bearing.ZERO, 0L);
        return answer;
    }

    public static Movement valueOfSightingPlus(Sighting fromSight, Bearing hdngDelta, long timeDelta) {
        boolean isEstimation = fromSight.GetInaccuracy() > 0;
        Movement newObj = new Movement(fromSight.GetVelocity(), fromSight.GetLocation(), fromSight.GetHeading(), hdngDelta, fromSight.GetEnergy(), fromSight.GetInaccuracy(), isEstimation, fromSight.GetTimestamp(), timeDelta);
        return newObj;
    }

    public Sighting ToSighting(String name) {
        Sighting answer = Sighting.valueOf(name, this.mVelocityNow, this.mLocnNow, this.mHdngNow, this.mEnergyNow, (int)this.mEstimationTicks, this.mTimeNow);
        return answer;
    }

    public String toString() {
        String answer = "<Movement : Time " + this.mTimeNow + ">";
        return answer;
    }

    public void Print() {
        System.out.println("========== Movement ==========");
        System.out.print(" Time: " + this.mTimeNow);
        System.out.print(" Delta: " + this.mTimeDelta);
        System.out.println();
    }

    static {
        dp2.setMaximumFractionDigits(2);
        dp2.setMinimumFractionDigits(2);
    }
}

