/*
 * Decompiled with CFR 0.152.
 */
package rdm;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rdm.drivers.Driver;
import rdm.drivers.RandomDriver;
import rdm.gunners.Gunner;
import rdm.gunners.dnn.DnnGunner;
import rdm.precepts.GunPrecept;
import rdm.robots.AdvancedRobotExtensionsKt;
import rdm.state.Bullet;
import rdm.state.EnemyBullets;
import rdm.state.StateCollectorImpl;
import rdm.state.entities.InstantState;
import rdm.state.entities.State;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\nH\u0002J\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0012\u0010\u001b\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001cH\u0016J\u0012\u0010\u001d\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!H\u0016J\u0012\u0010\"\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010#H\u0016J\b\u0010$\u001a\u00020\u0018H\u0016J\u001c\u0010%\u001a\u00020&2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lrdm/Dueler;", "Lrobocode/AdvancedRobot;", "()V", "collector", "Lrdm/state/StateCollectorImpl;", "driver", "Lrdm/drivers/Driver;", "enemyBullets", "Lrdm/state/EnemyBullets;", "gunner", "Lrdm/gunners/Gunner;", "lastPrecept", "Lkotlin/Pair;", "Lrdm/state/entities/State;", "Lrdm/precepts/GunPrecept;", "movementProfile", "", "myBullets", "", "Lrobocode/Bullet;", "buildDriver", "Lrdm/drivers/RandomDriver;", "buildGunner", "onBulletHit", "", "event", "Lrobocode/BulletHitEvent;", "onBulletHitBullet", "Lrobocode/BulletHitBulletEvent;", "onBulletMissed", "Lrobocode/BulletMissedEvent;", "onPaint", "g", "Ljava/awt/Graphics2D;", "onScannedRobot", "Lrobocode/ScannedRobotEvent;", "run", "setFireIfGunTurningDone", "", "precept", "Dueler"})
public final class Dueler
extends AdvancedRobot {
    private final StateCollectorImpl collector = StateCollectorImpl.INSTANCE;
    private final List<robocode.Bullet> myBullets;
    private EnemyBullets enemyBullets;
    private Driver driver;
    private Gunner gunner;
    private int[] movementProfile;
    private Pair<State, GunPrecept> lastPrecept;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.collector.onRoundStart();
        this.enemyBullets = new EnemyBullets(Math.sqrt(Math.pow(this.getBattleFieldWidth(), 2.0) + Math.pow(this.getBattleFieldHeight(), 2.0)));
        this.driver = this.buildDriver();
        this.gunner = this.buildGunner();
        this.lastPrecept = null;
        try {
            try {
                this.setBodyColor(Color.ORANGE);
                this.setGunColor(Color.RED);
                this.setRadarColor(Color.BLACK);
                this.setBulletColor(Color.WHITE);
                this.setAdjustGunForRobotTurn(true);
                this.setAdjustRadarForGunTurn(true);
                while (true) {
                    EnemyBullets enemyBullets = this.enemyBullets;
                    if (enemyBullets == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("enemyBullets");
                    }
                    enemyBullets.tick();
                    if (this.getRadarTurnRemaining() == 0.0) {
                        this.setTurnRadarRightRadians(DoubleCompanionObject.INSTANCE.getPOSITIVE_INFINITY());
                    }
                    Driver driver = this.driver;
                    if (driver == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("driver");
                    }
                    AdvancedRobotExtensionsKt.setMoveTo((AdvancedRobot)this, driver.getDestination());
                    this.execute();
                }
            }
            catch (Error error) {
                throw (Throwable)error;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                Gunner gunner = this.gunner;
                if (gunner == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("gunner");
                }
                gunner.dispose();
                this.collector.onRoundStop();
            }
        }
        catch (Throwable throwable) {
            Gunner gunner = this.gunner;
            if (gunner == null) {
                Intrinsics.throwUninitializedPropertyAccessException("gunner");
            }
            gunner.dispose();
            this.collector.onRoundStop();
            throw throwable;
        }
    }

    public void onScannedRobot(@Nullable ScannedRobotEvent event) {
        ScannedRobotEvent scannedRobotEvent = event;
        if (scannedRobotEvent == null) {
            Intrinsics.throwNpe();
        }
        InstantState instant = AdvancedRobotExtensionsKt.instantStateOf(this, scannedRobotEvent, CollectionsKt.toList((Iterable)this.myBullets));
        EnemyBullets enemyBullets = this.enemyBullets;
        if (enemyBullets == null) {
            Intrinsics.throwUninitializedPropertyAccessException("enemyBullets");
        }
        enemyBullets.onScannedRobot(instant);
        Driver driver = this.driver;
        if (driver == null) {
            Intrinsics.throwUninitializedPropertyAccessException("driver");
        }
        EnemyBullets enemyBullets2 = this.enemyBullets;
        if (enemyBullets2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("enemyBullets");
        }
        driver.onScannedRobot(instant, enemyBullets2.getBullets());
        try {
            AdvancedRobotExtensionsKt.lockRadarOnTarget(this, event);
            State state = this.collector.collect(instant);
            Gunner gunner = this.gunner;
            if (gunner == null) {
                Intrinsics.throwUninitializedPropertyAccessException("gunner");
            }
            GunPrecept precept = gunner.getShotPrecept(state);
            this.movementProfile = state.getAggregate().getMovementProfile();
            Pair<State, GunPrecept> finalLastPrecept = this.lastPrecept;
            if (finalLastPrecept == null) {
                boolean shouldFire;
                AdvancedRobotExtensionsKt.lockGunOnTarget(this, event, precept.getRotation());
                boolean bl = shouldFire = AdvancedRobotExtensionsKt.getCanFire(this) && precept.getShouldFire();
                if (shouldFire) {
                    this.lastPrecept = new Pair<State, GunPrecept>(state, precept);
                }
            } else {
                Pair<State, GunPrecept> stateAndPrecept = finalLastPrecept;
                if (this.setFireIfGunTurningDone(stateAndPrecept)) {
                    this.lastPrecept = null;
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void onBulletHit(@Nullable BulletHitEvent event) {
        BulletHitEvent bulletHitEvent = event;
        if (bulletHitEvent == null) {
            Intrinsics.throwNpe();
        }
        this.myBullets.remove(bulletHitEvent.getBullet());
        Gunner gunner = this.gunner;
        if (gunner == null) {
            Intrinsics.throwUninitializedPropertyAccessException("gunner");
        }
        robocode.Bullet bullet = event.getBullet();
        Intrinsics.checkExpressionValueIsNotNull(bullet, "event.bullet");
        gunner.saveShotResult(bullet, true);
    }

    public void onBulletHitBullet(@Nullable BulletHitBulletEvent event) {
        BulletHitBulletEvent bulletHitBulletEvent = event;
        if (bulletHitBulletEvent == null) {
            Intrinsics.throwNpe();
        }
        robocode.Bullet hitBullet = bulletHitBulletEvent.getHitBullet();
        EnemyBullets enemyBullets = this.enemyBullets;
        if (enemyBullets == null) {
            Intrinsics.throwUninitializedPropertyAccessException("enemyBullets");
        }
        robocode.Bullet bullet = hitBullet;
        Intrinsics.checkExpressionValueIsNotNull(bullet, "hitBullet");
        enemyBullets.onBulletHitBullet(new Point2D.Double(bullet.getX(), hitBullet.getY()), hitBullet.getHeading());
        this.myBullets.remove(event.getBullet());
        Gunner gunner = this.gunner;
        if (gunner == null) {
            Intrinsics.throwUninitializedPropertyAccessException("gunner");
        }
        robocode.Bullet bullet2 = event.getBullet();
        Intrinsics.checkExpressionValueIsNotNull(bullet2, "event.bullet");
        gunner.saveShotResult(bullet2, null);
    }

    public void onBulletMissed(@Nullable BulletMissedEvent event) {
        BulletMissedEvent bulletMissedEvent = event;
        if (bulletMissedEvent == null) {
            Intrinsics.throwNpe();
        }
        this.myBullets.remove(bulletMissedEvent.getBullet());
        Gunner gunner = this.gunner;
        if (gunner == null) {
            Intrinsics.throwUninitializedPropertyAccessException("gunner");
        }
        robocode.Bullet bullet = event.getBullet();
        Intrinsics.checkExpressionValueIsNotNull(bullet, "event.bullet");
        gunner.saveShotResult(bullet, false);
    }

    /*
     * WARNING - void declaration
     */
    public void onPaint(@NotNull Graphics2D g) {
        Object diameter;
        Bullet it;
        Object element$iv;
        Intrinsics.checkParameterIsNotNull(g, "g");
        g.setColor(Color.BLUE);
        int n = (int)this.getX();
        int n2 = (int)this.getY();
        Driver driver = this.driver;
        if (driver == null) {
            Intrinsics.throwUninitializedPropertyAccessException("driver");
        }
        int n3 = (int)driver.getDestination().getX();
        Driver driver2 = this.driver;
        if (driver2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("driver");
        }
        g.drawLine(n, n2, n3, (int)driver2.getDestination().getY());
        g.setColor(Color.RED);
        EnemyBullets enemyBullets = this.enemyBullets;
        if (enemyBullets == null) {
            Intrinsics.throwUninitializedPropertyAccessException("enemyBullets");
        }
        Object $receiver$iv = enemyBullets.getBullets();
        Iterator iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            it = (Bullet)element$iv;
            int radius = (int)it.getDistance();
            diameter = 2 * radius;
            int x = (int)it.getFirePoint().getX();
            int y = (int)it.getFirePoint().getY();
            g.drawOval(x - 5, y - 5, 10, 10);
            g.drawOval(x - radius, y - radius, (int)diameter, (int)diameter);
        }
        g.setColor(Color.YELLOW);
        $receiver$iv = this.myBullets;
        iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            it = (robocode.Bullet)element$iv;
            g.drawOval((int)it.getX() - 5, (int)it.getY() - 5, 10, 10);
            double x = it.getX() + (double)10 * it.getPower() * Math.sin(it.getHeadingRadians());
            double y = it.getY() + (double)10 * it.getPower() * Math.cos(it.getHeadingRadians());
            g.drawLine((int)it.getX(), (int)it.getY(), (int)x, (int)y);
        }
        g.setColor(Color.YELLOW);
        $receiver$iv = this.movementProfile;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void value;
            int n4 = index$iv++;
            diameter = item$iv;
            int index = n4;
            int width = 5;
            void height = value / 2;
            int x = index * width;
            g.drawRect(x + width, 5, width, (int)height);
        }
    }

    private final boolean setFireIfGunTurningDone(Pair<State, GunPrecept> precept) {
        boolean bl;
        if (Utils.isNear((double)this.getGunTurnRemaining(), (double)0.0)) {
            robocode.Bullet bullet;
            robocode.Bullet bullet2 = bullet = this.setFireBullet(precept.getSecond().getBulletPower());
            if (bullet2 != null) {
                robocode.Bullet bullet3;
                robocode.Bullet it = bullet3 = bullet2;
                this.myBullets.add(0, bullet);
                Gunner gunner = this.gunner;
                if (gunner == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("gunner");
                }
                gunner.saveShot(bullet, precept.getFirst(), precept.getSecond());
            }
            bl = bullet != null;
        } else {
            bl = false;
        }
        return bl;
    }

    private final Gunner buildGunner() {
        Gunner gunner;
        try {
            File file = this.getDataFile("dataset.csv");
            File file2 = file;
            Intrinsics.checkExpressionValueIsNotNull(file2, "file");
            gunner = new DnnGunner(file2);
            Unit unit = Unit.INSTANCE;
        }
        catch (IOException exception) {
            System.err.println(exception.getMessage());
            throw (Throwable)exception;
        }
        return gunner;
    }

    private final RandomDriver buildDriver() {
        return new RandomDriver(new Point2D.Double(this.getBattleFieldWidth() / (double)2, this.getBattleFieldHeight() / (double)2));
    }

    public Dueler() {
        List list;
        Dueler dueler = this;
        dueler.myBullets = list = (List)new ArrayList();
        this.movementProfile = new int[]{0};
    }
}

