/*
 * Decompiled with CFR 0.152.
 */
package jwirde;

import java.awt.Color;
import java.awt.Graphics2D;
import jwirde.Ghost;
import jwirde.Gun;
import robocode.AdvancedRobot;
import robocode.Bullet;

public abstract class BaseGun
implements Gun {
    protected final AdvancedRobot myRobot;
    protected double nextBulletPower = -1.0;

    public BaseGun(AdvancedRobot robot) {
        this.myRobot = robot;
    }

    @Override
    public Bullet fire() {
        return this.myRobot.setFireBullet(this.nextBulletPower);
    }

    @Override
    public void aim(Ghost ghost) {
        this.nextBulletPower = this.chooseGunPower(ghost);
        this.doAim(ghost);
    }

    protected abstract void doAim(Ghost var1);

    protected double chooseGunPower(Ghost target) {
        double power = 3.0;
        if (target.distance > 800.0) {
            power *= 0.15;
        } else if (target.distance > 400.0) {
            power *= 0.3;
        } else if (target.distance > 200.0) {
            power *= 0.6;
        } else if (target.distance > 100.0) {
            power = 0.9;
        }
        return power;
    }

    @Override
    public void onPaint(Graphics2D g) {
        g.setColor(Color.WHITE);
        g.drawString("power: " + this.nextBulletPower, 10, 50);
    }
}

